/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.modules.core.model.sensor.state;

import bsc.api.modules.core.model.sensor.state.ActorContainer;
import bsc.api.modules.core.model.sensor.state.AlarmSensor;
import bsc.api.modules.core.model.sensor.state.AlarmSirenMonitored;
import bsc.api.modules.core.model.sensor.state.ButtonSensor;
import bsc.api.modules.core.model.sensor.state.CardSwitch;
import bsc.api.modules.core.model.sensor.state.DetectionSensor;
import bsc.api.modules.core.model.sensor.state.EnabledSensor;
import bsc.api.modules.core.model.sensor.state.OnSensor;
import bsc.api.modules.core.model.sensor.state.OpenSensor;
import bsc.api.modules.core.model.sensor.state.OperatingMode;
import bsc.api.modules.core.model.sensor.state.OperatingModeRestriction;
import bsc.api.modules.core.model.sensor.state.ThreeStatePriority;
import bsc.api.modules.core.model.sensor.state.TriggerSensor;
import bsc.api.modules.core.model.sensor.state.UpSensor;
import bsc.api.modules.core.model.sensor.state.UpSensorSlat;
import java.util.ArrayList;
import java.util.List;

public class StateHelper {
    public static <T extends Enum<T>> List<T> getNextPossibleStates(T currentState) {
        if (currentState instanceof TriggerSensor.State) {
            return StateHelper.getNextPossibleStates((TriggerSensor.State)currentState);
        }
        if (currentState instanceof OperatingMode.State) {
            return StateHelper.getNextPossibleStates((OperatingMode.State)currentState);
        }
        if (currentState instanceof OperatingModeRestriction.State) {
            return StateHelper.getNextPossibleStates((OperatingModeRestriction.State)currentState);
        }
        if (currentState instanceof OnSensor.State) {
            return StateHelper.getNextPossibleStates((OnSensor.State)currentState);
        }
        if (currentState instanceof OpenSensor.State) {
            return StateHelper.getNextPossibleStates((OpenSensor.State)currentState);
        }
        if (currentState instanceof ActorContainer.State) {
            return StateHelper.getNextPossibleStates((ActorContainer.State)currentState);
        }
        if (currentState instanceof CardSwitch.State) {
            return StateHelper.getNextPossibleStates((CardSwitch.State)currentState);
        }
        if (currentState instanceof DetectionSensor.State) {
            return StateHelper.getNextPossibleStates((DetectionSensor.State)currentState);
        }
        if (currentState instanceof UpSensor.State) {
            return StateHelper.getNextPossibleStates((UpSensor.State)currentState);
        }
        if (currentState instanceof EnabledSensor.State) {
            return StateHelper.getNextPossibleStates((EnabledSensor.State)currentState);
        }
        if (currentState instanceof ButtonSensor.State) {
            return StateHelper.getNextPossibleStates((ButtonSensor.State)currentState);
        }
        if (currentState instanceof AlarmSensor.State) {
            return StateHelper.getNextPossibleStates((AlarmSensor.State)currentState);
        }
        if (currentState instanceof UpSensorSlat.State) {
            return StateHelper.getNextPossibleStates((UpSensorSlat.State)currentState);
        }
        if (currentState instanceof AlarmSirenMonitored.State) {
            return StateHelper.getNextPossibleStates((AlarmSirenMonitored.State)currentState);
        }
        if (currentState instanceof ThreeStatePriority.State) {
            return StateHelper.getNextPossibleStates((ThreeStatePriority.State)currentState);
        }
        return null;
    }

    public static List<ThreeStatePriority.State> getNextPossibleStates(ThreeStatePriority.State currentState) {
        ArrayList<ThreeStatePriority.State> states = new ArrayList<ThreeStatePriority.State>();
        switch (currentState) {
            case PRIORITY_MODE: {
                states.add(ThreeStatePriority.State.PLUS_MINUS_3K_LIMITER);
                break;
            }
            case PLUS_MINUS_3K_LIMITER: {
                states.add(ThreeStatePriority.State.NO_PRIORITY);
                break;
            }
            case NO_PRIORITY: {
                states.add(ThreeStatePriority.State.PRIORITY_MODE);
            }
        }
        return states;
    }

    public static List<AlarmSirenMonitored.State> getNextPossibleStates(AlarmSirenMonitored.State currentState) {
        ArrayList<AlarmSirenMonitored.State> states = new ArrayList<AlarmSirenMonitored.State>();
        switch (currentState) {
            case ON: {
                states.add(AlarmSirenMonitored.State.OFF_MONITORED);
                break;
            }
            case OFF_MONITORED: {
                states.add(AlarmSirenMonitored.State.OFF_NOT_MONITORED);
                break;
            }
            case OFF_NOT_MONITORED: {
                states.add(AlarmSirenMonitored.State.ON);
            }
        }
        return states;
    }

    public static List<TriggerSensor.State> getNextPossibleStates(TriggerSensor.State currentState) {
        ArrayList<TriggerSensor.State> states = new ArrayList<TriggerSensor.State>();
        states.add(TriggerSensor.State.TRIGGERED);
        return states;
    }

    public static List<OperatingMode.State> getNextPossibleStates(OperatingMode.State currentState) {
        ArrayList<OperatingMode.State> states = new ArrayList<OperatingMode.State>();
        switch (currentState) {
            case OFF: {
                states.add(OperatingMode.State.NORMAL_MODE);
                states.add(OperatingMode.State.SETBACK_MODE_2K);
                states.add(OperatingMode.State.SETBACK_MODE_4K);
                break;
            }
            case NORMAL_MODE: {
                states.add(OperatingMode.State.OFF);
                states.add(OperatingMode.State.SETBACK_MODE_2K);
                states.add(OperatingMode.State.SETBACK_MODE_4K);
                break;
            }
            case SETBACK_MODE_2K: {
                states.add(OperatingMode.State.OFF);
                states.add(OperatingMode.State.NORMAL_MODE);
                states.add(OperatingMode.State.SETBACK_MODE_4K);
                break;
            }
            case SETBACK_MODE_4K: {
                states.add(OperatingMode.State.OFF);
                states.add(OperatingMode.State.NORMAL_MODE);
                states.add(OperatingMode.State.SETBACK_MODE_2K);
                break;
            }
            case UNKNOWN: {
                states.add(OperatingMode.State.OFF);
                states.add(OperatingMode.State.NORMAL_MODE);
                states.add(OperatingMode.State.SETBACK_MODE_2K);
                states.add(OperatingMode.State.SETBACK_MODE_4K);
            }
        }
        return states;
    }

    public static List<OperatingModeRestriction.State> getNextPossibleStates(OperatingModeRestriction.State currentState) {
        ArrayList<OperatingModeRestriction.State> states = new ArrayList<OperatingModeRestriction.State>();
        switch (currentState) {
            case NORMAL_MODE: {
                states.add(OperatingModeRestriction.State.PRIORITY_MODE);
                states.add(OperatingModeRestriction.State.PLUS_MINUS_3K);
                break;
            }
            case PRIORITY_MODE: {
                states.add(OperatingModeRestriction.State.NORMAL_MODE);
                states.add(OperatingModeRestriction.State.PLUS_MINUS_3K);
                break;
            }
            case PLUS_MINUS_3K: {
                states.add(OperatingModeRestriction.State.NORMAL_MODE);
                states.add(OperatingModeRestriction.State.PRIORITY_MODE);
                break;
            }
            case UNKNOWN: {
                states.add(OperatingModeRestriction.State.NORMAL_MODE);
                states.add(OperatingModeRestriction.State.PRIORITY_MODE);
                states.add(OperatingModeRestriction.State.PLUS_MINUS_3K);
            }
        }
        return states;
    }

    public static List<OnSensor.State> getNextPossibleStates(OnSensor.State currentState) {
        ArrayList<OnSensor.State> states = new ArrayList<OnSensor.State>();
        switch (currentState) {
            case OFF: {
                states.add(OnSensor.State.ON);
                break;
            }
            case ON: {
                states.add(OnSensor.State.OFF);
                break;
            }
            case UNKNOWN: {
                states.add(OnSensor.State.ON);
                states.add(OnSensor.State.OFF);
            }
        }
        return states;
    }

    public static List<OpenSensor.State> getNextPossibleStates(OpenSensor.State currentState) {
        ArrayList<OpenSensor.State> states = new ArrayList<OpenSensor.State>();
        switch (currentState) {
            case OPENED: {
                states.add(OpenSensor.State.CLOSED);
                break;
            }
            case CLOSED: {
                states.add(OpenSensor.State.OPENED);
                break;
            }
            case UNKNOWN: {
                states.add(OpenSensor.State.OPENED);
                states.add(OpenSensor.State.CLOSED);
            }
        }
        return states;
    }

    public static List<ActorContainer.State> getNextPossibleStates(ActorContainer.State currentState) {
        ArrayList<ActorContainer.State> states = new ArrayList<ActorContainer.State>();
        switch (currentState) {
            case RUNNING: {
                states.add(ActorContainer.State.STOPPED);
                break;
            }
            case STOPPED: {
                states.add(ActorContainer.State.RUNNING);
                break;
            }
            case UNKNOWN: {
                states.add(ActorContainer.State.RUNNING);
                states.add(ActorContainer.State.STOPPED);
            }
        }
        return states;
    }

    public static List<CardSwitch.State> getNextPossibleStates(CardSwitch.State currentState) {
        ArrayList<CardSwitch.State> states = new ArrayList<CardSwitch.State>();
        switch (currentState) {
            case OFF: {
                states.add(CardSwitch.State.OCCUPIED);
                states.add(CardSwitch.State.SERVICE);
                break;
            }
            case OCCUPIED: {
                states.add(CardSwitch.State.OFF);
                states.add(CardSwitch.State.SERVICE);
                break;
            }
            case SERVICE: {
                states.add(CardSwitch.State.OFF);
                states.add(CardSwitch.State.OCCUPIED);
                break;
            }
            case UNKNOWN: {
                states.add(CardSwitch.State.OFF);
                states.add(CardSwitch.State.OCCUPIED);
                states.add(CardSwitch.State.SERVICE);
            }
        }
        return states;
    }

    public static List<DetectionSensor.State> getNextPossibleStates(DetectionSensor.State currentState) {
        ArrayList<DetectionSensor.State> states = new ArrayList<DetectionSensor.State>();
        switch (currentState) {
            case DETECTED: {
                states.add(DetectionSensor.State.UNDETECTED);
                break;
            }
            case UNDETECTED: {
                states.add(DetectionSensor.State.DETECTED);
                break;
            }
            case UNKNOWN: {
                states.add(DetectionSensor.State.DETECTED);
                states.add(DetectionSensor.State.UNDETECTED);
            }
        }
        return states;
    }

    public static List<UpSensor.State> getNextPossibleStates(UpSensor.State currentState) {
        ArrayList<UpSensor.State> states = new ArrayList<UpSensor.State>();
        switch (currentState) {
            case UP: {
                states.add(UpSensor.State.DOWN);
                break;
            }
            case DOWN: {
                states.add(UpSensor.State.UP);
                break;
            }
            case UNKNOWN: {
                states.add(UpSensor.State.UP);
                states.add(UpSensor.State.DOWN);
            }
        }
        return states;
    }

    public static List<EnabledSensor.State> getNextPossibleStates(EnabledSensor.State currentState) {
        ArrayList<EnabledSensor.State> states = new ArrayList<EnabledSensor.State>();
        switch (currentState) {
            case ENABLED: {
                states.add(EnabledSensor.State.DISABLED);
                break;
            }
            case DISABLED: {
                states.add(EnabledSensor.State.ENABLED);
                break;
            }
            case UNKNOWN: {
                states.add(EnabledSensor.State.ENABLED);
                states.add(EnabledSensor.State.DISABLED);
            }
        }
        return states;
    }

    public static List<ButtonSensor.State> getNextPossibleStates(ButtonSensor.State currentState) {
        ArrayList<ButtonSensor.State> states = new ArrayList<ButtonSensor.State>();
        switch (currentState) {
            case PRESSED: {
                states.add(ButtonSensor.State.RELEASED);
                break;
            }
            case RELEASED: {
                states.add(ButtonSensor.State.PRESSED);
                break;
            }
            case UNKNOWN: {
                states.add(ButtonSensor.State.PRESSED);
                states.add(ButtonSensor.State.RELEASED);
            }
        }
        return states;
    }

    public static List<AlarmSensor.State> getNextPossibleStates(AlarmSensor.State currentState) {
        ArrayList<AlarmSensor.State> states = new ArrayList<AlarmSensor.State>();
        switch (currentState) {
            case ALARM: {
                states.add(AlarmSensor.State.DISABLED);
                states.add(AlarmSensor.State.ENABLED);
                break;
            }
            case DISABLED: {
                states.add(AlarmSensor.State.ENABLED);
                states.add(AlarmSensor.State.ALARM);
                break;
            }
            case ENABLED: {
                states.add(AlarmSensor.State.DISABLED);
                states.add(AlarmSensor.State.ALARM);
                break;
            }
        }
        return states;
    }

    public static List<UpSensorSlat.State> getNextPossibleStates(UpSensorSlat.State currentState) {
        ArrayList<UpSensorSlat.State> states = new ArrayList<UpSensorSlat.State>();
        switch (currentState) {
            case UP: 
            case DOWN: 
            case UNKNOWN: {
                states.add(UpSensorSlat.State.UP);
                states.add(UpSensorSlat.State.DOWN);
            }
        }
        return states;
    }
}

