/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.modules.core.model;

import bsc.api.ApiObjectIdentifier;
import bsc.api.IIdentifiableApiObject;
import bsc.api.IUpdateableObject;
import bsc.api.basic.AMetaInformation;
import bsc.api.basic.model.IExtendedEquals;
import bsc.api.modules.core.model.IModelCore;
import java.net.URI;

public class Group
extends AMetaInformation
implements IIdentifiableApiObject,
IUpdateableObject,
IModelCore,
IExtendedEquals {
    private static final long serialVersionUID = -8567749881596939846L;
    protected int id;
    protected int parentID = 0;
    protected int position = 0;
    protected String name = "";

    public Group() {
    }

    public Group(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public Group(Group group) {
        this.updateObject(group);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getParentID() {
        return this.parentID;
    }

    public void setParentID(int parentID) {
        this.parentID = parentID;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "Group [id=" + this.id + ", parentID=" + this.parentID + ", position=" + this.position + ", name=" + this.name + "]";
    }

    @Override
    public URI getURI(String applicationID, String host) {
        return ApiObjectIdentifier.getGroupUri(String.valueOf(this.id), applicationID, host);
    }

    @Override
    public synchronized boolean updateObject(IUpdateableObject objectInstance) {
        if (objectInstance != null && objectInstance instanceof Group) {
            Group group = (Group)objectInstance;
            this.id = group.id;
            this.parentID = group.parentID;
            this.position = group.position;
            this.name = group.name;
            return super.updateObject(objectInstance);
        }
        return false;
    }

    @Override
    public boolean dataEquals(IUpdateableObject objectInstance) {
        boolean equal = objectInstance instanceof Group;
        if (equal && (equal &= super.dataEquals(objectInstance))) {
            Group group = (Group)objectInstance;
            equal &= group.id == this.id;
            equal &= group.parentID == this.parentID;
            equal &= group.position == this.position;
            equal &= group.name == null ? this.name == null : group.name.equals(this.name);
        }
        return equal;
    }

    public int hashCode() {
        return String.valueOf(this.id).hashCode();
    }

    public boolean equals(Object obj) {
        return this.equals(obj, true);
    }

    @Override
    public boolean equals(Object obj, boolean checkOnlyID) {
        if (checkOnlyID) {
            boolean equal = obj instanceof Group;
            if (equal) {
                Group group = (Group)obj;
                equal = this.getId() == group.getId();
            }
            return equal;
        }
        return super.equals(obj);
    }
}

