/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.modules.core.commands;

import bsc.api.basic.commands.Command;
import bsc.api.modules.core.commands.ICommandsCore;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class GetDevicesCommand
extends Command
implements ICommandsCore {
    private static final long serialVersionUID = 6366664295385040196L;
    private List<String> ids;
    private boolean excludeIDs;
    private boolean groupIDs;

    public GetDevicesCommand(String ... deviceIDs) {
        this(false, deviceIDs);
    }

    public GetDevicesCommand(boolean excludeIDs, String ... deviceIDs) {
        this(excludeIDs, false, deviceIDs);
    }

    public GetDevicesCommand(boolean excludeIDs, boolean groupIDs, String ... deviceIDs) {
        this.excludeIDs = excludeIDs;
        this.ids = new ArrayList<String>();
        this.groupIDs = groupIDs;
        for (String id : deviceIDs) {
            this.ids.add(id);
        }
    }

    public GetDevicesCommand(Set<String> deviceIDs) {
        this(false, deviceIDs);
    }

    public GetDevicesCommand(boolean excludeIDs, Set<String> deviceIDs) {
        this.excludeIDs = excludeIDs;
        this.ids = new ArrayList<String>(deviceIDs);
    }

    public GetDevicesCommand(boolean excludeIDs, boolean groupIDs, Set<String> deviceIDs) {
        this.excludeIDs = excludeIDs;
        this.ids = new ArrayList<String>(deviceIDs);
    }

    public List<String> getIDs() {
        return this.ids;
    }

    public boolean isExcludeIDs() {
        return this.excludeIDs;
    }

    public boolean isGroupIDs() {
        return this.groupIDs;
    }
}

