/*
 * Decompiled with CFR 0.152.
 */
package bsc.api;

import java.util.HashMap;

public class Enumerations {

    public static enum OBJECT_BUS_TAGS {
        RECEIVED_OBJECT,
        PUBLISH_NOTIFICATION;

    }

    public static enum EXTENSION_ID {
        CUSTOM,
        CORE,
        BSC,
        CAMERA,
        HISTORY,
        IROOM,
        M2M,
        MESSAGE,
        METAINFO,
        MONITORING,
        TIMER,
        USERCONFIG,
        TEACHIN,
        QoS,
        CONNECTIONS,
        HEATER,
        OBJECT_TAG,
        OVENTROP,
        PARAMETER,
        VOICECONTROL,
        ALEXA,
        USERMANAGEMENT,
        USERGROUPMANAGEMENT,
        TF,
        VDEVICE,
        SCHEDULE,
        WEBHOOK,
        EOAP,
        UPDATE;

        private static HashMap<Class<?>, String> extensionIdMap;

        public String getId() {
            return this.getId(null);
        }

        public String getId(Class<?> clazz) {
            String result = null;
            if (clazz != null && this.name().equals("CUSTOM") && extensionIdMap.containsKey(clazz)) {
                result = extensionIdMap.get(clazz);
            }
            if (result == null) {
                result = this.name();
            }
            return result;
        }

        public boolean setId(String extensionId, Class<?> clazz) {
            boolean result = this.name().equals("CUSTOM");
            if (result) {
                extensionIdMap.put(clazz, extensionId);
            }
            return result;
        }

        public static EXTENSION_ID getByID(String extensionId) {
            for (EXTENSION_ID extId : EXTENSION_ID.values()) {
                if (!extId.getId().equals(extensionId)) continue;
                return extId;
            }
            for (String id : extensionIdMap.values()) {
                if (!id.equals(extensionId)) continue;
                return CUSTOM;
            }
            return null;
        }

        static {
            extensionIdMap = new HashMap();
        }
    }

    public static enum SystemSensorName {
        E_MAIL,
        PUSH,
        ALERT,
        BELL;

    }

    public static enum SensorName {
        UNKNOWN(null),
        ActorContainer(TYPE.STATE),
        Alarm(TYPE.STATE),
        Battery(TYPE.STATE),
        Binary(TYPE.STATE),
        Brightness(TYPE.VALUE),
        Bus(TYPE.STATE),
        Button(TYPE.STATE),
        Recording(TYPE.STATE),
        RecordingEnabled(TYPE.STATE),
        CardSwitch(TYPE.STATE),
        Check(TYPE.STATE),
        Channel0(TYPE.MIXED),
        Channel1(TYPE.MIXED),
        Channel2(TYPE.MIXED),
        Channel3(TYPE.MIXED),
        Channel4(TYPE.MIXED),
        Channel5(TYPE.MIXED),
        Channel6(TYPE.MIXED),
        Channel7(TYPE.MIXED),
        Channel8(TYPE.MIXED),
        CO2(TYPE.VALUE),
        Color(TYPE.VALUE),
        Consumption(TYPE.VALUE),
        Counter(TYPE.VALUE),
        DateTime(TYPE.VALUE),
        DayNight(TYPE.STATE),
        Detection(TYPE.STATE),
        Detection1(TYPE.STATE),
        Detection2(TYPE.STATE),
        Detection3(TYPE.STATE),
        Detection4(TYPE.STATE),
        Dimmer(TYPE.VALUE),
        Direction(TYPE.STATE),
        Alignment(TYPE.STATE),
        Enabled(TYPE.STATE),
        EnergyBow(TYPE.STATE),
        FanSpeed(TYPE.VALUE),
        Gas(TYPE.VALUE),
        GeoDirection(TYPE.VALUE),
        GeoPosition(TYPE.VALUE),
        HeatDetection(TYPE.STATE),
        HighChargeCounter(TYPE.VALUE),
        Humidity(TYPE.VALUE),
        Jalousie(TYPE.VALUE),
        JalousieSlat(TYPE.STATE),
        Key0(TYPE.STATE),
        Key1(TYPE.STATE),
        Key2(TYPE.STATE),
        Key3(TYPE.STATE),
        Key4(TYPE.STATE),
        Key5(TYPE.STATE),
        Key6(TYPE.STATE),
        Key7(TYPE.STATE),
        Key8(TYPE.STATE),
        Key9(TYPE.STATE),
        LastConnect(TYPE.VALUE),
        LastDisconnect(TYPE.VALUE),
        LowChargeCounter(TYPE.VALUE),
        Modem(TYPE.STATE),
        GenericOilWater(TYPE.STATE),
        On(TYPE.STATE),
        Open(TYPE.STATE),
        OperatingMode(TYPE.STATE),
        Override(TYPE.MIXED),
        PresenceDetection(TYPE.STATE),
        Priority(TYPE.STATE),
        Priority1(TYPE.STATE),
        Priority2(TYPE.STATE),
        RainDetection(TYPE.STATE),
        Relay(TYPE.STATE),
        RockerA(TYPE.STATE),
        RockerB(TYPE.STATE),
        RSSIMax(TYPE.VALUE),
        RSSIMean(TYPE.VALUE),
        RSSIMin(TYPE.VALUE),
        SceneSwitch(TYPE.STATE),
        SetPoint(TYPE.VALUE),
        SlatAdjustmentTime(TYPE.VALUE),
        SlideSwitch(TYPE.STATE),
        SummerSetting(TYPE.STATE),
        SunIntensity(TYPE.VALUE),
        Temperature(TYPE.VALUE),
        Timer(TYPE.VALUE),
        Trigger(TYPE.STATE),
        Value(TYPE.VALUE),
        ValueRed(TYPE.VALUE),
        ValueGreen(TYPE.VALUE),
        ValueBlue(TYPE.VALUE),
        ValueWarmWhite(TYPE.VALUE),
        ValueColdWhite(TYPE.VALUE),
        Voltage(TYPE.VALUE),
        Window(TYPE.STATE),
        WindowAlarm(TYPE.STATE),
        WindowBattery(TYPE.STATE),
        WindSpeed(TYPE.VALUE),
        Valve(TYPE.VALUE),
        Volume(TYPE.VALUE),
        StringValue(TYPE.VALUE),
        LedSensor(TYPE.STATE),
        ErrorDetection(TYPE.STATE),
        SetedSetpointActuator(TYPE.VALUE),
        EnergyStorage(TYPE.VALUE),
        AlarmEnabled(TYPE.STATE),
        AlarmTrigger(TYPE.STATE),
        PreAlarmEnabled(TYPE.STATE),
        PreAlarmTrigger(TYPE.STATE),
        SlowlyDriveEnabled(TYPE.STATE),
        ColorTemperature(TYPE.VALUE),
        DirectionSensor(TYPE.STATE),
        TurnAutomaticEnabled(TYPE.STATE),
        Acceleration_X(TYPE.VALUE),
        Acceleration_Y(TYPE.VALUE),
        Acceleration_Z(TYPE.VALUE),
        Acceleration_State(TYPE.STATE);

        private final TYPE type;

        private SensorName(TYPE type) {
            this.type = type;
        }

        public TYPE getType() {
            return this.type == null ? null : this.type;
        }

        public String getSensorName() {
            return this.name();
        }

        public static SensorName getByName(String name) {
            if (name != null) {
                for (SensorName sensorName : SensorName.values()) {
                    if (!sensorName.getSensorName().equals(name)) continue;
                    return sensorName;
                }
            }
            return null;
        }

        public static enum SUBTYPE_STAGE {
            GENERIC,
            FAN;


            public String getSensorName() {
                return FanSpeed.getSensorName();
            }

            public SensorName getParent() {
                return FanSpeed;
            }

            public TYPE getType() {
                return FanSpeed.getType();
            }
        }

        public static enum SUBTYPE_ALARM {
            GENERIC,
            ALARM;


            public String getSensorName() {
                return Alarm.getSensorName();
            }

            public SensorName getParent() {
                return Alarm;
            }

            public TYPE getType() {
                return Alarm.getType();
            }
        }

        public static enum SUBTYPE_ENABLED {
            GENERIC,
            DAYLIGHT_HARVESTING,
            POWER_RELAY,
            REPEATER;


            public String getSensorName() {
                return Enabled.getSensorName();
            }

            public SensorName getParent() {
                return Enabled;
            }

            public TYPE getType() {
                return Enabled.getType();
            }
        }

        public static enum SUBTYPE_GAS {
            GENERIC,
            CO2;


            public String getSensorName() {
                return Gas.getSensorName();
            }

            public SensorName getParent() {
                return Gas;
            }

            public TYPE getType() {
                return Gas.getType();
            }
        }

        public static enum SUBTYPE_CONSUMPTION {
            GENERIC,
            ELECTRICITY,
            WATER,
            GAS,
            THERMAL,
            AMR_COLLECTION;


            public String getSensorName() {
                return Consumption.getSensorName();
            }

            public SensorName getParent() {
                return Consumption;
            }

            public TYPE getType() {
                return Consumption.getType();
            }
        }

        public static enum SUBTYPE_OPEN {
            GENERIC,
            CONTACT,
            DOOR_CONTACT,
            MAGNET_CONTACT,
            OPEN_BATTERY,
            WINDOW_CONTACT,
            VALVE;


            public String getSensorName() {
                return Open.getSensorName();
            }

            public SensorName getParent() {
                return Open;
            }

            public TYPE getType() {
                return Open.getType();
            }
        }

        public static enum SUBTYPE_CHECK {
            GENERIC,
            BATTERY;


            public String getSensorName() {
                return Check.getSensorName();
            }

            public SensorName getParent() {
                return Check;
            }

            public TYPE getType() {
                return Check.getType();
            }
        }

        public static enum SUBTYPE_DETECTION {
            GENERIC,
            EMPTY,
            HEATING,
            LECKAGE,
            MANOMETER_SETPOINT,
            MIN,
            MOISTURE,
            MOTION,
            OCCUPANCY,
            PRESENCE,
            RAIN,
            SEAT,
            SMOKE,
            TRAP,
            VOLTAGE,
            WATER,
            HEAT;


            public String getSensorName() {
                return Detection.getSensorName();
            }

            public SensorName getParent() {
                return Detection;
            }

            public TYPE getType() {
                return Detection.getType();
            }
        }

        public static enum SUBTYPE_TEMPERATURE {
            GENERIC,
            INNER,
            OUTER;


            public String getSensorName() {
                return Temperature.getSensorName();
            }

            public SensorName getParent() {
                return Temperature;
            }

            public TYPE getType() {
                return Temperature.getType();
            }
        }

        public static enum SUBTYPE_JALOUSIE {
            GENERIC,
            INVERTED;


            public String getSensorName() {
                return Jalousie.getSensorName();
            }

            public SensorName getParent() {
                return Jalousie;
            }

            public TYPE getType() {
                return Jalousie.getType();
            }
        }

        public static enum SUBTYPE_ON {
            GENERIC,
            PRIORITY,
            RELAY,
            SUMMER_SETTING,
            SWITCH_ON,
            RELAY_SWITCH_ON;


            public String getSensorName() {
                return On.getSensorName();
            }

            public SensorName getParent() {
                return On;
            }

            public TYPE getType() {
                return On.getType();
            }
        }

        public static enum TYPE {
            VALUE,
            STATE,
            MIXED;

        }
    }

    public static enum DeviceType {
        UNKNOWN,
        Camera,
        ActorContainer,
        AlarmRelay,
        BinaryBattery,
        BrightnessVoltage,
        BrightnessVoltageDetection,
        BrightnessDetection,
        DetectionMode,
        DetectionBattery,
        DetectionVoltage,
        DetectionVoltagePushbutton,
        DimmerPriority,
        DimmerPriorityLimitMinimumBrightness,
        SystemDevice,
        FGSM14,
        GenericAlarm,
        GenericBinary,
        GenericBrightness,
        GenericCardSwitch,
        GenericCheck,
        GenericDetection,
        GenericDimmer,
        GenericEnabled,
        GenericGas,
        GasLed,
        GenericHeaterControl,
        GenericHeaterValveControl,
        SetpointHeaterControl,
        PriorityHeaterControl,
        HeaterControlDetection,
        GenericJalousie,
        GenericMeter,
        GenericOilWater,
        GenericOn,
        GenericOnPriority,
        GenericOpen,
        GenericLock,
        GenericTemperature,
        GenericVentilationControl,
        GenericWindow,
        JalousiePriority,
        JalousieAlignmentPriority,
        JalousieSlatAdjustmentTimePriority,
        JalousieSlatAdjustmentDirectionTimePriority,
        OpenBattery,
        OpenVoltage,
        RGBDimmer,
        SceneSwitch,
        SwitchJalousie,
        SwitchEnergyBow,
        SetPoint,
        SetPointOperatingMode,
        SetPointOperatingModePriority,
        SetPointOperatingModeRestriction,
        SetPointOperatingModeRestrictionPriority,
        SetPointPriority,
        TempButton,
        TempCO2,
        TempCO2Humidity,
        TempDetection,
        TempHumidity,
        TempHumidityHSetPoint,
        TempHumidityVoltage,
        TempSetPoint,
        TempSetPointButton,
        TempSetPointFan,
        TempSetPointFanDetection,
        TempSetPointPriority,
        TempSetPointPriorityPercentage,
        TempSetPointVoltage,
        TempSetPointDayNight,
        TempSetPointDetection,
        TempSetPointDetectionOn,
        TempSetPointButtonFan,
        TempSetPointHumidity,
        TempSetPointHumidityButton,
        TempSetPointSlideSwitch,
        TempSetPointSummerSettingWindowHeatPresence,
        TempSetPointWindow,
        TempSetPointWindowBattery,
        TempSetPointRelayAndOrPriority,
        Timer,
        TimerControl,
        TwoRocker,
        TwoRockerEnergyBow,
        WeatherstationElsner,
        WeatherstationEltako,
        PC,
        PCGroup,
        HeaterControlPriority,
        WindowBattery,
        WindowBatteryAlarm,
        WindowVoltage,
        WindowVoltageVibration,
        HeaterControl,
        WhiteLightDimmer,
        VoltageBatteryCheck,
        GenericBatteryCheck,
        SetpointBattery,
        F6TFKeypad,
        VirtualDevice,
        ScheduleDevice,
        SmokeDetection2ndChannelRelais,
        SmokeDetection,
        SpecialAlarm,
        PressedPriority,
        AlarmSiren,
        HeaterControlThreeStatePriority,
        Smartguard_Window,
        DimmerPriorityColorTemperature,
        KeySwitch,
        MultiSensorAcceleration,
        MonitoringDevice;

    }

    public static enum UserRole {
        Admin,
        User;

    }

    public static enum DAYS {
        MONDAY,
        TUESSDAY,
        WEDNESDAY,
        THURSDAY,
        FRIDAY,
        SATURDAY,
        SUNDAY;

    }

    public static enum ApiVersion {
        Ver_1_1_0(1),
        Ver_1_1_1(2),
        Ver_1_1_2(3),
        Ver_2_0_0(4),
        Ver_2_1_0(5),
        Ver_3_1_0(6);

        private final int apiRevision;

        private ApiVersion(int apiRevision) {
            this.apiRevision = apiRevision;
        }

        public int getApiRevision() {
            return this.apiRevision;
        }
    }

    public static enum AudioEncoding {
        RAW,
        PCM,
        MP3;

    }

    public static enum CameraDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT,
        UP_LEFT,
        UP_RIGHT,
        DOWN_LEFT,
        DOWN_RIGHT,
        HOME,
        ZOOM_IN,
        ZOOM_OUT,
        ZOOM_STOP,
        MOVE_STOP;

    }

    public static enum VideoEncoding {
        RAW,
        MJPEG,
        MP4_ISO,
        H264;

    }

    public static enum ErrorType {
        UNTYPED,
        FILE_NOT_FOUND,
        EXCEPTION,
        TOO_MANY_CLIENTS,
        NO_SUCH_USER,
        NOT_AUTHENTICATED,
        IN_PROGRESS,
        NO_PROFILE,
        USER_NOT_ACTIVATED,
        UNKNOWN_ENCRYPTION,
        TIMEOUT,
        UNKNOWN_COMPRESSION,
        UNKNOWN_MESSAGE,
        UNKNOWN_PROTOCOL,
        UNEXPECTED_RESULT,
        IO_EXCEPTION,
        UNSUPPORTED_OPERATION,
        NO_RESULT,
        WRAPPING_FAILED,
        PROTOCOL_FAILED,
        CIPHER_FAILED,
        COMPRESSION_FAILED,
        PROGRAM_TYPE_NOT_SUPPORTED,
        USER_ALREADY_CONNECTED,
        SESSION_NOT_FOUND,
        UNSUPPORTED_API_VERSION,
        UNEXPECTED_SEQUENCE,
        END_OF_STREAM_REACHED,
        NOT_ALLOWED,
        SERVICE_NOT_AVAILABLE;

    }

    public static enum MessageType {
        COMPRESSED,
        ENCRYPTED,
        PROTOCOL,
        ERROR;

    }

    public static enum CompressionType {
        NONE,
        DEFLATE;

    }

    public static enum EncryptionType {
        NONE,
        AES;

    }

    public static enum ProtocolType {
        JSON;

    }
}

