/*
 * Decompiled with CFR 0.152.
 */
package bsc.api;

import bsc.api.IIdentifiableApiObject;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;

public class ApiObjectIdentifier {
    public static URI getDeviceURI(String deviceID, String applicationID, String host) {
        if (deviceID != null && applicationID != null && host != null) {
            try {
                String uriString = IIdentifiableApiObject.class.getSimpleName() + "://" + applicationID + "@" + host + "/" + URLEncoder.encode("DEVICE", "UTF-8") + "/" + URLEncoder.encode(deviceID, "UTF-8");
                return new URI(uriString);
            }
            catch (UnsupportedEncodingException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static URI getSensorURI(String deviceID, String sensorID, String applicationID, String host) {
        if (deviceID != null && sensorID != null && applicationID != null && host != null) {
            try {
                String uriString = IIdentifiableApiObject.class.getSimpleName() + "://" + applicationID + "@" + host + "/" + URLEncoder.encode("SENSOR", "UTF-8") + "/" + URLEncoder.encode(deviceID, "UTF-8") + "/" + URLEncoder.encode(sensorID, "UTF-8");
                return new URI(uriString);
            }
            catch (UnsupportedEncodingException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static URI getGroupUri(String id, String applicationID, String host) {
        if (applicationID != null && host != null) {
            try {
                String uriString = IIdentifiableApiObject.class.getSimpleName() + "://" + applicationID + "@" + host + "/" + URLEncoder.encode("GROUP", "UTF-8") + "/" + URLEncoder.encode(id, "UTF-8");
                return new URI(uriString);
            }
            catch (UnsupportedEncodingException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static URI getTapFunctionUri(String id, String applicationID, String host) {
        if (id != null && applicationID != null && host != null) {
            try {
                String uriString = IIdentifiableApiObject.class.getSimpleName() + "://" + applicationID + "@" + host + "/" + URLEncoder.encode("TAPFUNCTION", "UTF-8") + "/" + URLEncoder.encode(id, "UTF-8");
                return new URI(uriString);
            }
            catch (UnsupportedEncodingException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

