/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.tools;

import de.bsc.bapfinder.IBAPFinder;
import de.bsc.bapfinder.tools.Message;
import de.bsc.bapfinder.tools.RandomArrayStream;
import de.bsc.bapfinder.tools.classloader.JarClassLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.JarURLConnection;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class Tools {
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static short[] u8CRC8Table;

    static {
        short[] sArray = new short[256];
        sArray[1] = 7;
        sArray[2] = 14;
        sArray[3] = 9;
        sArray[4] = 28;
        sArray[5] = 27;
        sArray[6] = 18;
        sArray[7] = 21;
        sArray[8] = 56;
        sArray[9] = 63;
        sArray[10] = 54;
        sArray[11] = 49;
        sArray[12] = 36;
        sArray[13] = 35;
        sArray[14] = 42;
        sArray[15] = 45;
        sArray[16] = 112;
        sArray[17] = 119;
        sArray[18] = 126;
        sArray[19] = 121;
        sArray[20] = 108;
        sArray[21] = 107;
        sArray[22] = 98;
        sArray[23] = 101;
        sArray[24] = 72;
        sArray[25] = 79;
        sArray[26] = 70;
        sArray[27] = 65;
        sArray[28] = 84;
        sArray[29] = 83;
        sArray[30] = 90;
        sArray[31] = 93;
        sArray[32] = 224;
        sArray[33] = 231;
        sArray[34] = 238;
        sArray[35] = 233;
        sArray[36] = 252;
        sArray[37] = 251;
        sArray[38] = 242;
        sArray[39] = 245;
        sArray[40] = 216;
        sArray[41] = 223;
        sArray[42] = 214;
        sArray[43] = 209;
        sArray[44] = 196;
        sArray[45] = 195;
        sArray[46] = 202;
        sArray[47] = 205;
        sArray[48] = 144;
        sArray[49] = 151;
        sArray[50] = 158;
        sArray[51] = 153;
        sArray[52] = 140;
        sArray[53] = 139;
        sArray[54] = 130;
        sArray[55] = 133;
        sArray[56] = 168;
        sArray[57] = 175;
        sArray[58] = 166;
        sArray[59] = 161;
        sArray[60] = 180;
        sArray[61] = 179;
        sArray[62] = 186;
        sArray[63] = 189;
        sArray[64] = 199;
        sArray[65] = 192;
        sArray[66] = 201;
        sArray[67] = 206;
        sArray[68] = 219;
        sArray[69] = 220;
        sArray[70] = 213;
        sArray[71] = 210;
        sArray[72] = 255;
        sArray[73] = 248;
        sArray[74] = 241;
        sArray[75] = 246;
        sArray[76] = 227;
        sArray[77] = 228;
        sArray[78] = 237;
        sArray[79] = 234;
        sArray[80] = 183;
        sArray[81] = 176;
        sArray[82] = 185;
        sArray[83] = 190;
        sArray[84] = 171;
        sArray[85] = 172;
        sArray[86] = 165;
        sArray[87] = 162;
        sArray[88] = 143;
        sArray[89] = 136;
        sArray[90] = 129;
        sArray[91] = 134;
        sArray[92] = 147;
        sArray[93] = 148;
        sArray[94] = 157;
        sArray[95] = 154;
        sArray[96] = 39;
        sArray[97] = 32;
        sArray[98] = 41;
        sArray[99] = 46;
        sArray[100] = 59;
        sArray[101] = 60;
        sArray[102] = 53;
        sArray[103] = 50;
        sArray[104] = 31;
        sArray[105] = 24;
        sArray[106] = 17;
        sArray[107] = 22;
        sArray[108] = 3;
        sArray[109] = 4;
        sArray[110] = 13;
        sArray[111] = 10;
        sArray[112] = 87;
        sArray[113] = 80;
        sArray[114] = 89;
        sArray[115] = 94;
        sArray[116] = 75;
        sArray[117] = 76;
        sArray[118] = 69;
        sArray[119] = 66;
        sArray[120] = 111;
        sArray[121] = 104;
        sArray[122] = 97;
        sArray[123] = 102;
        sArray[124] = 115;
        sArray[125] = 116;
        sArray[126] = 125;
        sArray[127] = 122;
        sArray[128] = 137;
        sArray[129] = 142;
        sArray[130] = 135;
        sArray[131] = 128;
        sArray[132] = 149;
        sArray[133] = 146;
        sArray[134] = 155;
        sArray[135] = 156;
        sArray[136] = 177;
        sArray[137] = 182;
        sArray[138] = 191;
        sArray[139] = 184;
        sArray[140] = 173;
        sArray[141] = 170;
        sArray[142] = 163;
        sArray[143] = 164;
        sArray[144] = 249;
        sArray[145] = 254;
        sArray[146] = 247;
        sArray[147] = 240;
        sArray[148] = 229;
        sArray[149] = 226;
        sArray[150] = 235;
        sArray[151] = 236;
        sArray[152] = 193;
        sArray[153] = 198;
        sArray[154] = 207;
        sArray[155] = 200;
        sArray[156] = 221;
        sArray[157] = 218;
        sArray[158] = 211;
        sArray[159] = 212;
        sArray[160] = 105;
        sArray[161] = 110;
        sArray[162] = 103;
        sArray[163] = 96;
        sArray[164] = 117;
        sArray[165] = 114;
        sArray[166] = 123;
        sArray[167] = 124;
        sArray[168] = 81;
        sArray[169] = 86;
        sArray[170] = 95;
        sArray[171] = 88;
        sArray[172] = 77;
        sArray[173] = 74;
        sArray[174] = 67;
        sArray[175] = 68;
        sArray[176] = 25;
        sArray[177] = 30;
        sArray[178] = 23;
        sArray[179] = 16;
        sArray[180] = 5;
        sArray[181] = 2;
        sArray[182] = 11;
        sArray[183] = 12;
        sArray[184] = 33;
        sArray[185] = 38;
        sArray[186] = 47;
        sArray[187] = 40;
        sArray[188] = 61;
        sArray[189] = 58;
        sArray[190] = 51;
        sArray[191] = 52;
        sArray[192] = 78;
        sArray[193] = 73;
        sArray[194] = 64;
        sArray[195] = 71;
        sArray[196] = 82;
        sArray[197] = 85;
        sArray[198] = 92;
        sArray[199] = 91;
        sArray[200] = 118;
        sArray[201] = 113;
        sArray[202] = 120;
        sArray[203] = 127;
        sArray[204] = 106;
        sArray[205] = 109;
        sArray[206] = 100;
        sArray[207] = 99;
        sArray[208] = 62;
        sArray[209] = 57;
        sArray[210] = 48;
        sArray[211] = 55;
        sArray[212] = 34;
        sArray[213] = 37;
        sArray[214] = 44;
        sArray[215] = 43;
        sArray[216] = 6;
        sArray[217] = 1;
        sArray[218] = 8;
        sArray[219] = 15;
        sArray[220] = 26;
        sArray[221] = 29;
        sArray[222] = 20;
        sArray[223] = 19;
        sArray[224] = 174;
        sArray[225] = 169;
        sArray[226] = 160;
        sArray[227] = 167;
        sArray[228] = 178;
        sArray[229] = 181;
        sArray[230] = 188;
        sArray[231] = 187;
        sArray[232] = 150;
        sArray[233] = 145;
        sArray[234] = 152;
        sArray[235] = 159;
        sArray[236] = 138;
        sArray[237] = 141;
        sArray[238] = 132;
        sArray[239] = 131;
        sArray[240] = 222;
        sArray[241] = 217;
        sArray[242] = 208;
        sArray[243] = 215;
        sArray[244] = 194;
        sArray[245] = 197;
        sArray[246] = 204;
        sArray[247] = 203;
        sArray[248] = 230;
        sArray[249] = 225;
        sArray[250] = 232;
        sArray[251] = 239;
        sArray[252] = 250;
        sArray[253] = 253;
        sArray[254] = 244;
        sArray[255] = 243;
        u8CRC8Table = sArray;
    }

    public static String toHexString(byte[] data) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            buffer.append(Tools.toHexString(data[i]));
            ++i;
        }
        return buffer.toString();
    }

    public static String toHexString(long value) {
        return Tools.toHexString(value, true, null);
    }

    public static String toHexString(long value, boolean fill, String seperator) {
        boolean leading = true;
        StringBuffer buffer = new StringBuffer();
        int i = 7;
        while (i >= 0) {
            byte digit = (byte)(value >>> i * 8);
            if (digit != 0) {
                leading = false;
            }
            if ((leading && fill) | !leading) {
                buffer.append(Tools.toHexString(digit));
                if (seperator != null && seperator.length() > 0 && i > 0) {
                    buffer.append(seperator);
                }
            }
            --i;
        }
        return buffer.toString();
    }

    public static String toHexString(int value) {
        return Tools.toHexString(value, true);
    }

    public static String toHexString(int value, boolean fill) {
        boolean leading = true;
        StringBuffer buffer = new StringBuffer();
        int i = 3;
        while (i >= 0) {
            byte digit = (byte)(value >>> i * 8);
            if (digit != 0) {
                leading = false;
            }
            if ((leading && fill) | !leading) {
                buffer.append(Tools.toHexString(digit));
            }
            --i;
        }
        return buffer.toString();
    }

    public static String toHexString(byte value) {
        char[] chars = new char[]{digits[value >>> 4 & 0xF], digits[value & 0xF]};
        return new String(chars);
    }

    public static Window findWindow(Object component) {
        if (component == null || !(component instanceof Component)) {
            return JOptionPane.getRootFrame();
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        return Tools.findWindow(((Component)component).getParent());
    }

    public static synchronized void flash(final Component component, final Color color, int count) {
        if (component == null || component.getName() != null && component.getName().equals("FlashingComponent")) {
            return;
        }
        Timer timer = new Timer(250, new ActionListener(count){
            private boolean schalte = true;
            private int counter;
            private Color originalColor;
            private String originalName;
            {
                this.counter = n * 2;
                this.originalColor = component2.getBackground();
                this.originalName = component2.getName();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                component.setBackground(this.schalte ? color : this.originalColor);
                this.schalte = !this.schalte;
                --this.counter;
                if (this.counter == 0) {
                    ((Timer)e.getSource()).stop();
                    component.setBackground(this.originalColor);
                    component.setName(this.originalName);
                }
            }
        });
        component.setName("FlashingComponent");
        timer.setInitialDelay(0);
        timer.start();
    }

    public static IBAPFinder.IMessage sendToConfigPort(IBAPFinder.IDevice device, int messageType, RandomArrayStream stream) {
        return Tools.sendToConfigPort(device, messageType, stream, false, 0);
    }

    public static IBAPFinder.IMessage sendToConfigPort(IBAPFinder.IDevice device, int messageType, RandomArrayStream stream, boolean needAnswer, int timeout) {
        Socket socket = null;
        Message message = null;
        byte[] data = null;
        try {
            if (stream != null) {
                stream.seek(0);
                data = new byte[stream.available()];
                stream.read(data);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return new Message(3, 0, null);
        }
        try {
            socket = new Socket(InetAddress.getByName(device.getIp()), device.getPort());
            socket.setSoTimeout(needAnswer ? timeout : 10000);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Message(3, 0, null);
        }
        FilterOutputStream socketDataOutputStream = null;
        DataInputStream socketDataInputStream = null;
        try {
            try {
                socketDataInputStream = new DataInputStream(socket.getInputStream());
                socketDataOutputStream = new DataOutputStream(socket.getOutputStream());
                ((DataOutputStream)socketDataOutputStream).writeInt(messageType);
                if (data == null || data.length == 0) {
                    ((DataOutputStream)socketDataOutputStream).writeInt(0);
                } else {
                    ((DataOutputStream)socketDataOutputStream).writeInt(data.length);
                    socketDataOutputStream.write(data);
                }
                ((DataOutputStream)socketDataOutputStream).flush();
                if (needAnswer) {
                    socketDataInputStream = new DataInputStream(socket.getInputStream());
                    int dataType = socketDataInputStream.readInt();
                    int length = socketDataInputStream.readInt();
                    byte[] receivedData = new byte[length];
                    socketDataInputStream.readFully(receivedData);
                    RandomArrayStream received = new RandomArrayStream();
                    received.write(receivedData);
                    received.seek(0);
                    message = new Message(1, dataType, received);
                } else {
                    message = new Message(2, 0, null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Message message2 = new Message(3, 0, null);
                try {
                    socketDataOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    socketDataInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return message2;
            }
        }
        finally {
            try {
                socketDataOutputStream.close();
            }
            catch (Exception exception) {}
            try {
                socketDataInputStream.close();
            }
            catch (Exception exception) {}
            try {
                socket.close();
            }
            catch (Exception exception) {}
        }
        return message;
    }

    public static boolean isFlagSet(long flags, long flag) {
        return (flags & flag) == flag;
    }

    public static String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        String trace = new String(byteArrayOutputStream.toByteArray());
        try {
            printStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return trace;
    }

    public static List<Class<?>> getClasses(String packageName) {
        Enumeration<URL> resources;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        try {
            resources = classLoader.getResources(path);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        ArrayList<File> dirs = new ArrayList<File>();
        ArrayList<URL> urls = new ArrayList<URL>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            if (!resource.toString().contains("!")) {
                String filename = resource.getFile();
                filename = filename.replace("%20", " ");
                dirs.add(new File(resource.getFile()));
                continue;
            }
            urls.add(resource);
        }
        ArrayList classes = new ArrayList();
        for (File directory : dirs) {
            try {
                classes.addAll(Tools.findClasses(directory, packageName));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        for (URL url : urls) {
            classes.addAll(Tools.findClasses(url, packageName));
        }
        return classes;
    }

    private static List<Class<?>> findClasses(URL url, String packageName) {
        packageName = packageName.replace('.', '/');
        JarURLConnection connection = null;
        ArrayList classes = new ArrayList();
        try {
            connection = (JarURLConnection)url.openConnection();
            JarFile jarFile = connection.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(packageName) || !entry.getName().contains(".class")) continue;
                String name = entry.getName();
                name = name.substring(0, name.indexOf(46));
                name = name.replace('/', '.');
                try {
                    classes.add(Class.forName(name));
                }
                catch (Throwable e) {
                    System.err.println("Exception: " + e.getClass().getName() + ", Message: " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return null;
        }
        return classes;
    }

    private static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(Tools.findClasses(file, String.valueOf(packageName) + "." + file.getName()));
            } else if (file.getName().contains(".class")) {
                String name = String.valueOf(packageName) + '.' + file.getName().substring(0, file.getName().length() - 6);
                if (name.startsWith(".")) {
                    name = name.substring(1);
                }
                try {
                    classes.add(Class.forName(name));
                }
                catch (Throwable e) {
                    System.err.println("Exception: " + e.getClass().getName() + ", Message: " + e.getMessage());
                }
            }
            ++n2;
        }
        return classes;
    }

    public static List<Class<?>> getClassesFolder(String path, String packageName) {
        ArrayList classes = new ArrayList();
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory()) {
            return classes;
        }
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (files == null || files.length == 0) {
            return classes;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            JarClassLoader jarLoader = new JarClassLoader(file.getAbsolutePath());
            List classPaths = jarLoader.getClassNames(packageName);
            for (String classPath : classPaths) {
                Class c = null;
                try {
                    c = jarLoader.loadClass(classPath);
                    classes.add(c);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return classes;
    }

    public static String readString(DataInputStream dataInputStream) throws IOException {
        int length = 0;
        StringBuffer stringBuffer = new StringBuffer();
        length = dataInputStream.readInt();
        int i = 0;
        while (i < length) {
            stringBuffer.append(dataInputStream.readChar());
            ++i;
        }
        return stringBuffer.toString();
    }

    public static void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        if (dataOutputStream == null) {
            return;
        }
        if (string == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(string.length());
            dataOutputStream.writeChars(string);
        }
    }

    public static byte[] readData(DataInputStream dataInputStream) throws IOException {
        byte[] data = new byte[dataInputStream.readInt()];
        dataInputStream.readFully(data);
        return data;
    }

    public static void writeData(DataOutputStream dataOutputStream, byte[] data) throws IOException {
        if (dataOutputStream == null) {
            return;
        }
        if (data == null || data.length == 0) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(data.length);
            dataOutputStream.write(data);
        }
    }

    private static byte procCRC8(byte u8CRC, byte u8Data) {
        return (byte)u8CRC8Table[(short)(u8CRC & 0xFF) ^ (short)(u8Data & 0xFF)];
    }

    public static byte calculateCRC8(byte[] data, int offset, int length) {
        byte[] tmpData = new byte[length];
        System.arraycopy(data, offset, tmpData, 0, length);
        return Tools.calculateCRC8(tmpData);
    }

    public static byte calculateCRC8(byte[] data) {
        byte u8CRC = 0;
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte entry = byArray[n2];
            u8CRC = Tools.procCRC8(u8CRC, entry);
            ++n2;
        }
        return u8CRC;
    }

    public static byte getChecksumESP2(byte[] command) {
        int sum = 0;
        int i = 2;
        while (i < command.length - 1) {
            sum += command[i];
            ++i;
        }
        return (byte)sum;
    }
}

