/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder;

import de.bsc.bapfinder.BoSeServer;
import de.bsc.bapfinder.IBAPFinder;
import de.bsc.bapfinder.tools.Tools;
import java.beans.PropertyChangeEvent;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class EoAccessPoint
extends BoSeServer
implements IBAPFinder.IEoAccessPoint {
    protected boolean dhcp = false;
    protected boolean ipv6 = false;
    protected String serverIP = null;

    protected EoAccessPoint() {
    }

    public EoAccessPoint(byte[] data, int port) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int messageType = dataInputStream.readInt();
        if (messageType != 1) {
            throw new Exception("No answer to configuration request received");
        }
        this.setIp(Tools.readString(dataInputStream));
        this.setPort(port);
        this.setSubnetmask(Tools.readString(dataInputStream));
        this.setGateway(Tools.readString(dataInputStream));
        this.setHostname(Tools.readString(dataInputStream));
        this.setDhcp(dataInputStream.readBoolean());
        this.setMac(Tools.readString(dataInputStream));
        this.setId(dataInputStream.readLong());
        this.setFeatures(dataInputStream.readLong());
        this.setVersion(dataInputStream.readLong());
        if (this.hasFeature(4096L)) {
            this.setCommands(dataInputStream.readLong());
        }
        if (this.hasFeature(524288L)) {
            this.setDNS(Tools.readString(dataInputStream));
        }
        if (this.hasFeature(0x100000L)) {
            this.setServerIP(Tools.readString(dataInputStream));
        }
        if (this.hasFeature(0x200000L)) {
            this.setVID(Tools.readString(dataInputStream));
        }
        this.setUdp(true);
        this.setOnline(true);
        this.setLastMessageTime(System.currentTimeMillis());
    }

    @Override
    public boolean isDhcp() {
        return this.dhcp;
    }

    @Override
    public void setDhcp(boolean dhcp) {
        boolean old = this.dhcp;
        if (old != dhcp) {
            this.dhcp = dhcp;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "dhcp", old, dhcp);
            this.firePropertyChange(event);
        }
    }

    @Override
    public boolean isIpv6() {
        return this.ipv6;
    }

    @Override
    public void setIpv6(boolean ipv6) {
        boolean old = this.ipv6;
        if (old != ipv6) {
            this.ipv6 = ipv6;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "ipv6", old, ipv6);
            this.firePropertyChange(event);
        }
    }

    @Override
    public String getServerIP() {
        return this.serverIP;
    }

    @Override
    public void setServerIP(String serverIP) {
        String old;
        String string = old = this.serverIP == null ? "" : this.serverIP;
        if (!old.equals(serverIP)) {
            this.serverIP = serverIP;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "serverIP", old, serverIP);
            this.firePropertyChange(event);
        }
    }

    @Override
    public EoAccessPoint clone() {
        EoAccessPoint device = new EoAccessPoint();
        device.dhcp = this.dhcp;
        device.ipv6 = this.ipv6;
        device.serverIP = this.serverIP;
        device.ip = this.ip;
        device.port = this.port;
        device.subnetmask = this.subnetmask;
        device.gateway = this.gateway;
        device.hostname = this.hostname;
        device.id = this.id;
        device.mac = this.mac;
        device.version = this.version;
        device.features = this.features;
        device.commands = this.commands;
        device.udp = this.udp;
        device.online = this.online;
        device.lastMessageTime = this.lastMessageTime;
        device.dhcp = this.dhcp;
        device.vid = this.vid;
        device.dns = this.dns;
        return device;
    }
}

