/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.ConfigurationApplication;
import application.gui.CameraTable;
import application.helper.LanguagePreset;
import application.interfaces.IConfigurationExchange;
import connect.Connection;
import connect.listener.IAPIListener;
import connect.listener.IObjectListener;
import database.CameraObject;
import database.DatabaseConfiguration;
import exception.NoInitializedConnection;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.embed.swing.JFXPanel;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import response.Response;
import response.syno.surveillancestation.camera.ListResponse;
import response.syno.surveillancestation.camera.answer.ListAnswerValue;
import storage.SettingStorage;
import storage.connection.SettingsConnection;

public class ConfigurationPanel
extends VBox
implements IAPIListener,
IObjectListener,
IConfigurationExchange {
    private TextField ipeingabe = null;
    private TableView<CameraTable> tableView = null;
    private ObservableList<CameraTable> elementList = null;
    private TextField userName;
    private PasswordField password;
    private TextField motionUser;
    private PasswordField motionPassword;
    private SettingsConnection settingsConnection;
    private Label statusLeiste;
    private Button configUebernahme;
    private Button request;
    private Button configReset;
    private IConfigurationExchange iConfigurationExchange;
    private TableColumn<CameraTable, String> malColumn;
    private TableColumn<CameraTable, String> intervallColumn;
    private TableColumn<CameraTable, String> entryPoint;
    private Properties language;
    private boolean save = true;

    public ConfigurationPanel(LanguagePreset langguage) {
        super(3.0);
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (InputStream inputStream = ConfigurationPanel.class.getResourceAsStream(langguage.getFileName());){
                this.language = new Properties();
                this.language.load(inputStream);
                inputStream.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Connection.initConnection((String)"");
        try {
            Connection.addIAPIListener((IAPIListener)this);
            Connection.addIObjectListener((IObjectListener)this);
        }
        catch (NoInitializedConnection e) {
            e.printStackTrace();
        }
        this.settingsConnection = SettingStorage.getSettingsConnection();
        this.elementList = DatabaseConfiguration.getObservableCameraObjectList();
        VBox vBox = new VBox(5.0);
        vBox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        CornerRadii rad = new CornerRadii(3.0, 3.0, 3.0, 3.0, false);
        vBox.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.web((String)"#b0b0af"), BorderStrokeStyle.SOLID, rad, new BorderWidths(2.0))}));
        HBox hbox = new HBox(15.0);
        hbox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Label label = new Label(String.valueOf(this.language.getProperty("ipadresse")) + ":");
        this.ipeingabe = new TextField(this.settingsConnection.getIpStation());
        this.ipeingabe.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (oldValue != newValue && oldValue != null && oldValue.length() > 0 && newValue != null && newValue.length() > 0) {
                    ConfigurationPanel.this.save = false;
                }
            }
        });
        this.userName = new TextField(this.settingsConnection.getUserName());
        this.userName.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (oldValue != newValue && oldValue != null && oldValue.length() > 0 && newValue != null && newValue.length() > 0) {
                    ConfigurationPanel.this.save = false;
                }
            }
        });
        this.password = new PasswordField();
        this.password.setText(this.settingsConnection.getPassword());
        this.password.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (oldValue != newValue && oldValue != null && oldValue.length() > 0 && newValue != null && newValue.length() > 0) {
                    ConfigurationPanel.this.save = false;
                }
            }
        });
        this.request = new Button(this.language.getProperty("request"));
        this.request.setTooltip(new Tooltip(this.language.getProperty("request.tooltip")));
        this.request.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (ConfigurationPanel.this.hasValidIp(ConfigurationPanel.this.ipeingabe.getText())) {
                    Connection.getCammeraList();
                    ConfigurationPanel.this.malColumn.setEditable(true);
                    ConfigurationPanel.this.intervallColumn.setEditable(true);
                    ConfigurationPanel.this.entryPoint.setEditable(true);
                }
            }
        });
        this.request.setDisable(true);
        Button connect = new Button(this.language.getProperty("connect"));
        connect.setTooltip(new Tooltip(this.language.getProperty("connect.tooltip")));
        connect.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Connection.initConnection((String)("http://" + ConfigurationPanel.this.ipeingabe.getText() + ":5000"));
                try {
                    Connection.doAPIOverview();
                }
                catch (IOException e) {
                    ConfigurationPanel.this.statusLeiste.setText("Mit den get\u00e4tigen Angaben konnte kein Verbindungsaufbau hergestellt werden.");
                    return;
                }
                Connection.doConnect((String)ConfigurationPanel.this.userName.getText(), (String)ConfigurationPanel.this.password.getText());
                SettingStorage.saveSettings((String)ConfigurationPanel.this.userName.getText(), (String)ConfigurationPanel.this.password.getText(), (String)ConfigurationPanel.this.ipeingabe.getText(), (String)ConfigurationPanel.this.motionUser.getText(), (String)ConfigurationPanel.this.motionPassword.getText());
                ConfigurationPanel.this.request.setDisable(false);
            }
        });
        hbox.getChildren().addAll((Object[])new Node[]{label, this.ipeingabe, this.createSpacer(), connect});
        HBox zweiteZeile = new HBox(2.0);
        zweiteZeile.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        zweiteZeile.getChildren().addAll((Object[])new Node[]{new Label(this.language.getProperty("user")), this.userName, new Label(this.language.getProperty("password")), this.password, this.createSpacer(), this.request});
        vBox.getChildren().addAll((Object[])new Node[]{new Label(this.language.getProperty("ueberschriftsyno")), hbox, zweiteZeile});
        this.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        this.getChildren().addAll((Object[])new Node[]{vBox, this.getTable(), this.getMotionSettings(), this.getFooter()});
    }

    private Node getMotionSettings() {
        VBox vBox = new VBox(5.0);
        CornerRadii rad = new CornerRadii(3.0, 3.0, 3.0, 3.0, false);
        vBox.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.web((String)"#b0b0af"), BorderStrokeStyle.SOLID, rad, new BorderWidths(2.0))}));
        vBox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Label label = new Label(this.language.getProperty("labelBewegungserkennung"));
        Label userMotionLabel = new Label(this.language.getProperty("motionuser"));
        Label pwdMotionLabel = new Label(this.language.getProperty("passwordmotion"));
        HBox hBox = new HBox(5.0);
        hBox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.motionUser = new TextField();
        this.motionUser.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (oldValue != newValue && oldValue != null && oldValue.length() > 0 && newValue != null && newValue.length() > 0) {
                    ConfigurationPanel.this.save = false;
                }
            }
        });
        this.motionUser.setText(this.settingsConnection.getMotionUser());
        this.motionPassword = new PasswordField();
        this.motionPassword.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (oldValue != newValue && oldValue != null && oldValue.length() > 0 && newValue != null && newValue.length() > 0) {
                    ConfigurationPanel.this.save = false;
                }
            }
        });
        this.motionPassword.setText(this.settingsConnection.getMotionPasssword());
        hBox.getChildren().addAll((Object[])new Node[]{userMotionLabel, this.motionUser, pwdMotionLabel, this.motionPassword});
        vBox.getChildren().addAll((Object[])new Node[]{label, hBox});
        return vBox;
    }

    private Node getFooter() {
        HBox hBox = new HBox(5.0);
        hBox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Label label = new Label(this.language.getProperty("statuslabel"));
        this.statusLeiste = new Label("");
        this.configUebernahme = new Button(this.language.getProperty("speicherbutton"));
        this.configUebernahme.setTooltip(new Tooltip(this.language.getProperty("speicherbutton.tooltip")));
        this.configUebernahme.setOnAction(action -> this.saveConfiguration());
        this.configUebernahme.setDisable(true);
        this.configReset = new Button(this.language.getProperty("resetbutton"));
        this.configReset.setTooltip(new Tooltip(this.language.getProperty("resetbutton.tooltip")));
        this.configReset.setOnAction(action -> this.deleteConfiguration());
        if (this.elementList != null && this.elementList.size() > 0) {
            this.configReset.setDisable(false);
        } else {
            this.configReset.setDisable(true);
        }
        hBox.getChildren().addAll((Object[])new Node[]{label, this.statusLeiste, this.createSpacer(), this.configReset, this.configUebernahme});
        return hBox;
    }

    private void deleteConfiguration() {
        ButtonType ok = new ButtonType(this.language.getProperty("ja"), ButtonBar.ButtonData.OK_DONE);
        ButtonType abbruch = new ButtonType(this.language.getProperty("nein"), ButtonBar.ButtonData.CANCEL_CLOSE);
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "", new ButtonType[]{ok, abbruch});
        alert.setTitle(this.language.getProperty("alertdialog.loeschen.titel"));
        alert.setHeaderText(this.language.getProperty("alertdialog.loeschen.abfrage"));
        Optional buttonType = alert.showAndWait();
        if (((ButtonType)buttonType.get()).getButtonData() == ButtonBar.ButtonData.OK_DONE) {
            ArrayList<File> fList = new ArrayList<File>();
            fList.add(new File("config/data/cam.dat"));
            fList.add(new File("config/data/set.dat"));
            boolean deleteOK = true;
            boolean tmpDelete = false;
            for (File file : fList) {
                if (!file.exists() || (tmpDelete = file.delete())) continue;
                deleteOK = false;
            }
            if (deleteOK) {
                this.resetConfig();
                ok = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
                alert = new Alert(Alert.AlertType.INFORMATION, "", new ButtonType[]{ok});
                alert.setTitle(this.language.getProperty("alertdialog.loeschen.titel"));
                alert.setHeaderText(this.language.getProperty("alertdialog.loeschen.ok"));
                alert.show();
            } else {
                ok = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
                alert = new Alert(Alert.AlertType.INFORMATION, "", new ButtonType[]{ok});
                alert.setTitle(this.language.getProperty("alertdialog.loeschen.titel"));
                alert.setHeaderText(this.language.getProperty("alertdialog.loeschen.nok"));
                alert.show();
            }
            this.save = true;
            this.configUebernahme.setDisable(true);
            this.configReset.setDisable(true);
        }
    }

    private void resetConfig() {
        SettingStorage.clearSettingsConnection();
        this.settingsConnection = SettingStorage.getSettingsConnection();
        this.ipeingabe.setText(this.settingsConnection.getIpStation());
        this.userName.setText(this.settingsConnection.getUserName());
        this.password.setText(this.settingsConnection.getPassword());
        this.motionUser.setText(this.settingsConnection.getMotionUser());
        this.motionPassword.setText(this.settingsConnection.getMotionPasssword());
        this.elementList = FXCollections.observableArrayList(new ArrayList());
        this.tableView.setItems(this.elementList);
        this.statusLeiste.setText(this.language.getProperty("statusleiste.reset"));
    }

    private void saveConfiguration() {
        SettingStorage.saveSettings((String)this.userName.getText(), (String)this.password.getText(), (String)this.ipeingabe.getText(), (String)this.motionUser.getText(), (String)this.motionPassword.getText());
        if (this.elementList != null && this.elementList.size() > 0) {
            List<CameraObject> testList = new ArrayList<CameraObject>();
            int i = 0;
            while (i < this.elementList.size()) {
                testList.add(((CameraTable)this.elementList.get(i)).getCameraObject());
                ++i;
            }
            if (this.iConfigurationExchange != null) {
                testList = this.iConfigurationExchange.saveConfiguration(testList);
            }
            SettingStorage.saveCameraObjectList(testList);
        }
        this.save = true;
        this.configUebernahme.setDisable(true);
        this.configReset.setDisable(false);
    }

    private Node getTable() {
        HBox hbox = new HBox(5.0);
        hbox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.tableView = new TableView();
        this.tableView.setEditable(true);
        HBox.setHgrow(this.tableView, (Priority)Priority.ALWAYS);
        TableColumn info = new TableColumn(this.language.getProperty("info"));
        info.setEditable(false);
        TableColumn ipValue = new TableColumn(this.language.getProperty("ipadresse"));
        ipValue.setEditable(false);
        TableColumn sw = new TableColumn(this.language.getProperty("sw"));
        sw.setEditable(false);
        TableColumn api = new TableColumn(this.language.getProperty("api"));
        api.setEditable(false);
        this.entryPoint = new TableColumn(this.language.getProperty("endpunkt"));
        this.entryPoint.setEditable(false);
        this.malColumn = new TableColumn(this.language.getProperty("mal"));
        this.malColumn.setEditable(false);
        this.intervallColumn = new TableColumn(this.language.getProperty("intervall"));
        this.intervallColumn.setEditable(false);
        info.setCellValueFactory((Callback)new PropertyValueFactory("kameraInfo"));
        ipValue.setCellValueFactory((Callback)new PropertyValueFactory("ipAdresse"));
        this.entryPoint.setCellValueFactory((Callback)new PropertyValueFactory("pointMotionDetection"));
        this.entryPoint.setCellFactory(TextFieldTableCell.forTableColumn());
        this.entryPoint.setOnEditCommit(t -> ((CameraTable)t.getTableView().getItems().get(t.getTablePosition().getRow())).setPointMotionDetection((String)t.getNewValue()));
        this.malColumn.setCellValueFactory((Callback)new PropertyValueFactory("mal"));
        this.malColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.malColumn.setOnEditCommit(t -> this.setMal((TableColumn.CellEditEvent<CameraTable, String>)t));
        this.intervallColumn.setCellValueFactory((Callback)new PropertyValueFactory("intervallInSekunden"));
        this.intervallColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.intervallColumn.setOnEditCommit(t -> this.setInterVall((TableColumn.CellEditEvent<CameraTable, String>)t));
        sw.setCellValueFactory(callback -> new SimpleBooleanProperty(((CameraTable)callback.getValue()).getSwAktiv()));
        sw.setCellFactory(tableColumn -> new CheckBoxTableCell());
        api.setCellValueFactory(callback -> new SimpleBooleanProperty(((CameraTable)callback.getValue()).getApiAktiv()));
        api.setCellFactory(tableColumn -> new CheckBoxTableCell());
        this.tableView.getColumns().addAll((Object[])new TableColumn[]{info, ipValue, sw, api, this.entryPoint, this.malColumn, this.intervallColumn});
        this.tableView.setItems(this.elementList);
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        hbox.getChildren().addAll((Object[])new Node[]{this.tableView});
        return hbox;
    }

    private void setInterVall(TableColumn.CellEditEvent<CameraTable, String> t) {
        CameraTable cameraTable = (CameraTable)t.getTableView().getItems().get(t.getTablePosition().getRow());
        cameraTable.setIntervallInSekunden((String)t.getNewValue());
    }

    private void setMal(TableColumn.CellEditEvent<CameraTable, String> t) {
        CameraTable cameraTable = (CameraTable)t.getTableView().getItems().get(t.getTablePosition().getRow());
        String newValue = (String)t.getNewValue();
        try {
            int intValue = Integer.parseInt(newValue);
            if (intValue > 0) {
                cameraTable.setMal(newValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasValidIp(String ipString) {
        if (ipString == null) return false;
        int anzahlPunkte = 0;
        int i = 0;
        while (i < ipString.length()) {
            char value = ipString.charAt(i);
            if (value == '.') {
                ++anzahlPunkte;
            }
            ++i;
        }
        if (anzahlPunkte != 3) {
            return false;
        }
        String[] elemente = ipString.split(".");
        if (elemente == null) return true;
        if (elemente.length != 4) return true;
        try {
            int i2 = 0;
            while (true) {
                if (i2 >= elemente.length) {
                    return true;
                }
                int value = Integer.parseInt(elemente[i2]);
                if (value < 0) return false;
                if (value > 255) {
                    return false;
                }
                ++i2;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    private Node createSpacer() {
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        return spacer;
    }

    public void setIAPIAnswerValue(int statusCode, String valueFromBody) {
        this.statusLeiste.setTextFill((Paint)Color.web((String)"#000000"));
        this.statusLeiste.setText("" + statusCode);
    }

    public void stop() {
        if (!this.save) {
            ButtonType ok = new ButtonType(this.language.getProperty("Ja"), ButtonBar.ButtonData.OK_DONE);
            ButtonType abbruch = new ButtonType(this.language.getProperty("Nein"), ButtonBar.ButtonData.CANCEL_CLOSE);
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, this.language.getProperty("alertdialog.hinweis.text1"), new ButtonType[]{ok, abbruch});
            alert.setTitle(this.language.getProperty("alertdialog.hinweis.titel"));
            alert.setHeaderText(this.language.getProperty("alertdialog.hinweis.text2"));
            Optional buttonType = alert.showAndWait();
            if (((ButtonType)buttonType.get()).getButtonData() == ButtonBar.ButtonData.OK_DONE) {
                this.saveConfiguration();
            }
        }
        Connection.removeIAPIListener((IAPIListener)this);
        SettingStorage.clearSettingsConnection();
    }

    public void setIObjectChange(Response<?, ?> response) {
        if (response instanceof ListResponse) {
            ListResponse listResponse = (ListResponse)response;
            ListAnswerValue listAnswerValue = listResponse.getListAnswerValue();
            if (listResponse.isErrorObjectFilled()) {
                this.statusLeiste.setTextFill((Paint)Color.web((String)"#FF0000"));
                this.statusLeiste.setText(this.language.getProperty("statusleiste.connect.errorobject"));
                this.statusLeiste.setText("");
                this.request.setDisable(true);
                return;
            }
            if (listAnswerValue != null) {
                List cameraList = listAnswerValue.getCameraList();
                if (this.elementList == null || this.elementList.size() <= 0) {
                    this.elementList = DatabaseConfiguration.createNewObservableCameraObjectList(cameraList);
                    this.tableView.setItems(this.elementList);
                } else {
                    int i = 0;
                    while (i < cameraList.size()) {
                        ++i;
                    }
                }
                this.configUebernahme.setDisable(false);
            }
        }
    }

    @Override
    public List<CameraObject> saveConfiguration(List<CameraObject> toSaveList) {
        return null;
    }

    @Override
    public void setConnectedList(IConfigurationExchange iConfigurationExchange, List<CameraObject> integratedList) {
        this.iConfigurationExchange = iConfigurationExchange;
        if (integratedList != null && integratedList.size() > 0) {
            int i = 0;
            while (i < integratedList.size()) {
                CameraObject camObject = integratedList.get(i);
                int x = 0;
                while (x < this.elementList.size()) {
                    if (((CameraTable)this.elementList.get(i)).getCameraObject().getKameraid_software() == camObject.getKameraid_software()) {
                        ((CameraTable)this.elementList.get(i)).setSwAktiv(true);
                        break;
                    }
                    ++x;
                }
                ++i;
            }
        }
    }

    public static Component getFXPanel(ConfigurationPanel configPanel) {
        JFXPanel fxPanel = new JFXPanel();
        BorderPane root = new BorderPane();
        Scene scene = new Scene((Parent)root, 500.0, 400.0);
        root.setCenter((Node)configPanel);
        scene.getStylesheets().add((Object)ConfigurationApplication.class.getResource("application.css").toExternalForm());
        fxPanel.setScene(scene);
        return fxPanel;
    }

    public boolean isSaved() {
        return this.save;
    }
}

