/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.sn.storage.transfer;

import de.bscgmbh.sn.storage.transfer.ITransferListener;
import de.bscgmbh.sn.storage.transfer.ITransferWorker;
import de.bscgmbh.sn.storage.transfer.TransferJob;
import de.bscgmbh.sn.storage.transfer.TransferStats;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferManager
implements ITransferListener {
    private static TransferManager instance = null;
    protected static Logger logger = LoggerFactory.getLogger(TransferManager.class);
    protected long currentTransferID = 0L;
    protected final Queue<TransferJob> jobs = new LinkedList<TransferJob>();
    protected final Queue<TransferJob> jobHistory = new LinkedList<TransferJob>();
    protected TransferThread transferThread = null;
    protected Set<ITransferListener> transferListener = new HashSet<ITransferListener>();
    protected int jobHistoryMaxSize = 50;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferJob createAndStartTransferJob(String storageID, TransferJob.TransferDirection direction, String displayName, ITransferWorker worker) {
        TransferJob result = null;
        if (worker != null) {
            if (this.currentTransferID == Long.MAX_VALUE) {
                this.currentTransferID = 0L;
            }
            result = new TransferJob(this.currentTransferID++, direction, storageID, displayName, worker, this);
            logger.debug("TransferJob created: " + this.currentTransferID);
            Queue<TransferJob> queue = this.jobs;
            synchronized (queue) {
                this.jobs.add(result);
            }
            this.executeJobs();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addJobToHistory(TransferJob job) {
        Queue<TransferJob> queue = this.jobHistory;
        synchronized (queue) {
            while (this.jobHistory.size() >= this.jobHistoryMaxSize) {
                this.jobHistory.poll();
            }
            this.jobHistory.add(job);
        }
    }

    protected synchronized void executeJobs() {
        if (this.transferThread == null) {
            this.transferThread = new TransferThread();
            this.transferThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerTransferListener(ITransferListener listener) {
        Set<ITransferListener> set = TransferManager.getInstance().transferListener;
        synchronized (set) {
            TransferManager.getInstance().transferListener.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterTransferListener(ITransferListener listener) {
        Set<ITransferListener> set = TransferManager.getInstance().transferListener;
        synchronized (set) {
            TransferManager.getInstance().transferListener.remove(listener);
        }
    }

    public static TransferJob createTransferJob(String storageID, TransferJob.TransferDirection direction, String displayName, ITransferWorker worker) {
        return TransferManager.getInstance().createAndStartTransferJob(storageID, direction, displayName, worker);
    }

    public static boolean isIdle() {
        return TransferManager.getInstance().transferThread == null;
    }

    public static List<TransferJob> getAllJobs() {
        LinkedList<TransferJob> result = new LinkedList<TransferJob>();
        result.addAll(TransferManager.getInstance().jobs);
        result.addAll(TransferManager.getInstance().jobHistory);
        return result;
    }

    public static TransferManager getInstance() {
        if (instance == null) {
            instance = new TransferManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferJobUpdated(TransferJob job) {
        Set<ITransferListener> set = this.transferListener;
        synchronized (set) {
            for (ITransferListener listener : this.transferListener) {
                listener.transferJobUpdated(job);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferStatsUpdated(TransferStats stats) {
        Set<ITransferListener> set = this.transferListener;
        synchronized (set) {
            for (ITransferListener listener : this.transferListener) {
                listener.transferStatsUpdated(stats);
            }
        }
    }

    protected class TransferThread
    extends Thread {
        protected TransferThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TransferJob job = null;
            while ((job = this.pollJob()) != null) {
                job.execute();
                TransferManager.this.addJobToHistory(job);
            }
            this.syncFS();
            TransferManager transferManager = instance;
            synchronized (transferManager) {
                TransferManager.this.transferThread = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TransferJob pollJob() {
            Queue<TransferJob> queue = TransferManager.this.jobs;
            synchronized (queue) {
                return TransferManager.this.jobs.poll();
            }
        }

        protected void syncFS() {
            logger.debug("Synchronize filesystem write cache...");
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            ArrayList<String> commandString = new ArrayList<String>();
            commandString.add("sync");
            processBuilder.command(commandString.toArray(new String[commandString.size()]));
            Process process = null;
            try {
                process = processBuilder.start();
            }
            catch (IOException e1) {
                logger.error(e1.getMessage(), (Throwable)e1);
            }
            if (process != null) {
                try (InputStreamReader isr = new InputStreamReader(process.getInputStream());
                     BufferedReader br = new BufferedReader(isr);){
                    while (br.readLine() != null) {
                    }
                    process.waitFor();
                }
                catch (IOException | InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

