/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.sn.storage.transfer;

import de.bscgmbh.sn.storage.transfer.ITransferListener;
import de.bscgmbh.sn.storage.transfer.ITransferWorker;
import de.bscgmbh.sn.storage.transfer.TransferStats;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TransferJob {
    protected long transferID;
    protected String storageID;
    protected String displayName;
    protected TransferState state = TransferState.PENDING;
    protected TransferDirection direction;
    protected long startedAt = -1L;
    protected long finishedAt = -1L;
    protected final transient ITransferWorker worker;
    protected final transient ITransferListener listener;
    protected Map<String, TransferStats> fileTransferStats;

    public TransferJob(long transferID, TransferDirection direction, String storageID, String displayName, ITransferWorker worker, ITransferListener listener) {
        this.direction = Objects.requireNonNull(direction, "direction must not be null!");
        this.transferID = transferID;
        this.storageID = storageID;
        this.displayName = displayName;
        this.worker = Objects.requireNonNull(worker, "worker must not be null!");
        this.listener = Objects.requireNonNull(listener, "listener must not be null!");
    }

    public long getTransferID() {
        return this.transferID;
    }

    public void setTransferID(long transferID) {
        this.transferID = transferID;
    }

    public String getStorageID() {
        return this.storageID;
    }

    public void setStorageID(String storageID) {
        this.storageID = storageID;
    }

    public long getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(long startedAt) {
        this.startedAt = startedAt;
    }

    public long getFinishedAt() {
        return this.finishedAt;
    }

    public void setFinishedAt(long finishedAt) {
        this.finishedAt = finishedAt;
    }

    public Map<String, TransferStats> getFileTransferStats() {
        if (this.fileTransferStats == null) {
            this.fileTransferStats = new HashMap<String, TransferStats>();
        }
        return this.fileTransferStats;
    }

    public void setFileTransferStats(Map<String, TransferStats> fileTransferStats) {
        this.fileTransferStats = fileTransferStats;
    }

    public TransferState getState() {
        return this.state;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setState(TransferState state) {
        boolean equals = this.state.equals((Object)state);
        if (!equals) {
            this.state = state;
            this.listener.transferJobUpdated(this);
        }
    }

    public long getRunningTime() {
        return this.getStartedAt() > 0L && this.getFinishedAt() > 0L ? this.getFinishedAt() - this.getStartedAt() : -1L;
    }

    public String toString() {
        return "TransferJob [transferID=" + this.transferID + ", storageID=" + this.storageID + ", displayName=" + this.displayName + ", state=" + (Object)((Object)this.state) + ", direction=" + (Object)((Object)this.direction) + ", startedAt=" + this.startedAt + ", finishedAt=" + this.finishedAt + ", worker=" + this.worker + ", listener=" + this.listener + ", fileTransferStats=" + this.fileTransferStats + "]";
    }

    public void execute() {
        if (this.worker != null) {
            this.setStartedAt(System.currentTimeMillis());
            this.setState(TransferState.RUNNING);
            TransferState newState = this.worker.executeTransfer(this) ? TransferState.SUCCESSFUL : TransferState.FAILED;
            this.setFinishedAt(System.currentTimeMillis());
            this.setState(newState);
        }
    }

    public void pushTransferStats(TransferStats stats) {
        if (stats != null) {
            stats.setTransferID(this.getTransferID());
            this.getFileTransferStats().put(stats.getFileName(), stats);
            this.listener.transferStatsUpdated(stats);
        }
    }

    public static enum TransferDirection {
        UPLOAD,
        DOWNLOAD;

    }

    public static enum TransferState {
        PENDING,
        RUNNING,
        SUCCESSFUL,
        FAILED;

    }
}

