/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.sn.storage.provider;

import de.bscgmbh.sn.config.forms.GenericConfigurationFormField;
import de.bscgmbh.sn.storage.StorageContent;
import de.bscgmbh.sn.storage.provider.IStorageProviderImpl;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;

public abstract class AStorageProviderImpl
implements IStorageProviderImpl {
    protected static final String LOCALIZATION_PREFIX = "storage.remote.provider.";
    protected static final String LOCALIZATION_SUFIX_NAME = ".name";
    protected static final String LOCALIZATION_SUFIX_DESC = ".desc";
    protected String name;
    protected String description;
    protected ArrayList<GenericConfigurationFormField> configurationTemplate;
    protected Set<StorageContent> possibleStorageContent;

    protected AStorageProviderImpl() {
        String className = this.getClass().getSimpleName();
        this.name = LOCALIZATION_PREFIX + className + LOCALIZATION_SUFIX_NAME;
        this.description = LOCALIZATION_PREFIX + className + LOCALIZATION_SUFIX_DESC;
    }

    public AStorageProviderImpl(String name, String description) {
        this.name = name;
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addConfigurationFieldToTemplate(GenericConfigurationFormField field) {
        this.getConfigurationTemplate().add(field);
    }

    public void clearConfigurationTemplate() {
        this.getConfigurationTemplate().clear();
    }

    public void setConfigurationTemplate(ArrayList<GenericConfigurationFormField> configurationTemplate) {
        this.configurationTemplate = configurationTemplate;
    }

    public String toString() {
        return "ARemoteStorageProviderEntry [name=" + this.name + ", description=" + this.description + ", configurationTemplate=" + this.configurationTemplate + "]";
    }

    @Override
    public ArrayList<GenericConfigurationFormField> getConfigurationTemplate() {
        if (this.configurationTemplate == null) {
            this.configurationTemplate = new ArrayList();
        }
        return this.configurationTemplate;
    }

    public void setPossibleStorageContent(Set<StorageContent> possibleStorageContent) {
        this.possibleStorageContent = possibleStorageContent;
    }

    @Override
    public Set<StorageContent> getPossibleStorageContent() {
        if (this.possibleStorageContent == null) {
            this.possibleStorageContent = EnumSet.noneOf(StorageContent.class);
        }
        return this.possibleStorageContent;
    }

    public static String addContentDirectoryToFilePath(StorageContent storageContent, String path) {
        return path == null ? storageContent.getContentDirectory() : storageContent.getContentDirectory() + "/" + path;
    }
}

