/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.sn.storage.configuration;

import de.bscgmbh.sn.config.forms.GenericConfigurationFormField;
import de.bscgmbh.sn.storage.configuration.FileStorageProviderConfiguration;
import de.bscgmbh.sn.storage.configuration.IStorageProviderConfiguration;
import de.bscgmbh.sn.storage.configuration.IStorageProviderConfigurationFactory;
import de.bscgmbh.sn.storage.configuration.StorageProviderConfiguration;
import de.bscgmbh.sn.storage.provider.ISimpleFileStorageProviderImpl;
import de.bscgmbh.sn.storage.provider.IStorageProviderImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class StorageProviderConfigurationFactory
implements IStorageProviderConfigurationFactory {
    private static IStorageProviderConfigurationFactory configurationFactory = null;

    @Override
    public IStorageProviderConfiguration createNewInstance(String id, IStorageProviderImpl storageProvider) {
        return this.createNewInstance(id, storageProvider, StorageProviderConfigurationFactory.deepClone(storageProvider.getConfigurationTemplate()));
    }

    @Override
    public IStorageProviderConfiguration createNewInstance(String id, IStorageProviderImpl storageProvider, ArrayList<GenericConfigurationFormField> configuration) {
        if (storageProvider instanceof ISimpleFileStorageProviderImpl) {
            return new FileStorageProviderConfiguration(id, (ISimpleFileStorageProviderImpl)storageProvider, configuration);
        }
        return new StorageProviderConfiguration(id, storageProvider, configuration);
    }

    @Override
    public IStorageProviderConfiguration createTypedConfigurationInstance(IStorageProviderConfiguration configuration) {
        if (configuration == null) {
            return null;
        }
        if (configuration.getStorageProvider() instanceof ISimpleFileStorageProviderImpl) {
            return new FileStorageProviderConfiguration(configuration);
        }
        return new StorageProviderConfiguration(configuration);
    }

    public static IStorageProviderConfigurationFactory getConfigurationFactory() {
        if (configurationFactory == null) {
            configurationFactory = new StorageProviderConfigurationFactory();
        }
        return configurationFactory;
    }

    public static void setConfigurationFactory(IStorageProviderConfigurationFactory configurationFactory) {
        StorageProviderConfigurationFactory.configurationFactory = configurationFactory;
    }

    public static IStorageProviderConfiguration createNewConfiguration(IStorageProviderImpl storageProvider) {
        return StorageProviderConfigurationFactory.createNewConfiguration(null, storageProvider);
    }

    public static IStorageProviderConfiguration createNewConfiguration(String id, IStorageProviderImpl storageProvider) {
        return StorageProviderConfigurationFactory.getConfigurationFactory().createNewInstance(id, storageProvider);
    }

    public static IStorageProviderConfiguration createNewConfiguration(String id, IStorageProviderImpl storageProvider, ArrayList<GenericConfigurationFormField> configuration) {
        return StorageProviderConfigurationFactory.getConfigurationFactory().createNewInstance(id, storageProvider, configuration);
    }

    public static IStorageProviderConfiguration createTypedConfiguration(IStorageProviderConfiguration configuration) {
        return StorageProviderConfigurationFactory.getConfigurationFactory().createTypedConfigurationInstance(configuration);
    }

    protected static <T> T deepClone(T object) {
        Object result = null;
        if (object != null && object instanceof Serializable) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(object);
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                ObjectInputStream ois = new ObjectInputStream(bais);
                result = ois.readObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (T)result;
    }
}

