/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.xpm;

import com.wibu.xpm.Logger;
import com.wibu.xpm.ProgressWindow;
import com.wibu.xpm.Version;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class UpdateSignature
implements Runnable {
    static final int major = 10;
    static final int minor = 0;
    static final int build = 2594;
    static final int release = 500;
    static final int year = 2017;
    static final int month = 4;
    static final int day = 3;
    protected Version mVersion = new Version(10, 0, 2594, 500, 2017, 4, 3);
    protected static String domain = "http://www.wibu.com/";
    protected static String baseUrl = domain + "files/java/";
    protected final String kwindowtitle = "WIBU-SYSTEMS Software Protection";
    private boolean fAutoDetextProxy = true;
    private boolean fRunningAsApp = false;
    private Proxy proxy = null;
    protected byte[] signature = null;
    protected String filnameSignature = null;
    protected Progress progress = null;

    public UpdateSignature() {
        String overridenUrl = System.getProperty("com.wibu.xpm.signature.url");
        if (null != overridenUrl) {
            domain = overridenUrl;
            baseUrl = overridenUrl;
        }
    }

    protected boolean agreeDownload() {
        String javaVersion = System.getProperty("java.runtime.version");
        String operatingSystem = System.getProperty("os.name");
        String platform = System.getProperty("sun.arch.data.model");
        if (javaVersion == null) {
            javaVersion = "";
        }
        if (operatingSystem == null) {
            operatingSystem = "";
        }
        if (platform == null) {
            platform = "";
        }
        if (operatingSystem.toLowerCase().contains("mac")) {
            operatingSystem = "OSX";
        } else if (operatingSystem.toLowerCase().contains("win")) {
            operatingSystem = "Win" + platform;
        } else if (operatingSystem.toLowerCase().contains("linux")) {
            operatingSystem = "Linux" + platform;
        }
        Object[] options = new Object[]{"Download", "Abort"};
        int nStatus = JOptionPane.showOptionDialog(null, "Unknown Java Virtual Machine (" + operatingSystem + " " + javaVersion + ") found!\nDo you want to download and install new signatures?", "WIBU-SYSTEMS Software Protection", 0, 0, null, options, options[0]);
        return 0 == nStatus;
    }

    private boolean saveInClassPath() {
        String libExtDir = System.getProperty("java.home");
        File file = new File(libExtDir + File.separator + "lib" + File.separator + "ext" + File.separator + this.filnameSignature);
        this.progress.rsopNegLqC(90, " in global classpath ... ");
        try {
            UpdateSignature.writeToFile(file, this.signature);
        }
        catch (IOException e) {
            this.progress.rsopNegLqC(91, "failed!\n");
            try {
                this.progress.rsopNegLqC(95, "Saving data in user directory ... ");
                file = new File(System.getProperty("user.home") + File.separator + this.filnameSignature);
                UpdateSignature.writeToFile(file, this.signature);
            }
            catch (IOException ignore) {
                this.progress.rsopNegLqC(-1, "failed!");
                return false;
            }
        }
        this.progress.rsopNegLqC(100, "done.");
        return true;
    }

    private static void writeToFile(File file, byte[] signature) throws IOException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            fout.write(signature);
            fout.flush();
        }
        finally {
            if (fout != null) {
                fout.close();
            }
        }
    }

    private void log(String message) {
        if (this.fRunningAsApp) {
            System.out.println(message);
        } else {
            Logger.getLogger(false).info(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadSignature() {
        try {
            HttpURLConnection connection;
            this.filnameSignature = "WibuVm.jar";
            URL url = new URL(baseUrl + this.filnameSignature);
            this.progress.start("Connecting to " + domain + "...");
            Proxy proxy = this.getProxy();
            if (null == proxy) {
                this.log("No proxy required.");
                connection = (HttpURLConnection)url.openConnection(proxy);
            } else {
                this.log("Using proxy '" + proxy.toString() + "'.");
                connection = (HttpURLConnection)url.openConnection();
            }
            connection.connect();
            this.progress.rsopNegLqC(10, "done.\n");
            this.progress.rsopNegLqC(15, "Downloading data ...");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            InputStream instream = connection.getInputStream();
            int nTotalRead = 0;
            try {
                byte[] buffer = new byte[1024];
                int nRead = 0;
                int nProgress = 16;
                while (-1 != (nRead = instream.read(buffer))) {
                    nTotalRead += nRead;
                    bos.write(buffer, 0, nRead);
                    if (nProgress >= 70) continue;
                    this.progress.rsopNegLqC(nProgress++, ".");
                }
            }
            finally {
                instream.close();
            }
            this.signature = bos.toByteArray();
            this.progress.rsopNegLqC(70, " (" + nTotalRead / 1024 + " kB) done.\n");
        }
        catch (Exception e) {
            this.progress.rsopNegLqC(-1, "FAILED:\n" + e.getMessage());
            return false;
        }
        return true;
    }

    protected Proxy getProxy() {
        if (!this.fAutoDetextProxy) {
            return this.proxy;
        }
        String strSystemProperty = "java.net.useSystemProxies";
        System.setProperty(strSystemProperty, "true");
        try {
            List<Proxy> list = ProxySelector.getDefault().select(new URI(baseUrl));
            if (!list.isEmpty()) {
                this.proxy = list.get(0);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return this.proxy;
    }

    public static void main(String[] args) {
        UpdateSignature ups = new UpdateSignature();
        ups.fRunningAsApp = true;
        System.out.println();
        System.out.println("WIBU Executable Software Protection, Version " + ups.mVersion.getVersion());
        System.out.println("VM Signature Update," + ups.mVersion.getBuild() + " of " + ups.mVersion.getDate());
        System.out.println(ups.mVersion.getCopyRight());
        switch (args.length) {
            case 0: {
                break;
            }
            case 1: {
                if (0 == args[0].compareToIgnoreCase("-noproxy")) {
                    ups.fAutoDetextProxy = false;
                    break;
                }
                ups.showUsage();
                break;
            }
            case 2: {
                if (0 == args[0].compareToIgnoreCase("-proxy")) {
                    String[] tokens = args[1].split(":");
                    if (tokens.length != 2) {
                        ups.showUsage();
                    }
                    String hostname = tokens[0];
                    int port = Integer.parseInt(tokens[1]);
                    ups.fAutoDetextProxy = false;
                    ups.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(hostname, port));
                    break;
                }
                ups.showUsage();
                break;
            }
            default: {
                ups.showUsage();
            }
        }
        ups.run();
        System.out.println("Done.");
    }

    private void showUsage() {
        System.out.println("Use: 'java com.wibu.UpdateSignature [-proxy ProxyHost:ProxyPort]|-noproxy]'.");
        System.exit(1);
    }

    @Override
    public void run() {
        try {
            if (!this.fRunningAsApp && !this.agreeDownload()) {
                System.exit(1);
            }
            this.progress = new Progress();
            if (!this.downloadSignature()) {
                JOptionPane.showMessageDialog(null, "Could not download information!", "WIBU-SYSTEMS Software Protection", 0);
                System.exit(1);
            }
            this.progress.rsopNegLqC(80, "Saving data");
            if (!this.saveInClassPath()) {
                this.progress.xHFy5RFC1u();
                System.exit(1);
            }
            this.progress.xHFy5RFC1u();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class Progress {
        protected ProgressWindow lpyx6waELX;
        protected JFrame DW3ZtIy4SP;

        private Progress() {
        }

        public void start(String text) {
            this.DW3ZtIy4SP = new JFrame();
            this.DW3ZtIy4SP.setTitle("WIBU-SYSTEMS Software Protection");
            this.DW3ZtIy4SP.setLocationByPlatform(true);
            ProgressWindow newContentPane = this.lpyx6waELX = new ProgressWindow();
            newContentPane.setOpaque(true);
            this.DW3ZtIy4SP.setContentPane(newContentPane);
            BoxLayout boxLayout = new BoxLayout(this.DW3ZtIy4SP.getContentPane(), 1);
            this.DW3ZtIy4SP.setLayout(boxLayout);
            this.DW3ZtIy4SP.pack();
            this.DW3ZtIy4SP.setSize(600, 320);
            this.DW3ZtIy4SP.setVisible(true);
            this.lpyx6waELX.start(text);
        }

        public void rsopNegLqC(int RRaTniZW, String suOpMzrG) {
            if (null != this.lpyx6waELX) {
                this.lpyx6waELX.QD9LPCNXpo(RRaTniZW, suOpMzrG);
            }
        }

        public void xHFy5RFC1u() {
            this.lpyx6waELX.QD9LPCNXpo(100, "");
            JLabel HFJ9gi1s = new JLabel("Download and installation succeeded.\n Please restart the application.");
            JButton sAp0ASzd = new JButton("OK");
            HFJ9gi1s.setAlignmentX(1.0f);
            this.DW3ZtIy4SP.add(HFJ9gi1s);
            this.DW3ZtIy4SP.add(sAp0ASzd);
            this.DW3ZtIy4SP.setVisible(true);
            sAp0ASzd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Progress.this.DW3ZtIy4SP.dispose();
                }
            });
        }
    }
}

