/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.xpm;

import com.wibu.xpm.Janitor;
import com.wibu.xpm.Logger;
import com.wibu.xpm.MessageHandler;
import com.wibu.xpm.Runtime;
import com.wibu.xpm.Starter;
import com.wibu.xpm.Version;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class SystemClassLoader
extends ClassLoader
implements Runnable {
    static final int major = 10;
    static final int minor = 0;
    static final int build = 2594;
    static final int release = 500;
    static final int year = 2017;
    static final int month = 4;
    static final int day = 3;
    protected Version mVersion = new Version(10, 0, 2594, 500, 2017, 4, 3);
    protected Runtime mRuntime = null;
    protected boolean mfInitialized = false;
    protected boolean mfRuntimeCheckFailed = false;
    protected Logger mLogger = null;
    protected Thread mthrSecurity = null;
    protected String mstrWhiteList = null;

    public SystemClassLoader(ClassLoader parent) {
        super(parent);
    }

    private void init() {
        if (!this.mfInitialized) {
            try {
                Starter starter = Starter.getInstance();
                starter.setVerbose(false, null);
                MessageHandler msghandler = starter.createMessageHandler();
                Runtime.init(msghandler);
                msghandler.messageStart();
                starter.openClassLoader(false);
                this.mfInitialized = true;
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
            this.mRuntime = Runtime.getInstance();
            try {
                String strWhiteListDb = "com/wibu/xpm/encrypted";
                Enumeration<URL> enumUrls = this.findResources(strWhiteListDb);
                if (null != enumUrls) {
                    URL url;
                    this.mstrWhiteList = new String();
                    while (enumUrls.hasMoreElements() && null != (url = enumUrls.nextElement())) {
                        byte[] bWhiteList = SystemClassLoader.readFully(url);
                        if (null == bWhiteList) continue;
                        this.mLogger.info("Reading whitelist file");
                        String strWhiteList = new String(bWhiteList);
                        this.mstrWhiteList = this.mstrWhiteList + strWhiteList.replaceAll("\n", ":");
                    }
                    this.mLogger.info("WhiteList: " + this.mstrWhiteList);
                }
            }
            catch (IOException ex) {
                this.mLogger.warning("Error reading whitelist file: " + ex.getLocalizedMessage());
            }
            Janitor.addShutdownHook(this.mRuntime);
            this.mthrSecurity = new Thread(this);
            this.mLogger.fine("SystemClassLoader initialized.");
        }
    }

    @Override
    public void run() {
        int nSecondsToLoop = 4;
        block6: while (true) {
            try {
                while (true) {
                    Thread.sleep((long)nSecondsToLoop * 1000L);
                    this.mLogger.debug("Executing Runtime Check");
                    int nResult = this.mRuntime.runtimeCheck();
                    this.mLogger.debug("Runtime Check returned " + Integer.toString(nResult));
                    switch (nResult) {
                        case 0: {
                            nSecondsToLoop = 5;
                            continue block6;
                        }
                        case -1: {
                            this.mLogger.error("Runtime check failed!");
                            this.mfRuntimeCheckFailed = true;
                            System.exit(0);
                            continue block6;
                        }
                    }
                    nSecondsToLoop = Math.abs(nResult);
                }
            }
            catch (Exception ex) {
                this.mLogger.debug("Exception in Security Thread: " + ex.getLocalizedMessage());
                continue;
            }
            break;
        }
    }

    protected boolean shouldLoadWithJni(String strClassName) {
        if (this.mstrWhiteList != null) {
            String[] astrTokens = this.mstrWhiteList.split(":");
            for (int i = 0; i < astrTokens.length; ++i) {
                if (0 == astrTokens[i].length() || !strClassName.startsWith(astrTokens[i])) continue;
                this.mLogger.info("Class " + strClassName + " matches whitelist.");
                return true;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        String className;
        Class clazz;
        block19: {
            if (null == this.mLogger) {
                this.mLogger = Logger.getLogger(true);
            }
            this.mLogger.trace("SystemClassLoader.loadClass(" + name + ")");
            clazz = super.findLoadedClass(name);
            if (clazz != null) {
                this.mLogger.info("Found already loaded class " + name);
                return clazz;
            }
            className = name.replace('.', '/') + ".class";
            try {
                clazz = super.loadClass(name, resolve);
                this.mLogger.fine("System loaded " + name);
            }
            catch (ClassNotFoundException e) {
                InputStream inStream = null;
                byte[] classBytes = null;
                try {
                    inStream = this.getResourceAsStream(className + ".wibu");
                    if (null == inStream) {
                        this.mLogger.fine("Error looking for " + className + ".wibu - trying with Context CL");
                        inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(className + ".wibu");
                    }
                    if (null == inStream) {
                        this.mLogger.info("Error loading class '" + name + "'");
                        throw e;
                    }
                    if (!this.mfInitialized) {
                        this.init();
                    }
                    classBytes = SystemClassLoader.readFully(inStream);
                }
                finally {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException e1) {
                            this.mLogger.warning("Error closing stream");
                        }
                    }
                }
                if (classBytes == null) {
                    this.mLogger.fine("Class " + className + "' not found!");
                }
                if (!this.mthrSecurity.isAlive()) {
                    this.mLogger.debug("Starting security thread.");
                    this.mthrSecurity.start();
                    Thread.yield();
                }
                if (null == (clazz = this.mRuntime.loadClass(this, name.replace('.', '/'), classBytes))) break block19;
                this.mLogger.fine("Class '" + className + "' decrypted.");
            }
        }
        if (null != clazz) {
            URL url = this.getResource(className + ".wibu");
            this.addPackage(name, url);
            return clazz;
        }
        return clazz;
    }

    protected void addPackage(String strClassName, URL url) {
        int i = strClassName.lastIndexOf(46);
        if (i != -1) {
            String strPkgName = strClassName.substring(0, i);
            String specTitle = null;
            String specVersion = null;
            String specVendor = null;
            String implTitle = null;
            String implVersion = null;
            String implVendor = null;
            URL sealBase = null;
            Package pkg = this.getPackage(strPkgName);
            if (null != pkg) {
                return;
            }
            try {
                Attributes mainAttributes;
                JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                Manifest manifest = jarConnection.getManifest();
                if (null != manifest && null != (mainAttributes = manifest.getMainAttributes())) {
                    specTitle = mainAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
                    specVersion = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                    specVendor = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                    implTitle = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                    implVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                    implVendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.definePackage(strPkgName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFully(URL url) throws IOException {
        InputStream in = null;
        try {
            in = url.openStream();
            if (in == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = SystemClassLoader.readFully(in);
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    Logger.getLogger(true).error(e.getLocalizedMessage());
                }
            }
        }
    }

    public static byte[] readFully(InputStream in) {
        byte[] bs = null;
        int nSize = 0;
        try {
            nSize = in.available();
            bs = new byte[nSize];
            for (int nRead = 0; nRead < nSize; nRead += in.read(bs, nRead, nSize - nRead)) {
            }
            return bs;
        }
        catch (Exception e) {
            Logger.getLogger(true).error(e.getLocalizedMessage());
            return bs;
        }
    }

    public String toString() {
        return "com.wibu.xpm.SystemClassLoader " + this.mVersion.toString();
    }
}

