/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.net.URI;
import motion.AuthFilter;
import motion.MotionDetectionService;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.filter.LoggingFilter;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import tools.Network;

public class ServerSurveillance {
    private static ServerSurveillance surveillance = null;
    private HttpServer server = null;

    private ServerSurveillance() {
        String networkAdress = Network.getEthernetAddress();
        String baseUrl = "http://" + networkAdress + ":9999/";
        ResourceConfig rc = new ResourceConfig();
        rc.register(AuthFilter.class);
        rc.register(MotionDetectionService.class);
        rc.register(LoggingFilter.class);
        this.server = GrizzlyHttpServerFactory.createHttpServer((URI)URI.create(baseUrl), (ResourceConfig)rc, (boolean)false);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                ServerSurveillance.this.server.shutdownNow();
            }
        }));
    }

    public static void serverStart() {
        if (surveillance == null) {
            surveillance = new ServerSurveillance();
        }
        if (!ServerSurveillance.surveillance.server.isStarted()) {
            try {
                ServerSurveillance.surveillance.server.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void serverStop() {
        if (surveillance == null) {
            return;
        }
        if (ServerSurveillance.surveillance.server.isStarted()) {
            try {
                ServerSurveillance.surveillance.server.stop();
                ServerSurveillance.surveillance.server = null;
                surveillance = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        ServerSurveillance.serverStart();
    }
}

