/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.modules.ipc;

import bsc.sdk.kernel.modules.ipc.IPCObject;
import bsc.sdk.kernel.modules.ipc.IPCSocketTransceiver;
import org.slf4j.LoggerFactory;

public final class RemoteExecutionContainer<T>
implements IPCObject<RemoteExecutionContainer<T>>,
IPCSocketTransceiver.IPCSocketObjectListener {
    protected String executionID;
    protected IPCObject<T> object;
    protected boolean executionFinished = false;

    private RemoteExecutionContainer() {
    }

    public RemoteExecutionContainer(IPCObject<T> object) {
        this(object, null);
    }

    public RemoteExecutionContainer(IPCObject<T> object, String executionID) {
        this.executionID = executionID;
        this.object = object;
    }

    public String getExecutionID() {
        return this.executionID;
    }

    public void setExecutionID(String executionID) {
        this.executionID = executionID;
    }

    public IPCObject<T> getObject() {
        return this.object;
    }

    public void setObject(IPCObject<T> object) {
        this.object = object;
    }

    public boolean isExecutionFinished() {
        return this.executionFinished;
    }

    public boolean waitForExecutionFinished() {
        return this.waitForExecutionFinished(60000L);
    }

    public boolean waitForExecutionFinished(long timeout) {
        long executionTimeout = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < executionTimeout && !this.executionFinished) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                LoggerFactory.getLogger(this.getClass()).error(e.getMessage(), (Throwable)e);
            }
        }
        return this.executionFinished;
    }

    public String toString() {
        return "RemoteExecutionContainer [executionID=" + this.executionID + ", object=" + this.object + ", executionFinished=" + this.executionFinished + "]";
    }

    @Override
    public void socketClosed(IPCSocketTransceiver source) {
        this.executionFinished = true;
        source.unregisterObjectListener(this);
    }

    @Override
    public void adoptValues(RemoteExecutionContainer<T> object) {
        if (object != null) {
            this.executionID = object.executionID;
            this.executionFinished = object.executionFinished;
            try {
                this.object.adoptValues(object.getObject());
            }
            catch (ClassCastException e) {
                LoggerFactory.getLogger(this.getClass()).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void objectRecceived(IPCSocketTransceiver source, RemoteExecutionContainer<?> object) {
        if (object.getExecutionID().equals(this.executionID)) {
            this.adoptValues(object);
            this.executionFinished = true;
            source.unregisterObjectListener(this);
        }
    }
}

