/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.modules.ipc;

import bsc.sdk.kernel.AApplicationKernel;
import bsc.sdk.kernel.bus.messages.kernel.ipc.RemoteExecutionRequest;
import bsc.sdk.kernel.bus.messages.kernel.ipc.StartIpcService;
import bsc.sdk.kernel.bus.messages.kernel.ipc.StopIpcService;
import bsc.sdk.kernel.bus.messages.module.idpool.RequestNewIdPool;
import bsc.sdk.kernel.executors.DynamicScheduledCachedThreadPoolExecutor;
import bsc.sdk.kernel.modules.IKernelModule;
import bsc.sdk.kernel.modules.idpool.IdPool;
import bsc.sdk.kernel.modules.idpool.IdPoolManager;
import bsc.sdk.kernel.modules.idpool.IdPoolSettings;
import bsc.sdk.kernel.modules.ipc.AIPCSocketServer;
import bsc.sdk.kernel.modules.ipc.IPCObject;
import bsc.sdk.kernel.modules.ipc.IPCSocketTransceiver;
import bsc.sdk.kernel.modules.ipc.RemoteExecutionContainer;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import net.engio.mbassy.bus.publication.SyncAsyncPostCommand;
import net.engio.mbassy.listener.Handler;

@IKernelModule.ModuleSettings(supportedKernels={AApplicationKernel.class}, dependencies={IdPoolManager.class})
public class IPCServer
extends AApplicationKernel.KernelModule {
    protected SocketServer server = null;

    public IPCServer(AApplicationKernel kernel) {
        super(kernel);
        this.createMessageBus(IPCObject.class, ((Object)((Object)this)).getClass().getName());
        this.start(null);
    }

    public void unload() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    @Handler
    protected void remoteExecution(RemoteExecutionRequest message) {
        this.logger.trace(RemoteExecutionRequest.class.getSimpleName() + "(" + message.getObject().getClass().getSimpleName() + ") will be executed " + (message.isWaitForRemoteExecution() ? "synchron" : "asynchron"));
        this.server.sendToAllClients(message.getObject(), message.isWaitForRemoteExecution());
    }

    @Handler
    protected void stop(StopIpcService message) {
        this.server.shutdown();
        this.server = null;
    }

    @Handler
    protected void start(StartIpcService message) {
        this.server = new SocketServer();
        this.backgroundExecute(this.server);
    }

    protected int getServicePort() {
        return 20000;
    }

    protected InetAddress getServiceAddress() {
        return InetAddress.getLoopbackAddress();
    }

    protected String getServiceName() {
        return null;
    }

    public void init() {
    }

    protected class SocketServer
    extends AIPCSocketServer {
        protected IdPool idPool;

        protected SocketServer() {
            super(IPCServer.this.getServiceAddress(), IPCServer.this.getServicePort(), IPCServer.this.getServiceName());
            this.idPool = null;
            RequestNewIdPool request = new RequestNewIdPool(new IdPoolSettings(this.getClass().getName(), IdPool.GENERATOR_TYPE.RANDOM, 12));
            IPCServer.this.postKernelMessage(request).now();
            if (request.getNewIdPool() == null) {
                this.logger.warn("Failed to get id pool from manager! Use fallback and create unmanaged pool.");
            }
            this.idPool = request.getNewIdPool() != null ? request.getNewIdPool() : new IdPool(request.getSettings());
        }

        @Override
        public void objectRecceived(final IPCSocketTransceiver source, final RemoteExecutionContainer<?> object) {
            if (object.isExecutionFinished()) {
                this.logger.trace("Remote execution result recceived for execution: " + object.getExecutionID());
            } else {
                this.logger.trace("Remote execution " + object.getExecutionID() + ": " + object.getObject().getClass().getName());
                IPCServer.this.backgroundExecute(new Runnable(){

                    @Override
                    public void run() {
                        SyncAsyncPostCommand post = IPCServer.this.postMessage(IPCObject.class, object.getObject());
                        if (post != null) {
                            post.now();
                        }
                        object.executionFinished = true;
                        SocketServer.this.logger.trace("Remote execution " + object.getExecutionID() + " finished, sending result");
                        source.sendExecutionResult(object);
                    }
                });
            }
        }

        @Override
        protected DynamicScheduledCachedThreadPoolExecutor.ScheduledTask startTask(Runnable runnable, long executionDelay) {
            return IPCServer.this.backgroundScheduleAtFixedDelay(runnable, 1000L, executionDelay, TimeUnit.MILLISECONDS);
        }

        @Override
        protected IdPool getIdPool() {
            if (this.idPool == null) {
                RequestNewIdPool request = new RequestNewIdPool(new IdPoolSettings(this.getClass().getName(), IdPool.GENERATOR_TYPE.RANDOM, 12));
                IPCServer.this.postKernelMessage(request).now();
                if (request.getNewIdPool() == null) {
                    this.logger.warn("Failed to get id pool from manager! Use fallback and create unmanaged pool.");
                    this.idPool = new IdPool(request.getSettings());
                } else {
                    this.idPool = request.getNewIdPool();
                }
            }
            return this.idPool;
        }
    }
}

