/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.modules.ipc;

import bsc.sdk.kernel.AApplicationKernel;
import bsc.sdk.kernel.bus.messages.kernel.ipc.RemoteExecutionRequest;
import bsc.sdk.kernel.bus.messages.kernel.ipc.StartIpcService;
import bsc.sdk.kernel.bus.messages.kernel.ipc.StopIpcService;
import bsc.sdk.kernel.bus.messages.module.idpool.RequestNewIdPool;
import bsc.sdk.kernel.executors.DynamicScheduledCachedThreadPoolExecutor;
import bsc.sdk.kernel.modules.IKernelModule;
import bsc.sdk.kernel.modules.idpool.IdPool;
import bsc.sdk.kernel.modules.idpool.IdPoolManager;
import bsc.sdk.kernel.modules.idpool.IdPoolSettings;
import bsc.sdk.kernel.modules.ipc.AIPCSocketClient;
import bsc.sdk.kernel.modules.ipc.IPCObject;
import bsc.sdk.kernel.modules.ipc.IPCSocketTransceiver;
import bsc.sdk.kernel.modules.ipc.RemoteExecutionContainer;
import bsc.sdk.kernel.modules.ipc.messages.IPCStatusMessage;
import java.util.concurrent.TimeUnit;
import net.engio.mbassy.bus.publication.SyncAsyncPostCommand;
import net.engio.mbassy.listener.Handler;

@IKernelModule.ModuleSettings(supportedKernels={AApplicationKernel.class}, dependencies={IdPoolManager.class})
public class IPCClient
extends AApplicationKernel.KernelModule {
    protected SocketClient client = null;
    protected boolean restartOnDisconnect = true;
    protected boolean reconnectInProgress = false;

    public IPCClient(AApplicationKernel kernel) {
        super(kernel);
        this.createMessageBus(IPCObject.class, ((Object)((Object)this)).getClass().getName());
        this.client = new SocketClient();
    }

    @Handler
    private void watchdog(IPCStatusMessage status) {
        if (this.restartOnDisconnect && AIPCSocketClient.IPC_STATE.DISCONNECTED.equals((Object)status.getState())) {
            this.logger.debug("Watchdog detected " + (Object)((Object)AIPCSocketClient.IPC_STATE.DISCONNECTED) + "! Forcing client restart!");
            this.restart();
        }
    }

    private void restart() {
        if (!this.reconnectInProgress) {
            this.logger.debug(((Object)((Object)this)).getClass().getSimpleName() + " will restart soon.");
            this.reconnectInProgress = true;
            this.stop(null);
            this.start(null);
            this.reconnectInProgress = false;
        }
    }

    public boolean isRestartOnDisconnect() {
        return this.restartOnDisconnect;
    }

    public void setRestartOnDisconnect(boolean restartOnDisconnect) {
        this.restartOnDisconnect = restartOnDisconnect;
    }

    @Handler
    protected void remoteExecution(RemoteExecutionRequest message) {
        this.logger.trace(RemoteExecutionRequest.class.getSimpleName() + "(" + message.getObject().getClass().getSimpleName() + ") will be executed " + (message.isWaitForRemoteExecution() ? "synchron" : "asynchron"));
        RemoteExecutionContainer<?> container = this.client.sendObject(message.getObject());
        if (container != null && message.isWaitForRemoteExecution()) {
            container.waitForExecutionFinished();
        }
    }

    public void unload() {
        this.setRestartOnDisconnect(false);
        this.client.shutdown();
    }

    protected int getServicePort() {
        return 20000;
    }

    protected String getServiceAddress() {
        return "127.0.0.1";
    }

    protected String getServiceName() {
        return null;
    }

    @Handler
    protected void stop(StopIpcService message) {
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    @Handler
    protected void start(StartIpcService message) {
        if (this.client != null) {
            this.client.start();
        }
    }

    public void init() {
    }

    protected class SocketClient
    extends AIPCSocketClient {
        private IdPool idPool;

        public SocketClient() {
            super(IPCClient.this.getServiceAddress(), IPCClient.this.getServicePort(), IPCClient.this.getServiceName());
            this.idPool = null;
            this.start();
        }

        @Override
        public void objectRecceived(IPCSocketTransceiver source, RemoteExecutionContainer<?> object) {
            if (object.isExecutionFinished()) {
                this.logger.trace("Remote execution result recceived for execution: " + object.getExecutionID());
            } else {
                this.logger.trace("Remote execution " + object.getExecutionID() + ": " + object.getObject().getClass().getName());
                SyncAsyncPostCommand post = IPCClient.this.postMessage(IPCObject.class, object.getObject());
                if (post != null) {
                    post.now();
                }
                object.executionFinished = true;
                this.logger.trace("Remote execution " + object.getExecutionID() + " finished, sending result");
                source.sendExecutionResult(object);
            }
        }

        @Override
        protected void postIPCStatus(AIPCSocketClient.IPC_STATE state) {
            IPCStatusMessage status = new IPCStatusMessage(state);
            SyncAsyncPostCommand returned = IPCClient.this.postKernelMessage(status);
            if (returned != null) {
                returned.now();
            }
        }

        @Override
        protected DynamicScheduledCachedThreadPoolExecutor.ScheduledTask startTask(Runnable runnable, long executionDelay) {
            return IPCClient.this.backgroundScheduleAtFixedDelay(runnable, executionDelay, executionDelay, TimeUnit.MILLISECONDS);
        }

        @Override
        protected IdPool getIdPool() {
            if (this.idPool == null) {
                RequestNewIdPool request = new RequestNewIdPool(new IdPoolSettings(this.getClass().getName(), IdPool.GENERATOR_TYPE.RANDOM, 12));
                IPCClient.this.postKernelMessage(request).now();
                if (request.getNewIdPool() == null) {
                    this.logger.warn("Failed to get id pool from manager! Use fallback and create unmanaged pool.");
                    this.idPool = new IdPool(request.getSettings());
                } else {
                    this.idPool = request.getNewIdPool();
                }
            }
            return this.idPool;
        }

        @Override
        protected void executeTask(Runnable runnable) {
            IPCClient.this.backgroundExecute(runnable);
        }
    }
}

