/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.modules.ipc;

import bsc.sdk.kernel.executors.DynamicScheduledCachedThreadPoolExecutor;
import bsc.sdk.kernel.modules.idpool.IdPool;
import bsc.sdk.kernel.modules.ipc.IPCObject;
import bsc.sdk.kernel.modules.ipc.IPCSocketTransceiver;
import bsc.sdk.kernel.modules.ipc.RemoteExecutionContainer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AIPCSocketServer
implements Runnable,
IPCSocketTransceiver.IPCSocketObjectListener {
    protected final Logger logger;
    protected final int port;
    protected ServerSocket socket = null;
    protected boolean running = true;
    protected Map<IPCSocketTransceiver, DynamicScheduledCachedThreadPoolExecutor.ScheduledTask> transceivers;
    protected final String name;
    protected final InetAddress listenInterface;

    protected AIPCSocketServer(int port) {
        this(null, port, null);
    }

    protected AIPCSocketServer(InetAddress listenInterface, int port, String name) {
        this.name = name == null ? new String(Hex.encodeHex((byte[])DigestUtils.md5((String)this.getClass().getName()))) : name;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.transceivers = new HashMap<IPCSocketTransceiver, DynamicScheduledCachedThreadPoolExecutor.ScheduledTask>();
        this.listenInterface = listenInterface != null ? listenInterface : InetAddress.getLoopbackAddress();
        this.port = port;
        this.logger.trace("IPCSocketServer created with name: " + this.name);
    }

    protected abstract DynamicScheduledCachedThreadPoolExecutor.ScheduledTask startTask(Runnable var1, long var2);

    protected abstract IdPool getIdPool();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int failedSocketCreations = 0;
        while (this.running) {
            ServerSocket serverSocket = this.getServerSocket();
            if (serverSocket != null) {
                try {
                    this.logger.trace("waiting for client...");
                    Socket newSocket = serverSocket.accept();
                    this.logger.trace("incomming connection...");
                    IPCSocketTransceiver transceiver = new IPCSocketTransceiver(this.getIdPool(), newSocket, this);
                    DynamicScheduledCachedThreadPoolExecutor.ScheduledTask task = this.startTask(transceiver, 50L);
                    if (task == null) continue;
                    Map<IPCSocketTransceiver, DynamicScheduledCachedThreadPoolExecutor.ScheduledTask> map = this.transceivers;
                    synchronized (map) {
                        this.transceivers.put(transceiver, task);
                        continue;
                    }
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    continue;
                }
            }
            ++failedSocketCreations;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            if (failedSocketCreations <= 10) continue;
            this.logger.error("Failed 10 times to create serverSocket. Server will shutdown now!");
            this.running = false;
        }
    }

    protected ServerSocket getServerSocket() {
        if (this.socket == null) {
            try {
                this.socket = new ServerSocket(this.port, 0, this.listenInterface);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.socket;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.running = false;
        HashSet<IPCSocketTransceiver> trans = new HashSet<IPCSocketTransceiver>();
        Map<IPCSocketTransceiver, DynamicScheduledCachedThreadPoolExecutor.ScheduledTask> map = this.transceivers;
        synchronized (map) {
            trans.addAll(this.transceivers.keySet());
        }
        Iterator itr = trans.iterator();
        while (itr.hasNext()) {
            ((IPCSocketTransceiver)itr.next()).shutdown();
            itr.remove();
        }
        if (!this.socket.isClosed()) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            this.logger.error("Dead socket detected!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void socketClosed(IPCSocketTransceiver source) {
        Map<IPCSocketTransceiver, DynamicScheduledCachedThreadPoolExecutor.ScheduledTask> map = this.transceivers;
        synchronized (map) {
            this.transceivers.get(source).cancel();
            this.transceivers.remove(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToAllClients(IPCObject<?> object, boolean waitForRemoteExecution) {
        Map<IPCSocketTransceiver, DynamicScheduledCachedThreadPoolExecutor.ScheduledTask> map = this.transceivers;
        synchronized (map) {
            for (IPCSocketTransceiver t : this.transceivers.keySet()) {
                RemoteExecutionContainer<?> container = t.sendObject(object);
                if (!waitForRemoteExecution || container.waitForExecutionFinished()) continue;
                this.logger.error("Error while remote execution " + container.getExecutionID() + " at transceiver: " + t.getId());
            }
        }
    }
}

