/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.modules.ipc;

import bsc.sdk.kernel.executors.DynamicScheduledCachedThreadPoolExecutor;
import bsc.sdk.kernel.modules.idpool.IdPool;
import bsc.sdk.kernel.modules.ipc.IPCObject;
import bsc.sdk.kernel.modules.ipc.IPCSocketTransceiver;
import bsc.sdk.kernel.modules.ipc.RemoteExecutionContainer;
import java.io.IOException;
import java.net.Socket;
import java.security.InvalidParameterException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AIPCSocketClient
implements IPCSocketTransceiver.IPCSocketObjectListener {
    private IPC_STATE state = IPC_STATE.DISCONNECTED;
    protected final Logger logger;
    protected final int port;
    protected Socket socket = null;
    protected IPCSocketTransceiver transceiver = null;
    protected final String name;
    protected final String address;
    protected DynamicScheduledCachedThreadPoolExecutor.ScheduledTask scheduledTask = null;
    protected boolean socketErrorState = false;
    protected long socketReconnectTimeout = TimeUnit.SECONDS.toMillis(15L);

    public AIPCSocketClient(int port) {
        this(null, port, null);
    }

    public AIPCSocketClient(String address, int port, String name) {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.name = name == null ? new String(Hex.encodeHex((byte[])DigestUtils.md5((String)this.getClass().getName()))) : name;
        this.port = port;
        this.address = address != null ? address : "127.0.0.1";
    }

    protected abstract DynamicScheduledCachedThreadPoolExecutor.ScheduledTask startTask(Runnable var1, long var2);

    protected abstract void executeTask(Runnable var1);

    protected abstract IdPool getIdPool();

    protected abstract void postIPCStatus(IPC_STATE var1);

    protected Socket getSocket() {
        block3: {
            if (this.socket == null) {
                try {
                    this.logger.info("IPC Client connecting to: " + this.address + " on port: " + this.port);
                    this.socket = new Socket(this.address, this.port);
                    this.changeSocketErrorState(false);
                }
                catch (IOException e) {
                    if (this.socketErrorState) break block3;
                    this.changeSocketErrorState(true);
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return this.socket;
    }

    protected synchronized void changeSocketErrorState(boolean errorOccoured) {
        if (errorOccoured != this.socketErrorState) {
            this.socketErrorState = errorOccoured;
            this.logger.info("IPC Socket Error State changes to " + this.socketErrorState);
        }
    }

    void start() {
        this.setState(IPC_STATE.PENDING);
        this.executeTask(new Runnable(){

            @Override
            public void run() {
                if (AIPCSocketClient.this.createAndStartTransceiver() == null) {
                    AIPCSocketClient.this.logger.debug("Could not connect to IPC server socket! Try reconnecting...");
                    if (AIPCSocketClient.this.reconnect() == null) {
                        AIPCSocketClient.this.logger.debug("Finally failed to connect to IPC server socket. Stop reconnecting!");
                        AIPCSocketClient.this.shutdown();
                    } else {
                        AIPCSocketClient.this.setState(IPC_STATE.CONNECTED);
                    }
                } else {
                    AIPCSocketClient.this.setState(IPC_STATE.CONNECTED);
                }
            }
        });
    }

    protected void setState(IPC_STATE state) {
        if (!this.state.equals((Object)state)) {
            this.state = state;
            this.postIPCStatus(this.state);
        }
    }

    protected boolean isState(IPC_STATE state) {
        return this.state.equals((Object)state);
    }

    protected IPCSocketTransceiver createAndStartTransceiver() {
        if (this.transceiver == null && this.isState(IPC_STATE.PENDING)) {
            try {
                Socket socket = this.getSocket();
                boolean socketExists = socket != null;
                this.logger.trace("ipc socket exists: " + socketExists);
                this.transceiver = new IPCSocketTransceiver(String.valueOf(this.port), this.getIdPool(), socket, this);
                this.scheduledTask = this.startTask(this.transceiver, 50L);
            }
            catch (InvalidParameterException e) {
                this.logger.trace("ipc service not available");
            }
        }
        return this.transceiver;
    }

    public boolean isRunning() {
        switch (this.state) {
            case DISCONNECTED: {
                return false;
            }
        }
        return true;
    }

    public boolean isReady() {
        return this.state.equals((Object)IPC_STATE.CONNECTED);
    }

    @Override
    public void socketClosed(IPCSocketTransceiver source) {
        if (this.isRunning() && this.transceiver != null && this.transceiver.equals(source)) {
            if (!this.socket.isClosed()) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            this.socket = null;
            this.transceiver = null;
            this.logger.error("IPC socket closed, try reconnect...");
            IPCSocketTransceiver transceiver = this.reconnect();
            if (transceiver == null) {
                this.logger.error("IPC socket reconnect failed within " + this.socketReconnectTimeout + " ms");
                this.shutdown();
            }
        }
    }

    protected IPCSocketTransceiver reconnect() {
        if (!this.isRunning()) {
            return null;
        }
        IPCSocketTransceiver transceiver = this.createAndStartTransceiver();
        long timeout = System.currentTimeMillis() + this.socketReconnectTimeout;
        long sleep = 0L;
        this.logger.trace("Reconnecting IPC socket...");
        long timeLeft = 0L;
        while ((timeLeft = timeout - System.currentTimeMillis()) > 0L && (transceiver = this.createAndStartTransceiver()) == null) {
            if (timeLeft <= (sleep += 1000L)) {
                sleep = timeLeft - 1L;
            }
            this.logger.trace("sleep " + sleep + " ms while waiting for reconnect...");
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return transceiver;
    }

    void shutdown() {
        if (this.transceiver != null) {
            this.transceiver.shutdown();
        }
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
            this.scheduledTask = null;
        }
        if (!this.state.equals((Object)IPC_STATE.DISCONNECTED)) {
            this.setState(IPC_STATE.DISCONNECTED);
        }
    }

    public <T> RemoteExecutionContainer<T> sendObject(IPCObject<T> object) {
        RemoteExecutionContainer<T> result = null;
        if (!this.isReady()) {
            long timeout = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
            while (!this.isReady() && System.currentTimeMillis() < timeout) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (this.transceiver != null && this.isReady()) {
            result = this.transceiver.sendObject(object);
        }
        return result;
    }

    public static enum IPC_STATE {
        DISCONNECTED,
        PENDING,
        CONNECTED;

    }
}

