/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.iroom.utils.range;

import de.bscgmbh.iroom.utils.range.IRangeLimitation;
import java.util.Objects;

public class NumberRange<T extends Number>
implements IRangeLimitation<T> {
    private static final long serialVersionUID = 8542227004137065485L;
    protected final T minInclusive;
    protected final T maxInclusive;
    protected final T stepping;

    public NumberRange(T minInclusive, T maxInclusive, T stepping) {
        this.minInclusive = (Number)Objects.requireNonNull(minInclusive, "minInclusive must not be null");
        this.maxInclusive = (Number)Objects.requireNonNull(maxInclusive, "maxInclusive must not be null");
        this.stepping = (Number)Objects.requireNonNull(stepping, "stepping must not be null");
    }

    public T getMinInclusive() {
        return this.minInclusive;
    }

    public T getMaxInclusive() {
        return this.maxInclusive;
    }

    public T getStepping() {
        return this.stepping;
    }

    @Override
    public Class<T> getValueClass() {
        return this.minInclusive.getClass();
    }

    @Override
    public boolean isValueInRange(T value) {
        if (value != null) {
            return ((Comparable)value).compareTo(this.minInclusive) >= 0 && ((Comparable)value).compareTo(this.maxInclusive) <= 0;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.maxInclusive == null ? 0 : this.maxInclusive.hashCode());
        result = 31 * result + (this.minInclusive == null ? 0 : this.minInclusive.hashCode());
        result = 31 * result + (this.stepping == null ? 0 : this.stepping.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberRange other = (NumberRange)obj;
        if (this.maxInclusive == null ? other.maxInclusive != null : !this.maxInclusive.equals(other.maxInclusive)) {
            return false;
        }
        if (this.minInclusive == null ? other.minInclusive != null : !this.minInclusive.equals(other.minInclusive)) {
            return false;
        }
        return !(this.stepping == null ? other.stepping != null : !this.stepping.equals(other.stepping));
    }

    public String toString() {
        return "NumberRange [minInclusive=" + this.minInclusive + ", maxInclusive=" + this.maxInclusive + ", stepping=" + this.stepping + "]";
    }
}

