/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.iroom.sdk.test;

import bsc.sdk.kernel.AApplicationKernel;
import de.bscgmbh.iroom.sdk.IRoomController;
import de.bscgmbh.iroom.sdk.msg.AIRoomConnectionObject;
import de.bscgmbh.iroom.sdk.msg.commands.IRoomSetRelayState;
import de.bscgmbh.iroom.sdk.msg.commands.IRoomSetVolume;
import de.bscgmbh.iroom.sdk.msg.controller.IRoomRegisterConnection;
import de.bscgmbh.iroom.sdk.msg.controller.IRoomUnRegisterConnection;
import de.bscgmbh.iroom.sdk.msg.device.IRoomDiscoverDeviceProperties;
import de.bscgmbh.iroom.sdk.msg.event.IRoomEventRelay;
import net.engio.mbassy.listener.Handler;

public class IRoomTestKernel
extends AApplicationKernel {
    public IRoomTestKernel() {
        super(new Class[]{IRoomController.class});
    }

    public String connect(String host, int port) {
        IRoomRegisterConnection msg = new IRoomRegisterConnection(host, port);
        this.postKernelMessage(msg).now();
        System.out.println("ConnectionID: " + msg.getConnectionID());
        return msg.getConnectionID();
    }

    public void disconnect(String address) {
        IRoomUnRegisterConnection msg = new IRoomUnRegisterConnection(address);
        this.postKernelMessage(msg).now();
    }

    public void discover(String connectionID) {
        IRoomDiscoverDeviceProperties msg = new IRoomDiscoverDeviceProperties(connectionID);
        this.postKernelMessage(msg).now();
        System.out.println(msg.getProperties());
    }

    @Handler
    protected void debugLog(AIRoomConnectionObject msg) {
        System.out.println(msg);
    }

    public void switchRelay(String connectionID, IRoomEventRelay.IROOM_RELAY_STATE state) {
        this.postKernelMessage(new IRoomSetRelayState(connectionID, state)).now();
    }

    public void setVolume(String connectionID, int volume) {
        this.postKernelMessage(new IRoomSetVolume(connectionID, volume)).now();
    }

    public static void main(String[] args) {
        IRoomTestKernel kernel = new IRoomTestKernel();
        String connectionID2 = kernel.connect("192.168.150.127", 13601);
        kernel.disconnect(connectionID2);
        connectionID2 = kernel.connect("192.168.150.129", 13601);
        kernel.disconnect(connectionID2);
        connectionID2 = kernel.connect("192.168.150.127", 13601);
    }

    static {
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "TRACE");
    }
}

