/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.iroom.sdk.msg;

import de.bscgmbh.iroom.api.data.types.StateValueEnum;
import de.bscgmbh.iroom.api.event.AbstractEvent;
import de.bscgmbh.iroom.api.extentedinfo.AbstractExtendedInfo;
import de.bscgmbh.iroom.api.extentedinfo.ExtendedInfoDockingState;
import de.bscgmbh.iroom.sdk.msg.event.IRoomEventButton;
import de.bscgmbh.iroom.sdk.msg.event.IRoomEventDigital;
import de.bscgmbh.iroom.sdk.msg.event.IRoomEventDock;
import de.bscgmbh.iroom.sdk.msg.event.IRoomEventIR;
import de.bscgmbh.iroom.sdk.msg.event.IRoomEventRelay;
import de.bscgmbh.iroom.sdk.msg.event.IRoomEventVolume;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRoomMessageFactory {
    private static Logger logger = LoggerFactory.getLogger(IRoomMessageFactory.class);

    public static IRoomEventVolume createEventVolume(String connectionID, int volume) {
        IRoomEventVolume result = null;
        if (connectionID != null) {
            if (volume < 0) {
                volume = 0;
            } else if (volume > 100) {
                volume = 100;
            }
            result = new IRoomEventVolume(connectionID, volume);
        }
        return result;
    }

    public static IRoomEventIR createEventIrMsgFromEvent(String connectionID, AbstractEvent<Integer> event) {
        IRoomEventIR result = null;
        int value = event.getCurrentValue();
        if (value == 0) {
            result = new IRoomEventIR(connectionID, IRoomEventIR.IROOM_IR_STATE.UNDETECTED);
        } else if (value == 1) {
            result = new IRoomEventIR(connectionID, IRoomEventIR.IROOM_IR_STATE.DETECTED);
        } else {
            logger.trace("Value out of range for IR event");
        }
        return result;
    }

    public static IRoomEventDock createEventDockMsgFromInfo(String connectionID, ExtendedInfoDockingState info) {
        IRoomEventDock result = null;
        if (((StateValueEnum)((Object)info.getCurrentValue())).equals((Object)StateValueEnum.DOCKED)) {
            result = new IRoomEventDock(connectionID, IRoomEventDock.IROOM_DOCKING_STATE.DOCKED);
        } else if (((StateValueEnum)((Object)info.getCurrentValue())).equals((Object)StateValueEnum.UNDOCKED)) {
            result = new IRoomEventDock(connectionID, IRoomEventDock.IROOM_DOCKING_STATE.UNDOCKED);
        }
        return result;
    }

    public static IRoomEventRelay createEventRelayMsgFromInfo(String connectionID, int channel, AbstractExtendedInfo<StateValueEnum> info) {
        IRoomEventRelay result = null;
        if (info.getCurrentValue().equals((Object)StateValueEnum.OPENEND)) {
            result = new IRoomEventRelay(connectionID, channel, IRoomEventRelay.IROOM_RELAY_STATE.OPEN);
        } else if (info.getCurrentValue().equals((Object)StateValueEnum.CLOSED)) {
            result = new IRoomEventRelay(connectionID, channel, IRoomEventRelay.IROOM_RELAY_STATE.CLOSED);
        }
        return result;
    }

    public static IRoomEventButton createEventButtonMsgFromEvent(String connectionID, AbstractEvent<StateValueEnum> event) {
        IRoomEventButton result = null;
        IRoomEventButton.IROOM_BUTTON_STATE state = IRoomMessageFactory.translateButtonState(event.getCurrentValue());
        if (state != null) {
            int channel = IRoomMessageFactory.extractChannelFromEnum((Enum)event.getIRoomCommandType());
            if (channel >= 0) {
                result = new IRoomEventButton(connectionID, state, channel);
            } else {
                logger.trace("Could not parse channel for button event");
            }
        } else {
            logger.trace("Invalid state for button event");
        }
        return result;
    }

    public static IRoomEventDigital createEventDigitalMsgFromEvent(String connectionID, AbstractEvent<StateValueEnum> event) {
        IRoomEventDigital result = null;
        IRoomEventDigital.IROOM_DIGITAL_STATE state = IRoomMessageFactory.translateDigitalState(event.getCurrentValue());
        if (state != null) {
            int channel = IRoomMessageFactory.extractChannelFromEnum((Enum)event.getIRoomCommandType());
            if (channel >= 0) {
                result = new IRoomEventDigital(connectionID, state, channel);
            } else {
                logger.trace("Could not parse channel for digital event");
            }
        } else {
            logger.trace("Invalid state for digital event");
        }
        return result;
    }

    public static IRoomEventButton.IROOM_BUTTON_STATE translateButtonState(StateValueEnum enumObj) {
        IRoomEventButton.IROOM_BUTTON_STATE result = null;
        if (enumObj != null) {
            if (enumObj.equals((Object)StateValueEnum.PUSHED)) {
                result = IRoomEventButton.IROOM_BUTTON_STATE.PRESSED;
            } else if (enumObj.equals((Object)StateValueEnum.RELEASED)) {
                result = IRoomEventButton.IROOM_BUTTON_STATE.RELEASED;
            }
        }
        return result;
    }

    public static IRoomEventDigital.IROOM_DIGITAL_STATE translateDigitalState(StateValueEnum enumObj) {
        IRoomEventDigital.IROOM_DIGITAL_STATE result = null;
        if (enumObj != null) {
            if (enumObj.equals((Object)StateValueEnum.CLOSED)) {
                result = IRoomEventDigital.IROOM_DIGITAL_STATE.CLOSED;
            } else if (enumObj.equals((Object)StateValueEnum.OPENEND)) {
                result = IRoomEventDigital.IROOM_DIGITAL_STATE.OPEN;
            }
        }
        return result;
    }

    public static int extractChannelFromEnum(Enum<?> enumObj) {
        String regex = "_";
        int result = -1;
        if (enumObj.name().contains(regex)) {
            String[] parts = enumObj.name().split(regex);
            try {
                result = Integer.parseInt(parts[1]);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }
}

