/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.iroom.sdk.controller;

import de.bscgmbh.iroom.api.IIRoomReceiveCommand;
import de.bscgmbh.iroom.api.data.types.EventEnum;
import de.bscgmbh.iroom.api.data.types.ExtendedInformationEnum;
import de.bscgmbh.iroom.api.event.AbstractEvent;
import de.bscgmbh.iroom.api.extentedinfo.AbstractExtendedInfo;
import de.bscgmbh.iroom.sdk.IRoomDeviceProperties;
import de.bscgmbh.iroom.sdk.controller.IRoomConnection;
import de.bscgmbh.iroom.sdk.controller.IUpdateHandler;
import de.bscgmbh.iroom.sdk.msg.IRoomMessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceDiscoveryUpdateHandler
implements IUpdateHandler {
    protected IRoomDeviceProperties properties = new IRoomDeviceProperties();
    protected Logger logger = LoggerFactory.getLogger(DeviceDiscoveryUpdateHandler.class);

    @Override
    public void update(IIRoomReceiveCommand iRoomReceiveCommand, IRoomConnection connection) {
        this.logger.trace(connection.getId() + " property recceived: " + iRoomReceiveCommand);
        if (iRoomReceiveCommand instanceof AbstractEvent) {
            AbstractEvent event = (AbstractEvent)iRoomReceiveCommand;
            try {
                switch ((EventEnum)event.getIRoomCommandType()) {
                    case BUTTON_0: {
                        this.properties.setHomeButton(true);
                        break;
                    }
                    case BUTTON_1: 
                    case BUTTON_2: 
                    case BUTTON_3: 
                    case BUTTON_4: 
                    case BUTTON_5: 
                    case BUTTON_6: 
                    case BUTTON_7: 
                    case BUTTON_8: {
                        this.applyButtonChannel(IRoomMessageFactory.extractChannelFromEnum((Enum)event.getIRoomCommandType()));
                        break;
                    }
                    case DIGITAL_0: {
                        this.properties.setDigitalChannel0(true);
                        break;
                    }
                    case DIGITAL_1: 
                    case DIGITAL_2: 
                    case DIGITAL_3: 
                    case DIGITAL_4: 
                    case DIGITAL_5: 
                    case DIGITAL_6: 
                    case DIGITAL_7: 
                    case DIGITAL_8: {
                        this.applyDigitalChannel(IRoomMessageFactory.extractChannelFromEnum((Enum)event.getIRoomCommandType()));
                        break;
                    }
                    case IREVENT: {
                        this.properties.setIr(true);
                    }
                }
            }
            catch (Exception e) {
                connection.logger.error(e.getMessage(), (Throwable)e);
            }
        } else if (iRoomReceiveCommand instanceof AbstractExtendedInfo) {
            AbstractExtendedInfo extInfo = (AbstractExtendedInfo)iRoomReceiveCommand;
            switch ((ExtendedInformationEnum)extInfo.getIRoomCommandType()) {
                case ALIVE: {
                    break;
                }
                case BEEP: {
                    this.properties.setBeep(true);
                    break;
                }
                case BOOT_FIRMWARE: {
                    break;
                }
                case CLACKDRIVE: {
                    this.properties.setClackDrive(true);
                    break;
                }
                case DOCKING_STATE: {
                    this.properties.setDockingState(true);
                    break;
                }
                case DOCK_FIRMWARE: {
                    break;
                }
                case IDOCK_TOUCHCODE: {
                    this.properties.setTouchCode(true);
                    break;
                }
                case IR_LEVEL: {
                    this.properties.setIrLevel(true);
                    break;
                }
                case LED_0: {
                    this.properties.setHomeButtonLed(true);
                    break;
                }
                case LED_1: 
                case LED_2: 
                case LED_3: 
                case LED_4: 
                case LED_5: 
                case LED_6: 
                case LED_7: 
                case LED_8: {
                    this.applyLedChannel(IRoomMessageFactory.extractChannelFromEnum((Enum)extInfo.getIRoomCommandType()));
                    break;
                }
                case PLUGDRIVE: {
                    this.properties.setPlugDrive(true);
                    break;
                }
                case RELAY_0: {
                    this.properties.setRelayChannel0(true);
                    break;
                }
                case TOUCH_BEZEL_FIRMWARE: {
                    break;
                }
                case VOLUME: {
                    this.properties.setVolume(true);
                    break;
                }
                case MODEL: {
                    System.out.println(extInfo.getCurrentValue());
                    break;
                }
                case DIGITAL_0: {
                    this.properties.setDigitalChannel0(true);
                    break;
                }
                case DIGITAL_1: 
                case DIGITAL_2: 
                case DIGITAL_3: 
                case DIGITAL_4: 
                case DIGITAL_5: 
                case DIGITAL_6: 
                case DIGITAL_7: 
                case DIGITAL_8: {
                    this.applyDigitalChannel(IRoomMessageFactory.extractChannelFromEnum((Enum)extInfo.getIRoomCommandType()));
                }
            }
        }
    }

    protected void applyButtonChannel(int channel) {
        if (this.properties.getButtonChannels() < channel) {
            this.properties.setButtonChannels(channel);
        }
    }

    protected void applyLedChannel(int channel) {
        if (this.properties.getLedChannels() < channel) {
            this.properties.setLedChannels(channel);
        }
    }

    protected void applyDigitalChannel(int channel) {
        if (this.properties.getDigitalChannels() < channel) {
            this.properties.setDigitalChannels(channel);
        }
    }

    public IRoomDeviceProperties getProperties() {
        return this.properties;
    }
}

