/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.iroom.sdk.controller;

import de.bscgmbh.iroom.api.IIRoomReceiveCommand;
import de.bscgmbh.iroom.api.data.types.EventEnum;
import de.bscgmbh.iroom.api.data.types.ExtendedInformationEnum;
import de.bscgmbh.iroom.api.event.AbstractEvent;
import de.bscgmbh.iroom.api.extentedinfo.AbstractExtendedInfo;
import de.bscgmbh.iroom.api.extentedinfo.ExtendedInfoDockingState;
import de.bscgmbh.iroom.api.extentedinfo.ExtendedInfoVolume;
import de.bscgmbh.iroom.sdk.controller.IRoomConnection;
import de.bscgmbh.iroom.sdk.controller.IUpdateHandler;
import de.bscgmbh.iroom.sdk.msg.IRoomMessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUpdateHandler
implements IUpdateHandler {
    private static DefaultUpdateHandler instance = null;
    protected Logger logger = LoggerFactory.getLogger(DefaultUpdateHandler.class);

    @Override
    public void update(IIRoomReceiveCommand iRoomReceiveCommand, IRoomConnection connection) {
        this.logger.trace(connection.getId() + " update recceived: " + iRoomReceiveCommand);
        if (iRoomReceiveCommand instanceof AbstractEvent) {
            AbstractEvent event = (AbstractEvent)iRoomReceiveCommand;
            try {
                switch ((EventEnum)event.getIRoomCommandType()) {
                    case BUTTON_0: 
                    case BUTTON_1: 
                    case BUTTON_2: 
                    case BUTTON_3: 
                    case BUTTON_4: 
                    case BUTTON_5: 
                    case BUTTON_6: 
                    case BUTTON_7: 
                    case BUTTON_8: {
                        connection.postMsg(IRoomMessageFactory.createEventButtonMsgFromEvent(connection.getId(), event), false);
                        break;
                    }
                    case DIGITAL_0: 
                    case DIGITAL_1: 
                    case DIGITAL_2: 
                    case DIGITAL_3: 
                    case DIGITAL_4: 
                    case DIGITAL_5: 
                    case DIGITAL_6: 
                    case DIGITAL_7: 
                    case DIGITAL_8: {
                        connection.postMsg(IRoomMessageFactory.createEventDigitalMsgFromEvent(connection.getId(), event), false);
                        break;
                    }
                    case IREVENT: {
                        connection.postMsg(IRoomMessageFactory.createEventIrMsgFromEvent(connection.getId(), event), false);
                    }
                }
            }
            catch (Exception e) {
                connection.logger.error(e.getMessage(), (Throwable)e);
            }
        } else if (iRoomReceiveCommand instanceof AbstractExtendedInfo) {
            AbstractExtendedInfo extInfo = (AbstractExtendedInfo)iRoomReceiveCommand;
            switch ((ExtendedInformationEnum)extInfo.getIRoomCommandType()) {
                case ALIVE: {
                    break;
                }
                case BEEP: {
                    break;
                }
                case BOOT_FIRMWARE: {
                    break;
                }
                case CLACKDRIVE: {
                    break;
                }
                case DOCKING_STATE: {
                    connection.postMsg(IRoomMessageFactory.createEventDockMsgFromInfo(connection.getId(), (ExtendedInfoDockingState)extInfo), false);
                    break;
                }
                case DOCK_FIRMWARE: {
                    break;
                }
                case IDOCK_TOUCHCODE: {
                    break;
                }
                case IR_LEVEL: {
                    break;
                }
                case LED_0: {
                    break;
                }
                case LED_1: {
                    break;
                }
                case LED_2: {
                    break;
                }
                case LED_3: {
                    break;
                }
                case LED_4: {
                    break;
                }
                case LED_5: {
                    break;
                }
                case LED_6: {
                    break;
                }
                case LED_7: {
                    break;
                }
                case LED_8: {
                    break;
                }
                case PLUGDRIVE: {
                    break;
                }
                case RELAY_0: {
                    connection.postMsg(IRoomMessageFactory.createEventRelayMsgFromInfo(connection.getId(), 0, extInfo), false);
                    break;
                }
                case TOUCH_BEZEL_FIRMWARE: {
                    break;
                }
                case VOLUME: {
                    ExtendedInfoVolume info = (ExtendedInfoVolume)extInfo;
                    connection.postMsg(IRoomMessageFactory.createEventVolume(connection.getId(), (Integer)info.getCurrentValue()), false);
                    break;
                }
                case MODEL: {
                    break;
                }
            }
        }
    }

    public static DefaultUpdateHandler getInstance() {
        if (instance == null) {
            instance = new DefaultUpdateHandler();
        }
        return instance;
    }
}

