/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.iroom.api.factory;

import de.bscgmbh.iroom.api.data.parameter.IIRoomParameterVO;
import de.bscgmbh.iroom.api.data.types.RequestEnum;
import de.bscgmbh.iroom.api.request.AbstractRequest;
import de.bscgmbh.iroom.api.request.RequestAliveState;
import de.bscgmbh.iroom.api.request.RequestAll;
import de.bscgmbh.iroom.api.request.RequestBezelFirmware;
import de.bscgmbh.iroom.api.request.RequestBootFirmware;
import de.bscgmbh.iroom.api.request.RequestDockFirmware;
import de.bscgmbh.iroom.api.request.RequestReboot;
import de.bscgmbh.iroom.api.request.RequestVolume;

public class RequestFactory {
    public static AbstractRequest getRequest(String command, String parameter) {
        if (command == null) {
            return null;
        }
        RequestEnum requestEnum = RequestEnum.fromApiShortcutDescription(command);
        if (requestEnum == null) {
            return null;
        }
        return RequestFactory.getRequest(requestEnum);
    }

    public static AbstractRequest getRequest(RequestEnum requestEnum) {
        try {
            switch (requestEnum) {
                case INF_UPDATE: {
                    return new RequestAll();
                }
                case ALIVE: {
                    return new RequestAliveState();
                }
                case REBOOT: {
                    return new RequestReboot();
                }
                case DOCK_FIRMWARE: {
                    return new RequestDockFirmware();
                }
                case BOOT_FIRMWARE: {
                    return new RequestBootFirmware();
                }
                case BEZEL_FIRMWARE: {
                    return new RequestBezelFirmware();
                }
                case VOLUME: {
                    return new RequestVolume();
                }
            }
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static AbstractRequest getRequest(RequestEnum requestEnum, IIRoomParameterVO<?> iRoomParameterVO) {
        return RequestFactory.getRequest(requestEnum, null);
    }
}

