/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.iroom.api.data.types;

import java.util.Objects;

public enum StateValueEnum {
    STANDARD("standard"),
    OPEN("open"),
    CLOSE("close"),
    TOGGLE("toggle"),
    UP("up"),
    DOWN("down"),
    MUTE("mute"),
    UNMUTE("unmute"),
    MUTE_TOGGLE("mute_toggle"),
    PLAY("play"),
    PAUSE("pause"),
    NEXT("next"),
    PREVIOUS("prev"),
    PLAY_PAUSE("playpause"),
    PUSHED("pushed"),
    RELEASED("released"),
    CLOSED("closed"),
    OPENEND("opened"),
    DOCKING("docking"),
    UNDOCKING("undocking"),
    DOCKED("docked"),
    UNDOCKED("undocked"),
    CLOSING("closing"),
    OPENING("opening"),
    IBEZEL("ibezel"),
    TOUCHCODE("touchcode");

    private final String apiShortcutDescription;

    private StateValueEnum(String apiShortcutDescription) {
        this.apiShortcutDescription = apiShortcutDescription;
    }

    public String getApiShortcutDescription() {
        return this.apiShortcutDescription;
    }

    public static StateValueEnum fromApiShortcutDescription(String apiShortcutDescription) {
        Objects.requireNonNull(apiShortcutDescription, "apiShortcutDescription must not be null");
        for (StateValueEnum stateEnum : StateValueEnum.values()) {
            if (!stateEnum.getApiShortcutDescription().equals(apiShortcutDescription)) continue;
            return stateEnum;
        }
        return null;
    }
}

