/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.iroom.api.data.types;

import de.bscgmbh.iroom.api.data.DefaultIRoomParameterVOCreator;
import de.bscgmbh.iroom.api.data.IIRoomComandType;
import de.bscgmbh.iroom.api.data.parameter.IIRoomParameterVO;
import de.bscgmbh.iroom.api.data.parameter.IRoomParameterInteger;
import de.bscgmbh.iroom.api.data.parameter.IRoomParameterNull;
import de.bscgmbh.iroom.api.data.types.StateValueEnum;
import de.bscgmbh.iroom.utils.range.CurrentValueNumber;
import de.bscgmbh.iroom.utils.range.IntegerRange;
import java.util.Objects;

public enum RequestEnum implements IIRoomComandType
{
    INF_UPDATE("infupdate", DefaultIRoomParameterVOCreator.createIRoomParameterStateValueEnum(StateValueEnum.STANDARD, StateValueEnum.STANDARD)),
    ALIVE("alive", new IRoomParameterInteger(new CurrentValueNumber<Integer>(Integer.valueOf(1), new IntegerRange(1)))),
    REBOOT("reboot", new IRoomParameterNull()),
    DOCK_FIRMWARE("dock_fw", new IRoomParameterInteger(new CurrentValueNumber<Integer>(Integer.valueOf(1), new IntegerRange(1)))),
    BOOT_FIRMWARE("boot_fw", new IRoomParameterInteger(new CurrentValueNumber<Integer>(Integer.valueOf(1), new IntegerRange(1)))),
    BEZEL_FIRMWARE("bezel_fw", new IRoomParameterInteger(new CurrentValueNumber<Integer>(Integer.valueOf(1), new IntegerRange(1)))),
    VOLUME("volume", new IRoomParameterNull());

    private final String apiShortcutDescription;
    private final IIRoomParameterVO iRoomParameterVO;

    private RequestEnum(String apiShortcutDescription, IIRoomParameterVO iRoomParameterVO) {
        this.apiShortcutDescription = apiShortcutDescription;
        this.iRoomParameterVO = iRoomParameterVO;
    }

    @Override
    public String getApiShortcutDescription() {
        return this.apiShortcutDescription;
    }

    public static RequestEnum fromApiShortcutDescription(String apiShortcutDescription) {
        Objects.requireNonNull(apiShortcutDescription, "apiShortcutDescription must not be null");
        for (RequestEnum requestCommandEnum : RequestEnum.values()) {
            if (!requestCommandEnum.getApiShortcutDescription().equals(apiShortcutDescription)) continue;
            return requestCommandEnum;
        }
        return null;
    }

    @Override
    public IIRoomParameterVO<?> getIIRoomParameterVO() {
        return this.iRoomParameterVO;
    }
}

