/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.iroom.api.data.types;

import de.bscgmbh.iroom.api.data.DefaultIRoomParameterVOCreator;
import de.bscgmbh.iroom.api.data.IIRoomComandType;
import de.bscgmbh.iroom.api.data.parameter.IIRoomParameterVO;
import de.bscgmbh.iroom.api.data.parameter.IRoomParameterDouble;
import de.bscgmbh.iroom.api.data.parameter.IRoomParameterStateValueEnum;
import de.bscgmbh.iroom.api.data.types.StateValueEnum;
import de.bscgmbh.iroom.utils.range.CurrentValueEnum;
import de.bscgmbh.iroom.utils.range.CurrentValueNumber;
import de.bscgmbh.iroom.utils.range.DoubleRange;
import de.bscgmbh.iroom.utils.range.EnumRange;
import de.bscgmbh.iroom.utils.range.UnitEnum;
import java.util.EnumSet;
import java.util.Objects;

public enum CommandEnum implements IIRoomComandType
{
    BEEP("beep", new IRoomParameterDouble((CurrentValueNumber)new CurrentValueNumber<Double>(Double.valueOf(1.0), new DoubleRange(0.1, 10.0, 0.1), UnitEnum.SECONDS)){
        private static final long serialVersionUID = 8845621007077482400L;

        @Override
        public String getParameterValue() {
            return Long.toString(Math.round((Double)this.valueWithRange.getCurrentValue() * 10.0));
        }
    }),
    DOCK("idock", new IRoomParameterStateValueEnum(new CurrentValueEnum<StateValueEnum>(StateValueEnum.CLOSE, new EnumRange<StateValueEnum>(EnumSet.of(StateValueEnum.CLOSE, StateValueEnum.OPEN, StateValueEnum.TOGGLE))))),
    LED_0("led0", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 100, UnitEnum.PERCENT)),
    LED_1("led1", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 100, UnitEnum.PERCENT)),
    LED_2("led2", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 100, UnitEnum.PERCENT)),
    LED_3("led3", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 100, UnitEnum.PERCENT)),
    LED_4("led4", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 100, UnitEnum.PERCENT)),
    LED_5("led5", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 100, UnitEnum.PERCENT)),
    LED_6("led6", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 100, UnitEnum.PERCENT)),
    LED_7("led7", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 100, UnitEnum.PERCENT)),
    LED_8("led8", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 100, UnitEnum.PERCENT)),
    RELAY_0("relay0", new IRoomParameterStateValueEnum(new CurrentValueEnum<StateValueEnum>(StateValueEnum.CLOSE, new EnumRange<StateValueEnum>(EnumSet.of(StateValueEnum.CLOSE, StateValueEnum.OPEN, StateValueEnum.TOGGLE))))),
    VOLUME_CONTROL("volume", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 100, UnitEnum.PERCENT)),
    MUSIC_CONTROL("music", new IRoomParameterStateValueEnum(new CurrentValueEnum<StateValueEnum>(StateValueEnum.PAUSE, new EnumRange<StateValueEnum>(EnumSet.of(StateValueEnum.PLAY, StateValueEnum.PAUSE, StateValueEnum.NEXT, StateValueEnum.PREVIOUS, StateValueEnum.PLAY_PAUSE)))));

    private final String apiShortcutDescription;
    private final IIRoomParameterVO iRoomParameterVO;

    private CommandEnum(String apiShortcutDescription, IIRoomParameterVO iRoomParameterVO) {
        this.apiShortcutDescription = apiShortcutDescription;
        this.iRoomParameterVO = iRoomParameterVO;
    }

    @Override
    public String getApiShortcutDescription() {
        return this.apiShortcutDescription;
    }

    public static CommandEnum fromApiShortcutDescription(String apiShortcutDescription) {
        Objects.requireNonNull(apiShortcutDescription, "apiShortcutDescription must not be null");
        for (CommandEnum requestCommandEnum : CommandEnum.values()) {
            if (!requestCommandEnum.getApiShortcutDescription().equals(apiShortcutDescription)) continue;
            return requestCommandEnum;
        }
        return null;
    }

    @Override
    public IIRoomParameterVO<?> getIIRoomParameterVO() {
        return this.iRoomParameterVO;
    }
}

