/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.common.resources.tools;

import com.wibu.common.SetUtilities;
import com.wibu.common.resources.BaseError;
import com.wibu.common.resources.BaseErrorInitializer;
import com.wibu.common.resources.GenericError;
import com.wibu.common.resources.GenericErrorGenerator;
import com.wibu.common.resources.LocalizedError;
import com.wibu.common.resources.LocalizedException;
import com.wibu.common.resources.Replacement;
import com.wibu.common.resources.Splitter;
import java.util.Date;
import java.util.Set;
import javax.annotation.Generated;

public class ErrorFactoryGenerator {
    public static void main(String[] stringArray) {
        ErrorFactoryGenerator.generateException2(GenericError.class);
    }

    public static <T extends Enum<?>> void generateException2(Class<T> clazz) {
        System.out.println("" + clazz.getPackage() + ";");
        System.out.println("import " + LocalizedError.class.getCanonicalName() + ";");
        System.out.println("import " + Replacement.class.getCanonicalName() + ";");
        System.out.println("import " + Generated.class.getCanonicalName() + ";");
        System.out.println("");
        System.out.println("/*Generated class " + new Date() + "*/");
        System.out.println("@Generated(value={\"" + ErrorFactoryGenerator.class.getCanonicalName() + "\"}, date=\"" + new Date().toString() + "\")");
        System.out.println("public class " + clazz.getSimpleName() + "Generator {");
        Splitter splitter = new Splitter('%');
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            System.out.print("\tpublic static " + LocalizedError.class.getSimpleName() + " " + enum_.name() + "(");
            ErrorFactoryGenerator.compareRequiredAndActualParameters(((BaseErrorInitializer)((Object)enum_)).toError());
            Set<String> set = splitter.getUsedParameters(((BaseErrorInitializer)((Object)enum_)).toError().getDefaultLocalization());
            boolean bl = true;
            for (String string : set) {
                if (bl) {
                    bl = false;
                } else {
                    System.out.print(", ");
                }
                System.out.print("String _" + string);
            }
            System.out.println(") {");
            System.out.print("\t\treturn new " + LocalizedError.class.getSimpleName() + "(" + clazz.getSimpleName() + "." + enum_.name());
            for (String string : set) {
                System.out.print(", ");
                System.out.print("new Replacement(\"" + string + "\"" + ", _" + string + ")");
            }
            System.out.println("); }");
        }
        System.out.println("}");
    }

    private static void compareRequiredAndActualParameters(BaseError baseError) {
        Splitter splitter = new Splitter('%');
        Set<String> set = splitter.getUsedParameters(baseError.getDefaultLocalization());
        Set<String> set2 = SetUtilities.symmetricDifference(set, baseError.getRequiredParameters());
        if (!set2.isEmpty()) {
            throw new LocalizedException(GenericErrorGenerator.ParametersNotMatching("" + baseError.getCode(), set2.toString()));
        }
    }
}

