/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.common.external;

import com.wibu.common.external.ExternalProcessResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

public class ExternalProcessRunner {
    private File workingDirectory;
    private String[] commands;
    private FutureTask<Integer> worker = null;
    private FutureTask<StringBuffer> streamCatcherIn = null;
    private boolean logStreams = true;
    private Charset outputFormat;
    private PrintStream logOutputTo = null;
    private StringBuffer loggedOutput = new StringBuffer();
    private PrintOutputMode printOutputMode = PrintOutputMode.Never;

    public ExternalProcessRunner(String[] stringArray) {
        this(stringArray, null);
    }

    public ExternalProcessRunner(String[] stringArray, File file) {
        this(stringArray, file, null, null, PrintOutputMode.Never);
    }

    public ExternalProcessRunner(String[] stringArray, File file, Charset charset, PrintStream printStream, PrintOutputMode printOutputMode) {
        this.commands = stringArray;
        this.workingDirectory = file;
        this.outputFormat = charset;
        this.logOutputTo = printStream;
        this.printOutputMode = printOutputMode;
    }

    public ExternalProcessResult run() {
        return this.runSynchronously(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalProcessResult runSynchronously(long l) {
        Object object;
        Process process;
        ProcessBuilder processBuilder = new ProcessBuilder(this.commands);
        if (this.workingDirectory != null) {
            processBuilder.directory(this.workingDirectory);
        }
        processBuilder.redirectErrorStream(true);
        try {
            process = processBuilder.start();
        }
        catch (IOException iOException) {
            return new ExternalProcessResult(iOException);
        }
        long l2 = System.currentTimeMillis();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        if (this.logStreams) {
            object = new StreamCatcher(this, process.getInputStream(), this.outputFormat);
            this.streamCatcherIn = new FutureTask<StringBuffer>((Callable<StringBuffer>)object);
            executorService.execute(this.streamCatcherIn);
        }
        this.worker = new FutureTask<Integer>(new Worker(process));
        executorService.execute(this.worker);
        try {
            object = null;
            object = l > 0L ? this.worker.get(l, TimeUnit.MILLISECONDS) : this.worker.get();
            long l3 = System.currentTimeMillis() - l2;
            if (object != null) {
                ExternalProcessResult externalProcessResult = new ExternalProcessResult((Integer)object, l3, this.streamCatcherIn.get());
                return externalProcessResult;
            }
            this.worker.cancel(true);
            if (this.streamCatcherIn != null) {
                this.streamCatcherIn.cancel(true);
            }
            ExternalProcessResult externalProcessResult = new ExternalProcessResult(null, l3, this.streamCatcherIn.get());
            return externalProcessResult;
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException.getMessage());
            this.worker.cancel(true);
            if (this.streamCatcherIn != null) {
                this.streamCatcherIn.cancel(true);
            }
            if (this.logOutputTo != null && this.printOutputMode == PrintOutputMode.Always) {
                this.logOutputTo.println(this.loggedOutput.toString());
            }
            ExternalProcessResult externalProcessResult = new ExternalProcessResult(interruptedException, this.loggedOutput);
            return externalProcessResult;
        }
        catch (Throwable throwable) {
            if (this.logOutputTo != null && this.printOutputMode == PrintOutputMode.Always) {
                this.logOutputTo.println(this.loggedOutput.toString());
            }
            ExternalProcessResult externalProcessResult = new ExternalProcessResult(throwable, this.loggedOutput);
            return externalProcessResult;
        }
        finally {
            process.destroy();
            executorService.shutdown();
        }
    }

    public void abort() {
        ExternalProcessRunner.cancel(this.worker);
        ExternalProcessRunner.cancel(this.streamCatcherIn);
    }

    private static <T> void cancel(FutureTask<T> futureTask) {
        if (futureTask != null && !futureTask.isDone()) {
            futureTask.cancel(true);
        }
    }

    public static PrintStream access$100(ExternalProcessRunner externalProcessRunner) {
        return externalProcessRunner.logOutputTo;
    }

    public static PrintOutputMode access$200(ExternalProcessRunner externalProcessRunner) {
        return externalProcessRunner.printOutputMode;
    }

    public static StringBuffer access$300(ExternalProcessRunner externalProcessRunner) {
        return externalProcessRunner.loggedOutput;
    }

    private static class Worker
    implements Callable<Integer> {
        private final Process process;

        private Worker(Process process) {
            this.process = process;
        }

        @Override
        public Integer call() throws Exception {
            try {
                return this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
    }

    private class StreamCatcher
    implements Callable<StringBuffer> {
        private InputStreamReader isr;
        public ExternalProcessRunner this$0;

        StreamCatcher(ExternalProcessRunner externalProcessRunner, InputStream inputStream, Charset charset) {
            this.this$0 = externalProcessRunner;
            this.isr = charset != null ? new InputStreamReader(inputStream, charset) : new InputStreamReader(inputStream);
        }

        @Override
        public StringBuffer call() throws Exception {
            try {
                BufferedReader bufferedReader = new BufferedReader(this.isr);
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    if (ExternalProcessRunner.access$100(this.this$0) != null && ExternalProcessRunner.access$200(this.this$0) == PrintOutputMode.Always) {
                        ExternalProcessRunner.access$100(this.this$0).println(string);
                    }
                    ExternalProcessRunner.access$300(this.this$0).append(string + System.getProperty("line.separator"));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return ExternalProcessRunner.access$300(this.this$0);
        }
    }

    public static enum PrintOutputMode {
        Never,
        Always,
        OnErrorDelayed;

    }
}

