/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.common.commandline;

import com.wibu.common.commandline.NoParserFoundException;
import com.wibu.common.commandline.ParseAction;
import com.wibu.common.commandline.ParsingException;
import com.wibu.common.commandline.PrefixTree;
import java.util.NavigableMap;
import java.util.TreeMap;

public class ParseActionTree
implements ParseAction {
    private boolean ignoreCase = true;
    private NavigableMap<String, ParseAction> prefixToParseAction = new TreeMap<String, ParseAction>();
    private PrefixTree prefixTree = new PrefixTree();

    @Override
    public void evaluate(String string) throws ParsingException {
        if (string.trim().isEmpty()) {
            throw new ParsingException("Empty string given");
        }
        String string2 = this.prefixTree.getLongestPrefix(string);
        if (string2 != null) {
            ParseAction parseAction = (ParseAction)this.prefixToParseAction.get(string2);
            if (parseAction != null) {
                String string3 = string.substring(string2.length());
                try {
                    parseAction.evaluate(string3);
                }
                catch (ParsingException parsingException) {
                    throw new ParsingException(parsingException);
                }
            }
        } else {
            throw new NoParserFoundException("No parser found for " + string);
        }
    }

    void addParseAction(String string, ParseAction parseAction) {
        if (string == null) {
            throw new NullPointerException("Parameter is null");
        }
        if (!this.prefixToParseAction.containsKey(string)) {
            this.prefixToParseAction.put(string, parseAction);
            this.prefixTree.add(string);
        }
    }
}

