/*
 * Decompiled with CFR 0.152.
 */
package com.wibu;

import com.wibu.ProgressWindow;
import com.wibu.xpm.Logger;
import com.wibu.xpm.Version;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class UpdateSignature
implements Runnable {
    final int major = 9;
    final int minor = 0;
    final int build = 1220;
    final int release = 500;
    final int year = 2013;
    final int month = 10;
    final int day = 28;
    protected Version mVersion = new Version(9, 0, 1220, 500, 2013, 10, 28);
    protected static String domain = "http://www.wibu.com/";
    protected static String baseUrl = domain + "files/java/";
    protected final String kwindowtitle = "WIBU-SYSTEMS Software Protection";
    private boolean fAutoDetextProxy = true;
    private boolean fRunningAsApp = false;
    private Proxy proxy = null;
    protected byte[] signature = null;
    protected String filnameSignature = null;
    protected Progress progress = null;

    public UpdateSignature() {
        String string = System.getProperty("com.wibu.xpm.signature.url");
        if (null != string) {
            domain = string;
            baseUrl = string;
        }
    }

    protected boolean agreeDownload() {
        Object[] objectArray = new Object[]{"Download", "Abort"};
        int n = JOptionPane.showOptionDialog(null, "Unknown Java Virtual Machine found!\nDo you want to download and install new signatures?", "WIBU-SYSTEMS Software Protection", 0, 0, null, objectArray, objectArray[0]);
        return 0 == n;
    }

    private boolean saveInClassPath() {
        String string = System.getProperty("java.home");
        File file = new File(string + File.separator + "lib" + File.separator + "ext" + File.separator + this.filnameSignature);
        this.progress.update(90, " in global classpath ... ");
        try {
            UpdateSignature.writeToFile(file, this.signature);
        }
        catch (IOException iOException) {
            this.progress.update(91, "failed!\n");
            try {
                this.progress.update(95, "Saving data in user directory ... ");
                file = new File(System.getProperty("user.home") + File.separator + this.filnameSignature);
                UpdateSignature.writeToFile(file, this.signature);
            }
            catch (IOException iOException2) {
                this.progress.update(-1, "failed!");
                return false;
            }
        }
        this.progress.update(100, "done.");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(File file, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    private void log(String string) {
        if (this.fRunningAsApp) {
            System.out.println(string);
        } else {
            Logger.getLogger(false).info(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadSignature() {
        try {
            HttpURLConnection httpURLConnection;
            this.filnameSignature = "WibuVm.jar";
            URL uRL = new URL(baseUrl + this.filnameSignature);
            this.progress.start("Connecting to " + domain + "...");
            Proxy proxy = this.getProxy();
            if (null == proxy) {
                this.log("No proxy required.");
                httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
            } else {
                this.log("Using proxy '" + proxy.toString() + "'.");
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
            }
            httpURLConnection.connect();
            this.progress.update(10, "done.\n");
            this.progress.update(15, "Downloading data ...");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = httpURLConnection.getInputStream();
            int n = 0;
            try {
                byte[] byArray = new byte[1024];
                int n2 = 0;
                int n3 = 16;
                while (-1 != (n2 = inputStream.read(byArray))) {
                    n += n2;
                    byteArrayOutputStream.write(byArray, 0, n2);
                    if (n3 >= 70) continue;
                    this.progress.update(n3++, ".");
                }
            }
            finally {
                inputStream.close();
            }
            this.signature = byteArrayOutputStream.toByteArray();
            this.progress.update(70, " (" + n / 1024 + " kB) done.\n");
        }
        catch (Exception exception) {
            this.progress.update(-1, "FAILED:\n" + exception.getMessage());
            return false;
        }
        return true;
    }

    protected Proxy getProxy() {
        if (!this.fAutoDetextProxy) {
            return this.proxy;
        }
        String string = "java.net.useSystemProxies";
        System.setProperty(string, "true");
        try {
            List<Proxy> list = ProxySelector.getDefault().select(new URI(baseUrl));
            if (!list.isEmpty()) {
                this.proxy = list.get(0);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return this.proxy;
    }

    public static void main(String[] stringArray) {
        UpdateSignature updateSignature = new UpdateSignature();
        updateSignature.fRunningAsApp = true;
        System.out.println();
        System.out.println("WIBU Executable Software Protection, Version " + updateSignature.mVersion.getVersion());
        System.out.println("VM Signature Update," + updateSignature.mVersion.getBuild() + " of " + updateSignature.mVersion.getDate());
        System.out.println(updateSignature.mVersion.getCopyRight());
        switch (stringArray.length) {
            case 0: {
                break;
            }
            case 1: {
                if (0 == stringArray[0].compareToIgnoreCase("-noproxy")) {
                    updateSignature.fAutoDetextProxy = false;
                    break;
                }
                updateSignature.showUsage();
                break;
            }
            case 2: {
                if (0 == stringArray[0].compareToIgnoreCase("-proxy")) {
                    String[] stringArray2 = stringArray[1].split(":");
                    if (stringArray2.length != 2) {
                        updateSignature.showUsage();
                    }
                    String string = stringArray2[0];
                    int n = Integer.parseInt(stringArray2[1]);
                    updateSignature.fAutoDetextProxy = false;
                    updateSignature.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n));
                    break;
                }
                updateSignature.showUsage();
                break;
            }
            default: {
                updateSignature.showUsage();
            }
        }
        updateSignature.run();
        System.out.println("Done.");
    }

    private void showUsage() {
        System.out.println("Use: 'java com.wibu.UpdateSignature [-proxy ProxyHost:ProxyPort]|-noproxy]'.");
        System.exit(1);
    }

    @Override
    public void run() {
        try {
            if (!this.fRunningAsApp && !this.agreeDownload()) {
                System.exit(1);
            }
            this.progress = new Progress();
            if (!this.downloadSignature()) {
                JOptionPane.showMessageDialog(null, "Could not download information!", "WIBU-SYSTEMS Software Protection", 0);
                System.exit(1);
            }
            this.progress.update(80, "Saving data");
            if (!this.saveInClassPath()) {
                this.progress.done();
                System.exit(1);
            }
            this.progress.done();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class Progress {
        protected ProgressWindow progress;
        protected JFrame frame;

        private Progress() {
        }

        public void start(String string) {
            this.frame = new JFrame();
            this.frame.setTitle("WIBU-SYSTEMS Software Protection");
            this.frame.setLocationByPlatform(true);
            ProgressWindow progressWindow = this.progress = new ProgressWindow();
            progressWindow.setOpaque(true);
            this.frame.setContentPane(progressWindow);
            this.frame.pack();
            this.frame.setVisible(true);
            this.progress.start(string);
        }

        public void update(int n, String string) {
            if (null != this.progress) {
                this.progress.setProgress(n, string);
            }
        }

        public void done() {
            this.progress.setProgress(100, "");
            JOptionPane.showMessageDialog(null, "Download and installation succeeded.\nPlease restart the application.", "WIBU-SYSTEMS Software Protection", 1);
            System.exit(1);
        }
    }
}

