/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.tools.pdfcreator.attachment.appender;

import de.bscgmbh.tools.pdfcreator.attachment.IAttachment;
import de.bscgmbh.tools.pdfcreator.attachment.TextAttachment;
import de.bscgmbh.tools.pdfcreator.attachment.appender.IAttachmentAppender;
import de.bscgmbh.tools.pdfcreator.attachment.misc.RGBColor;
import de.bscgmbh.tools.pdfcreator.attachment.text.TextLine;
import java.io.IOException;
import java.util.Iterator;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextAttachmentAppender
implements IAttachmentAppender {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void appendAttachment(PDDocument document, IAttachment attachment) {
        if (attachment instanceof TextAttachment) {
            try {
                TextAttachmentAppender.appendTextAttachment(document, (TextAttachment)attachment);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void appendTextAttachment(PDDocument document, TextAttachment attachment) throws IOException {
        PDPageContentStream contentStream = TextAttachmentAppender.createNewPage(document, attachment);
        boolean bold = false;
        RGBColor color = attachment.getHeadLineTextColor();
        int elementCounter = 0;
        Iterator<TextLine> itr = attachment.getContent().iterator();
        while (itr.hasNext()) {
            if (elementCounter == 100) {
                contentStream.endText();
                contentStream.close();
                contentStream = TextAttachmentAppender.createNewPage(document, attachment);
                color = attachment.getHeadLineTextColor();
                bold = false;
                TextAttachmentAppender.applyFont(contentStream, bold);
                TextAttachmentAppender.applyColor(contentStream, color);
                elementCounter = 0;
            }
            TextAttachmentAppender.appendNewLine(contentStream, elementCounter == 0);
            ++elementCounter;
            TextLine line = itr.next();
            if (bold != line.isBold()) {
                bold = line.isBold();
                TextAttachmentAppender.applyFont(contentStream, bold);
            }
            if (!color.isSameColor(line.getColorOrDefault())) {
                color = line.getColorOrDefault();
                TextAttachmentAppender.applyColor(contentStream, color);
            }
            contentStream.showText(line.getText());
        }
        contentStream.endText();
        contentStream.close();
    }

    protected static PDPageContentStream createNewPage(PDDocument document, TextAttachment attachment) throws IOException {
        PDPage newPage = new PDPage(PDRectangle.A4);
        document.addPage(newPage);
        PDPageContentStream contentStream = new PDPageContentStream(document, newPage);
        contentStream.beginText();
        contentStream.newLineAtOffset(61.0f, 800.0f);
        contentStream.setFont((PDFont)PDType1Font.HELVETICA, 20.0f);
        contentStream.setNonStrokingColor(attachment.getHeadLineTextColor().getColor());
        contentStream.showText(attachment.getHeadlineText());
        contentStream.endText();
        contentStream.setStrokingColor(attachment.getHeadLineColor().getColor());
        contentStream.moveTo(60.0f, 795.0f);
        contentStream.lineTo(540.0f, 795.0f);
        contentStream.stroke();
        contentStream.beginText();
        contentStream.setLeading(7.5f);
        return contentStream;
    }

    protected static void applyFont(PDPageContentStream contentStream, boolean bold) throws IOException {
        if (contentStream == null) {
            return;
        }
        if (bold) {
            contentStream.setFont((PDFont)PDType1Font.HELVETICA_BOLD, 9.0f);
        } else {
            contentStream.setFont((PDFont)PDType1Font.HELVETICA, 7.0f);
        }
    }

    protected static void applyColor(PDPageContentStream contentStream, RGBColor color) throws IOException {
        if (contentStream == null || color == null) {
            return;
        }
        contentStream.setNonStrokingColor(color.getColor());
    }

    protected static void appendNewLine(PDPageContentStream contentStream, boolean firstLine) throws IOException {
        if (contentStream == null) {
            return;
        }
        if (firstLine) {
            contentStream.newLineAtOffset(61.0f, 780.0f);
        } else {
            contentStream.newLine();
        }
    }

    @Override
    public IAttachment.AttachmentType getSupportedAttachmentType() {
        return IAttachment.AttachmentType.TEXT;
    }
}

