/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.tools.pdfcreator.attachment.appender;

import de.bscgmbh.tools.pdfcreator.attachment.IAttachment;
import de.bscgmbh.tools.pdfcreator.attachment.PdfFormAttachment;
import de.bscgmbh.tools.pdfcreator.attachment.appender.IAttachmentAppender;
import de.bscgmbh.tools.pdfcreator.attachment.form.AFormField;
import de.bscgmbh.tools.pdfcreator.attachment.form.CheckboxFormField;
import de.bscgmbh.tools.pdfcreator.attachment.form.TextFormField;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDCheckBox;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFFormAppender
implements IAttachmentAppender {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void appendAttachment(PDDocument document, IAttachment attachment) {
        if (document == null || !(attachment instanceof PdfFormAttachment)) {
            return;
        }
        PdfFormAttachment pdfForm = (PdfFormAttachment)attachment;
        File input = new File(pdfForm.getDocumentFile());
        if (!input.isFile()) {
            return;
        }
        PDDocument pdfDocument = null;
        try {
            pdfDocument = PDDocument.load((File)input);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        HashMap<String, AFormField> formFieldmapping = new HashMap<String, AFormField>();
        for (AFormField field : pdfForm.getFormValues()) {
            formFieldmapping.put(field.getName(), field);
        }
        PDAcroForm acroForm = pdfDocument.getDocumentCatalog().getAcroForm();
        if (acroForm != null) {
            Iterator itr = acroForm.getFieldIterator();
            while (itr.hasNext()) {
                PDField f = (PDField)itr.next();
                AFormField value = (AFormField)formFieldmapping.get(f.getFullyQualifiedName());
                if (value == null) continue;
                try {
                    if (value instanceof CheckboxFormField) {
                        if (!(f instanceof PDCheckBox)) continue;
                        PDCheckBox checkbox = (PDCheckBox)f;
                        if (((CheckboxFormField)value).isChecked()) {
                            checkbox.check();
                            continue;
                        }
                        checkbox.unCheck();
                        continue;
                    }
                    if (!(value instanceof TextFormField)) continue;
                    f.setValue(((TextFormField)value).getValue());
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            try {
                acroForm.flatten();
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        PDFMergerUtility merger = new PDFMergerUtility();
        try {
            merger.appendDocument(document, pdfDocument);
            merger.mergeDocuments(MemoryUsageSetting.setupMainMemoryOnly());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            pdfDocument.close();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public IAttachment.AttachmentType getSupportedAttachmentType() {
        return IAttachment.AttachmentType.FORM;
    }
}

