/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.tools.pdfcreator.attachment;

import de.bscgmbh.tools.pdfcreator.attachment.IAttachment;
import de.bscgmbh.tools.pdfcreator.attachment.misc.RGBColor;
import de.bscgmbh.tools.pdfcreator.attachment.text.EmptyLine;
import de.bscgmbh.tools.pdfcreator.attachment.text.TextLine;
import java.util.ArrayList;

public class TextAttachment
implements IAttachment {
    protected String headlineText = null;
    protected RGBColor headLineTextColor = null;
    protected RGBColor headLineColor = null;
    protected ArrayList<TextLine> content = null;

    protected TextAttachment() {
    }

    public TextAttachment(String headlineText) {
        this.headlineText = headlineText;
    }

    public TextAttachment(String headlineText, ArrayList<TextLine> content) {
        this.headlineText = headlineText;
        this.content = content;
    }

    public String getHeadlineText() {
        if (this.headlineText == null) {
            this.headlineText = "";
        }
        return this.headlineText;
    }

    public void setHeadlineText(String headlineText) {
        this.headlineText = headlineText;
    }

    public RGBColor getHeadLineTextColor() {
        if (this.headLineTextColor == null) {
            this.headLineTextColor = RGBColor.createBlackColor();
        }
        return this.headLineTextColor;
    }

    public void setHeadLineTextColor(RGBColor headLineTextColor) {
        this.headLineTextColor = headLineTextColor;
    }

    public RGBColor getHeadLineColor() {
        if (this.headLineColor == null) {
            this.headLineColor = RGBColor.createBlackColor();
        }
        return this.headLineColor;
    }

    public void setHeadLineColor(RGBColor headLineColor) {
        this.headLineColor = headLineColor;
    }

    public ArrayList<TextLine> getContent() {
        if (this.content == null) {
            this.content = new ArrayList();
        }
        return this.content;
    }

    public void setContent(ArrayList<TextLine> content) {
        this.content = content;
    }

    public TextAttachment appendTextLine(TextLine textLine) {
        this.getContent().add(textLine);
        return this;
    }

    public TextAttachment appendTextLine(String text, RGBColor color, boolean bold) {
        return this.appendTextLine(new TextLine(text, color, bold));
    }

    public TextAttachment appendTextLine(String text) {
        return this.appendTextLine(new TextLine(text));
    }

    public TextAttachment appendEmptyLine() {
        return this.appendTextLine(new EmptyLine());
    }

    @Override
    public IAttachment.AttachmentType getType() {
        return IAttachment.AttachmentType.TEXT;
    }
}

