/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.tools.pdfcreator;

import de.bscgmbh.tools.pdfcreator.attachment.IAttachment;
import de.bscgmbh.tools.pdfcreator.attachment.appender.IAttachmentAppender;
import de.bscgmbh.tools.pdfcreator.attachment.appender.PDFFormAppender;
import de.bscgmbh.tools.pdfcreator.attachment.appender.TextAttachmentAppender;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.pdmodel.PDDocument;

public class AttachmentAppender {
    protected Map<IAttachment.AttachmentType, Set<IAttachmentAppender>> registeredAppenders = new HashMap<IAttachment.AttachmentType, Set<IAttachmentAppender>>();

    public AttachmentAppender() {
    }

    public AttachmentAppender(IAttachmentAppender ... appenders) {
        if (appenders != null) {
            for (IAttachmentAppender iAttachmentAppender : appenders) {
                this.registerAppender(iAttachmentAppender);
            }
        }
    }

    public void registerAppender(IAttachmentAppender appender) {
        if (appender == null) {
            return;
        }
        this.getAppenderSet(appender.getSupportedAttachmentType()).add(appender);
    }

    protected Set<IAttachmentAppender> getAppenderSet(IAttachment.AttachmentType type) {
        if (type == null) {
            return null;
        }
        Set<IAttachmentAppender> appenderSet = this.registeredAppenders.get((Object)type);
        if (appenderSet == null) {
            appenderSet = new HashSet<IAttachmentAppender>();
            this.registeredAppenders.put(type, appenderSet);
        }
        return appenderSet;
    }

    public void appendAttachment(PDDocument document, IAttachment attachment) {
        if (document == null || attachment == null) {
            return;
        }
        IAttachment.AttachmentType type = attachment.getType();
        Set<IAttachmentAppender> appenders = this.getAppenderSet(type);
        if (appenders != null) {
            HashSet<IAttachmentAppender> tmpAppenderSet = new HashSet<IAttachmentAppender>();
            tmpAppenderSet.addAll(appenders);
            for (IAttachmentAppender iAttachmentAppender : tmpAppenderSet) {
                iAttachmentAppender.appendAttachment(document, attachment);
            }
        }
    }

    @SafeVarargs
    public static AttachmentAppender createInstance(Class<? extends IAttachmentAppender> ... appendersToUse) {
        AttachmentAppender result = new AttachmentAppender();
        if (appendersToUse != null) {
            for (Class<? extends IAttachmentAppender> clazz : appendersToUse) {
                try {
                    result.registerAppender(clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static AttachmentAppender createDefaultInstance() {
        return AttachmentAppender.createInstance(TextAttachmentAppender.class, PDFFormAppender.class);
    }
}

