/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.impl;

import bsc.sdk.kernel.AApplicationKernel;
import bsc.sdk.kernel.IApplicationKernel;
import bsc.sdk.kernel.IKernelSettings;
import bsc.sdk.kernel.bus.messages.kernel.ipc.RemoteExecutionRequest;
import bsc.sdk.kernel.bus.messages.module.cc.ICloudClientCommand;
import bsc.sdk.kernel.bus.messages.module.cc.alexa.AddDevicesToCache;
import bsc.sdk.kernel.bus.messages.module.cc.alexa.GetAlexaUsers;
import bsc.sdk.kernel.bus.messages.module.cc.alexa.PushAlexaCredentialsToCloud;
import bsc.sdk.kernel.bus.messages.module.cc.alexa.RemoveDeviceFromCache;
import bsc.sdk.kernel.bus.messages.module.cc.alexa.RequestAlexaAuthToken;
import bsc.sdk.kernel.bus.messages.module.cc.alexa.ResetCache;
import bsc.sdk.kernel.bus.messages.module.cc.alexa.RevokeUserAccess;
import bsc.sdk.kernel.bus.messages.module.cc.alexa.UpdateCachedObject;
import bsc.sdk.kernel.bus.messages.module.cc.api.RemoveAllUserApiKeys;
import bsc.sdk.kernel.bus.messages.module.cc.api.RemoveUserApiKey;
import bsc.sdk.kernel.bus.messages.module.cc.api.SetApiKeyForUser;
import bsc.sdk.kernel.bus.messages.module.cc.cloud.CloudClientStateChanged;
import bsc.sdk.kernel.bus.messages.module.cc.cloud.RequestCloudClientDetails;
import bsc.sdk.kernel.bus.messages.module.cc.cloud.SetCloudClientLocalState;
import bsc.sdk.kernel.bus.messages.module.cc.push.RegisterPushTokenForUser;
import bsc.sdk.kernel.bus.messages.module.cc.push.SendEMailMessage;
import bsc.sdk.kernel.bus.messages.module.cc.push.SendPushMessage;
import bsc.sdk.kernel.bus.messages.module.cc.push.UnregisterPushToken;
import bsc.sdk.kernel.bus.messages.module.cc.push.UnregisterUser;
import bsc.sdk.kernel.bus.messages.module.cc.push.UpdateMessageCount;
import bsc.sdk.kernel.bus.messages.module.sn.controller.ControllerStatus;
import bsc.sdk.kernel.bus.messages.module.sn.controller.RequestSmartNodeVID;
import bsc.sdk.kernel.bus.messages.module.sn.controller.ShutdownController;
import bsc.sdk.kernel.impl.ISmartNodeIpcStateListener;
import bsc.sdk.kernel.modules.ipc.AIPCSocketClient;
import bsc.sdk.kernel.modules.ipc.IPCClient;
import bsc.sdk.kernel.modules.ipc.cc.CloudClientIpcCommandRedirector;
import bsc.sdk.kernel.modules.ipc.cc.CloudClientStateListener;
import bsc.sdk.kernel.modules.ipc.messages.IPCStatusMessage;
import bsc.sdk.kernel.modules.sn.core.CoreIpcCommandRedirector;
import bsc.sdk.kernel.modules.sn.core.KernelSettingsSyncClient;
import bsc.sdk.kernel.modules.sn.core.SmartPortManagerDelegator;
import de.bscgmbh.sn.config.modules.SoftwareVersion;
import de.bscgmbh.sn.m2m.tunnelclient.SmartCloudClient;
import de.bscgmbh.sn.m2m.tunnelclient.services.GenericObjectTransportContainer;
import de.bscgmbh.sn.m2m.tunnelclient.services.MessageHandlingService;
import de.bscgmbh.sn.m2m.tunnelclient.services.alexa.AlexaAuthToken;
import de.bscgmbh.sn.m2m.tunnelclient.services.bootstrap.BootstrapPreset;
import de.bscgmbh.sn.m2m.tunnelclient.services.smartport.ISmartPortListener;
import de.bscgmbh.sn.m2m.tunnelclient.services.smartport.SmartPort;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.engio.mbassy.listener.Handler;

@IApplicationKernel.KernelSettings(staticModules={IPCClient.class, CloudClientIpcCommandRedirector.class, CloudClientStateListener.class, CoreIpcCommandRedirector.class, KernelSettingsSyncClient.class, SmartPortManagerDelegator.class})
public class SmartNodeIpcClientKernel
extends AApplicationKernel {
    protected boolean cloudClientStarted = false;
    protected boolean cloudClientConnected = false;
    protected long cloudClientStateUpdateTimestamp = System.currentTimeMillis();
    protected long ipcOfflineSince = System.currentTimeMillis();
    protected BootstrapPreset bootstrapPreset = null;
    protected AIPCSocketClient.IPC_STATE currentIPCStatus;
    protected Set<ISmartNodeIpcStateListener> stateListener;
    protected String vid = null;
    protected boolean controllerReady = false;
    protected String controllerVersion = "";

    public SmartNodeIpcClientKernel() {
        this.refreshCloudInfosInBackground();
    }

    @SafeVarargs
    public SmartNodeIpcClientKernel(IKernelSettings kernelSettings, Set<ISmartNodeIpcStateListener> stateListener, Class<? extends AApplicationKernel.KernelModule> ... modules) {
        super(kernelSettings, (Class[])modules);
        if (stateListener != null) {
            for (ISmartNodeIpcStateListener listener : stateListener) {
                this.registerStateListener(listener);
            }
        }
        this.refreshCloudInfosInBackground();
    }

    protected void refreshCloudInfosInBackground() {
        this.backgroundExexutorPool.execute(new Runnable(){

            @Override
            public void run() {
                int counter = 0;
                boolean running = true;
                long sleepTime = TimeUnit.SECONDS.toMillis(5L);
                while (!SmartNodeIpcClientKernel.this.refreshCloudInfos() && running) {
                    switch (counter) {
                        case 120: {
                            sleepTime = TimeUnit.SECONDS.toMillis(15L);
                            break;
                        }
                        case 240: {
                            sleepTime = TimeUnit.SECONDS.toMillis(60L);
                            break;
                        }
                        case 360: {
                            sleepTime = TimeUnit.MINUTES.toMillis(30L);
                            break;
                        }
                        case 500: {
                            running = false;
                        }
                    }
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        SmartNodeIpcClientKernel.this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    ++counter;
                }
            }
        });
    }

    public String getVID() {
        String result = null;
        BootstrapPreset bootstrapPreset = this.getBootstrapPreset();
        if (bootstrapPreset != null) {
            result = bootstrapPreset.getvID();
        } else if (AIPCSocketClient.IPC_STATE.CONNECTED.equals((Object)this.currentIPCStatus)) {
            RequestSmartNodeVID request = new RequestSmartNodeVID();
            this.postKernelMessage(request).now();
            result = request.getVid();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStateListener(ISmartNodeIpcStateListener listener) {
        Set<ISmartNodeIpcStateListener> set = this.getStateListener();
        synchronized (set) {
            this.stateListener.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterStateListener(ISmartNodeIpcStateListener listener) {
        Set<ISmartNodeIpcStateListener> set = this.getStateListener();
        synchronized (set) {
            this.stateListener.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyIpcStateListener() {
        Set<ISmartNodeIpcStateListener> set = this.getStateListener();
        synchronized (set) {
            for (ISmartNodeIpcStateListener iSafeServiceStateListener : this.stateListener) {
                iSafeServiceStateListener.ipcState(this.currentIPCStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyCloudClientStateListener() {
        Set<ISmartNodeIpcStateListener> set = this.getStateListener();
        synchronized (set) {
            for (ISmartNodeIpcStateListener iSafeServiceStateListener : this.stateListener) {
                iSafeServiceStateListener.cloudClientState(this.cloudClientStarted, this.cloudClientConnected);
            }
        }
    }

    public boolean isUsable() {
        return this.isUsable(false);
    }

    public boolean isUsable(boolean checkCloudConnection) {
        if (checkCloudConnection) {
            return AIPCSocketClient.IPC_STATE.CONNECTED.equals((Object)this.currentIPCStatus) && this.cloudClientConnected && this.getVID() != null;
        }
        return AIPCSocketClient.IPC_STATE.CONNECTED.equals((Object)this.currentIPCStatus) && this.getVID() != null;
    }

    @Handler(priority=99)
    private void handleIPCStatusMessage(IPCStatusMessage status) {
        boolean notifyListeners;
        boolean refreshNeeded = false;
        boolean bl = notifyListeners = this.currentIPCStatus == null || !this.currentIPCStatus.equals((Object)status.getState());
        if (notifyListeners) {
            if (this.ipcOfflineSince < 0L && AIPCSocketClient.IPC_STATE.DISCONNECTED.equals((Object)status.getState())) {
                this.ipcOfflineSince = System.currentTimeMillis();
                this.logger.debug(IPCClient.class.getSimpleName() + " disconnected!");
            } else if (this.ipcOfflineSince > 0L && AIPCSocketClient.IPC_STATE.CONNECTED.equals((Object)status.getState())) {
                this.ipcOfflineSince = -1L;
                refreshNeeded = true;
                this.logger.debug(IPCClient.class.getSimpleName() + " connected!");
            }
        }
        this.currentIPCStatus = status.getState();
        this.logger.trace(IPCClient.class.getSimpleName() + " state changed to: " + this.currentIPCStatus);
        this.postKernelMessage(new ControllerStatus(this.controllerVersion, this.controllerReady)).now();
        if (refreshNeeded) {
            this.refreshCloudInfos();
        }
        if (notifyListeners) {
            this.notifyIpcStateListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Handler
    protected void handleShutdown(ShutdownController message) {
        Set<ISmartNodeIpcStateListener> set = this.stateListener;
        synchronized (set) {
            for (ISmartNodeIpcStateListener listener : this.stateListener) {
                listener.shutdown();
            }
        }
    }

    @Handler(priority=99)
    private void handleStateUpdate(CloudClientStateChanged message) {
        if (this.cloudClientConnected != message.isConnected() || this.cloudClientStarted != message.isStarted()) {
            this.cloudClientStateUpdateTimestamp = System.currentTimeMillis();
            this.cloudClientStarted = message.isStarted();
            this.cloudClientConnected = this.cloudClientStarted ? message.isConnected() : false;
            if (this.cloudClientStarted && this.cloudClientConnected) {
                this.refreshCloudInfos();
            }
            this.notifyCloudClientStateListener();
        }
    }

    @Handler
    private void handleControllerStatus(ControllerStatus msg) {
        if (msg != null) {
            this.controllerReady = msg.isReady();
            this.controllerVersion = SoftwareVersion.convertToString((SoftwareVersion)msg);
        }
    }

    public AIPCSocketClient.IPC_STATE getIpcState() {
        return this.currentIPCStatus;
    }

    public boolean refreshCloudInfos() {
        boolean result;
        RequestCloudClientDetails detailsRequest = new RequestCloudClientDetails();
        if (AIPCSocketClient.IPC_STATE.CONNECTED.equals((Object)this.currentIPCStatus)) {
            this.postKernelMessage(detailsRequest).now();
        }
        this.cloudClientStateUpdateTimestamp = detailsRequest.getLastStatusChange() == -1L ? this.ipcOfflineSince : detailsRequest.getLastStatusChange();
        this.cloudClientStarted = detailsRequest.isStarted();
        this.cloudClientConnected = detailsRequest.isConnected();
        boolean bl = result = detailsRequest.getBootstrapPreset() != null;
        if (result) {
            this.bootstrapPreset = detailsRequest.getBootstrapPreset();
        }
        return result;
    }

    public void remoteExecuteCloudClientCommand(ICloudClientCommand<?> command) {
        this.remoteExecuteCloudClientCommand(command, true, false);
    }

    public void remoteExecuteCloudClientCommand(ICloudClientCommand<?> command, boolean waitForRemoteExecution, boolean asyncron) {
        if (!this.isUsable()) {
            this.logger.warn("ipc socket not ready; message not sent");
            return;
        }
        if (asyncron) {
            this.postKernelMessage(new RemoteExecutionRequest(command, waitForRemoteExecution)).asynchronously();
        } else {
            this.postKernelMessage(new RemoteExecutionRequest(command, waitForRemoteExecution)).now();
        }
    }

    public boolean isCloudClientStarted() {
        return this.cloudClientStarted;
    }

    public boolean isCloudClientConnected() {
        return this.cloudClientConnected;
    }

    public long getCloudClientStateUpdateTimestamp() {
        return this.cloudClientStateUpdateTimestamp;
    }

    public AlexaAuthToken activateUserForAlexa(String username, String password) {
        PushAlexaCredentialsToCloud push = new PushAlexaCredentialsToCloud(username, password);
        this.remoteExecuteCloudClientCommand((ICloudClientCommand<?>)push);
        RequestAlexaAuthToken requestToken = new RequestAlexaAuthToken(username);
        this.remoteExecuteCloudClientCommand((ICloudClientCommand<?>)requestToken);
        return requestToken.getAuthToken();
    }

    public Set<String> getAlexaUsers() {
        HashSet<String> result = new HashSet<String>();
        GetAlexaUsers msg = new GetAlexaUsers();
        this.remoteExecuteCloudClientCommand((ICloudClientCommand<?>)msg);
        if (msg.getUsers() != null) {
            result.addAll(msg.getUsers());
        }
        return result;
    }

    public void updateAlexaUser(String username, String password) {
        PushAlexaCredentialsToCloud push = new PushAlexaCredentialsToCloud(username, password);
        this.remoteExecuteCloudClientCommand((ICloudClientCommand<?>)push, false, true);
    }

    public void removeDeviceFromCache(String username, String deviceID) {
        RemoveDeviceFromCache remove = new RemoveDeviceFromCache(username, deviceID);
        this.remoteExecuteCloudClientCommand((ICloudClientCommand<?>)remove, false, true);
    }

    public void deactivateUserForAlexa(String username) {
        RevokeUserAccess revokeAccess = new RevokeUserAccess(username);
        this.remoteExecuteCloudClientCommand((ICloudClientCommand<?>)revokeAccess, false, true);
    }

    public void revokeUserAccessForAlexa(String username) {
        RevokeUserAccess revokeAccess = new RevokeUserAccess(username);
        this.remoteExecuteCloudClientCommand((ICloudClientCommand<?>)revokeAccess);
    }

    public void pushDevicesToCloud(String username, GenericObjectTransportContainer container) {
        AddDevicesToCache addDevices = new AddDevicesToCache(username, container);
        this.remoteExecuteCloudClientCommand((ICloudClientCommand<?>)addDevices);
    }

    public void updateCloudObjects(String username, GenericObjectTransportContainer container) {
        UpdateCachedObject updateObjects = new UpdateCachedObject(username, container);
        this.remoteExecuteCloudClientCommand((ICloudClientCommand<?>)updateObjects);
    }

    public void resetCacheForUser(String username) {
        ResetCache resetCache = new ResetCache(username);
        this.remoteExecuteCloudClientCommand((ICloudClientCommand<?>)resetCache);
    }

    public BootstrapPreset getBootstrapPreset() {
        return this.bootstrapPreset;
    }

    public void setApiInterfaceStatus(SmartCloudClient.LOCAL_STATE state) {
        SetCloudClientLocalState setState = new SetCloudClientLocalState(state);
        this.remoteExecuteCloudClientCommand((ICloudClientCommand<?>)setState);
    }

    public String registerPushTokenForUser(String userName, String pushToken, MessageHandlingService.MSG_TYPE type) {
        RegisterPushTokenForUser registerPush = new RegisterPushTokenForUser(userName, pushToken, type);
        this.remoteExecuteCloudClientCommand((ICloudClientCommand<?>)registerPush);
        return registerPush.getUnregisterToken();
    }

    public void unregisterPushToken(String pushToken) {
        UnregisterPushToken unregisterPush = new UnregisterPushToken(pushToken);
        this.remoteExecuteCloudClientCommand((ICloudClientCommand<?>)unregisterPush);
    }

    public void unregisterUser(String userName) {
        UnregisterUser unregisterUser = new UnregisterUser(userName);
        this.remoteExecuteCloudClientCommand((ICloudClientCommand<?>)unregisterUser);
    }

    public void setUserApiKey(String userName, String apiKey) {
        SetApiKeyForUser setApiKey = new SetApiKeyForUser(userName, apiKey);
        this.remoteExecuteCloudClientCommand((ICloudClientCommand<?>)setApiKey);
    }

    public void deleteUserApiKey(String userName) {
        RemoveUserApiKey removeApiKey = new RemoveUserApiKey(userName);
        this.remoteExecuteCloudClientCommand((ICloudClientCommand<?>)removeApiKey);
    }

    public void deleteAllUserApiKeys() {
        RemoveAllUserApiKeys removeAllApiKeys = new RemoveAllUserApiKeys();
        this.remoteExecuteCloudClientCommand((ICloudClientCommand<?>)removeAllApiKeys);
    }

    public void updateRemoteMessageCount(String user, int messageCount) {
        UpdateMessageCount updateCount = new UpdateMessageCount(user, messageCount);
        this.remoteExecuteCloudClientCommand((ICloudClientCommand<?>)updateCount);
    }

    public void sendPushMessage(String userName, String message, Map<String, String> metaInfos) {
        SendPushMessage sendPush = new SendPushMessage(userName, message);
        if (metaInfos != null) {
            for (Map.Entry<String, String> entry : metaInfos.entrySet()) {
                sendPush.addMetaInfo(entry.getKey(), entry.getValue());
            }
        }
        this.sendPushMessage(sendPush);
    }

    public void sendPushMessage(String userName, String message) {
        SendPushMessage sendPush = new SendPushMessage(userName, message);
        this.sendPushMessage(sendPush);
    }

    public void sendPushMessage(SendPushMessage message) {
        this.remoteExecuteCloudClientCommand((ICloudClientCommand<?>)message);
    }

    public void sendMailMessage(String senderAlias, String recipientEmail, String subject, String message) {
        SendEMailMessage emailMessage = new SendEMailMessage(senderAlias, recipientEmail, subject, message);
        this.sendMailMessage(emailMessage);
    }

    public void sendMailMessage(SendEMailMessage message) {
        this.remoteExecuteCloudClientCommand((ICloudClientCommand<?>)message);
    }

    public synchronized Set<ISmartNodeIpcStateListener> getStateListener() {
        if (this.stateListener == null) {
            this.stateListener = new HashSet<ISmartNodeIpcStateListener>();
        }
        return this.stateListener;
    }

    public String getKernelSetting(Enum<?> key) {
        return super.getKernelSetting(key);
    }

    public String getKernelSetting(String key) {
        return super.getKernelSetting(key);
    }

    public Map<String, String> getKernelSettings() {
        return super.getKernelSettings();
    }

    public Map<String, String> getKernelSettings(String ... keys) {
        return super.getKernelSettings(keys);
    }

    public Map<String, String> getKernelSettings(Enum<?> ... keys) {
        return super.getKernelSettings((Enum[])keys);
    }

    public void registerUpdateListener(ISmartPortListener listener) {
        SmartPortManagerDelegator manager = (SmartPortManagerDelegator)this.getModule(SmartPortManagerDelegator.class);
        if (manager != null) {
            manager.registerUpdateListener(listener);
        }
    }

    public void unregisterUpdateListener(ISmartPortListener listener) {
        SmartPortManagerDelegator manager = (SmartPortManagerDelegator)this.getModule(SmartPortManagerDelegator.class);
        if (manager != null) {
            manager.unregisterUpdateListener(listener);
        }
    }

    public Collection<SmartPort> getAssignedRemoteSmartPorts() {
        SmartPortManagerDelegator manager = (SmartPortManagerDelegator)this.getModule(SmartPortManagerDelegator.class);
        if (manager != null) {
            return manager.getAssignedRemoteSmartPorts();
        }
        return null;
    }

    public void clearWhitelist(String smartPortID) {
        SmartPortManagerDelegator manager = (SmartPortManagerDelegator)this.getModule(SmartPortManagerDelegator.class);
        if (manager != null) {
            manager.clearWhitelist(smartPortID);
        }
    }

    public void addIdsToWhitelist(String smartPortID, String ... ids) {
        SmartPortManagerDelegator manager = (SmartPortManagerDelegator)this.getModule(SmartPortManagerDelegator.class);
        if (manager != null) {
            manager.addIdsToWhitelist(smartPortID, ids);
        }
    }

    public void removeIdsFromWhitelist(String smartPortID, String ... ids) {
        SmartPortManagerDelegator manager = (SmartPortManagerDelegator)this.getModule(SmartPortManagerDelegator.class);
        if (manager != null) {
            manager.removeIdsFromWhitelist(smartPortID, ids);
        }
    }

    public void setWhitelistEnabled(String smartPortID, boolean enabled) {
        SmartPortManagerDelegator manager = (SmartPortManagerDelegator)this.getModule(SmartPortManagerDelegator.class);
        if (manager != null) {
            manager.setWhitelistEnabled(smartPortID, enabled);
        }
    }

    public Set<String> getSmartPortWhitelist(String smartPortID) {
        SmartPortManagerDelegator manager = (SmartPortManagerDelegator)this.getModule(SmartPortManagerDelegator.class);
        if (manager != null) {
            return manager.getSmartPortWhitelist(smartPortID);
        }
        return null;
    }
}

