/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder;

import de.bsc.bapfinder.IBAPFinder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;

public abstract class Device
implements IBAPFinder.IDevice {
    protected String ip;
    protected int port;
    protected String subnetmask;
    protected String gateway;
    protected String dns;
    protected String hostname;
    protected long id;
    protected String mac;
    protected long version;
    protected long features;
    protected long commands;
    protected boolean udp;
    protected long lastMessageTime;
    protected boolean online;
    private Set<PropertyChangeListener> propertyChangeListeners = new HashSet<PropertyChangeListener>();

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public void setIp(String ip) {
        String old;
        String string = old = this.ip == null ? "" : this.ip;
        if (!old.equals(ip)) {
            this.ip = ip;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "ip", old, ip);
            this.firePropertyChange(event);
        }
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        int old = this.port;
        if (old != port) {
            this.port = port;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "port", old, port);
            this.firePropertyChange(event);
        }
    }

    @Override
    public String getSubnetmask() {
        return this.subnetmask;
    }

    @Override
    public void setSubnetmask(String subnetmask) {
        String old;
        String string = old = this.subnetmask == null ? "" : this.subnetmask;
        if (!old.equals(subnetmask)) {
            this.subnetmask = subnetmask;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "subnetmask", old, subnetmask);
            this.firePropertyChange(event);
        }
    }

    @Override
    public String getGateway() {
        return this.gateway;
    }

    @Override
    public void setGateway(String gateway) {
        String old;
        String string = old = this.gateway == null ? "" : this.gateway;
        if (!old.equals(gateway)) {
            this.gateway = gateway;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "gateway", old, gateway);
            this.firePropertyChange(event);
        }
    }

    @Override
    public String getDNS() {
        return this.dns;
    }

    @Override
    public void setDNS(String dns) {
        String old;
        String string = old = this.dns == null ? "" : this.dns;
        if (!old.equals(dns)) {
            this.dns = dns;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "dns", old, dns);
            this.firePropertyChange(event);
        }
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public void setHostname(String hostname) {
        String old;
        String string = old = this.hostname == null ? "" : this.hostname;
        if (!old.equals(hostname)) {
            this.hostname = hostname;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "hostname", old, hostname);
            this.firePropertyChange(event);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        long old = this.id;
        if (old != id) {
            this.id = id;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "id", old, id);
            this.firePropertyChange(event);
        }
    }

    @Override
    public String getMac() {
        return this.mac;
    }

    @Override
    public void setMac(String mac) {
        String old;
        String string = old = this.mac == null ? "" : this.mac;
        if (!old.equals(mac)) {
            this.mac = mac;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "mac", old, mac);
            this.firePropertyChange(event);
        }
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(long version) {
        long old = this.version;
        if (old != version) {
            this.version = version;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "version", old, version);
            this.firePropertyChange(event);
        }
    }

    @Override
    public long getFeatures() {
        return this.features;
    }

    @Override
    public void setFeatures(long features) {
        long old = this.features;
        if (old != features) {
            this.features = features;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "features", old, features);
            this.firePropertyChange(event);
        }
    }

    @Override
    public long getCommands() {
        return this.commands;
    }

    @Override
    public void setCommands(long commands) {
        long old = this.commands;
        if (old != commands) {
            this.commands = commands;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "commands", old, commands);
            this.firePropertyChange(event);
        }
    }

    @Override
    public boolean isUdp() {
        return this.udp;
    }

    @Override
    public void setUdp(boolean udp) {
        boolean old = this.udp;
        if (old != udp) {
            this.udp = udp;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "udp", old, udp);
            this.firePropertyChange(event);
        }
    }

    @Override
    public boolean hasFeature(long feature) {
        return (this.features & feature) == feature;
    }

    @Override
    public boolean hasCommand(long command) {
        return this.hasFeature(4096L) && (this.commands & command) == command;
    }

    @Override
    public boolean isOnline() {
        return this.online;
    }

    @Override
    public void setOnline(boolean online) {
        boolean old = this.online;
        if (old != online) {
            this.online = online;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "online", old, online);
            this.firePropertyChange(event);
        }
    }

    @Override
    public long getLastMessageTime() {
        return this.lastMessageTime;
    }

    @Override
    public void setLastMessageTime(long lastMessageTime) {
        long old = this.lastMessageTime;
        if (old != lastMessageTime) {
            this.lastMessageTime = lastMessageTime;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "lastMessageTime", old, lastMessageTime);
            this.firePropertyChange(event);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.propertyChangeListeners.contains(listener)) {
            this.propertyChangeListeners.add(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    @Override
    public void update(IBAPFinder.IDevice device) {
        this.setCommands(device.getCommands());
        this.setFeatures(device.getFeatures());
        this.setGateway(device.getGateway());
        this.setHostname(device.getHostname());
        this.setId(device.getId());
        this.setIp(device.getIp());
        this.setLastMessageTime(device.getLastMessageTime());
        this.setMac(device.getMac());
        this.setOnline(device.isOnline());
        this.setPort(device.getPort());
        this.setSubnetmask(device.getSubnetmask());
        this.setUdp(device.isUdp());
        this.setVersion(device.getVersion());
        this.setDNS(device.getDNS());
        this.update(this);
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        for (PropertyChangeListener listener : this.propertyChangeListeners) {
            listener.propertyChange(event);
        }
    }

    protected abstract void update(Device var1);
}

