/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder;

import de.bsc.bapfinder.Device;
import de.bsc.bapfinder.IBAPFinder;
import de.bsc.bapfinder.plugins.PluginVersion;
import de.bsc.bapfinder.tools.Tools;
import java.beans.PropertyChangeEvent;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class BoSeServer
extends Device
implements IBAPFinder.IBoSeServer {
    protected PluginVersion pluginVersion;
    protected String vid;

    protected BoSeServer() {
    }

    public BoSeServer(byte[] data, int port) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int messageType = dataInputStream.readInt();
        if (messageType != 1) {
            throw new Exception("No answer to configuration request received");
        }
        this.setIp(Tools.readString(dataInputStream));
        this.setPort(port);
        this.setSubnetmask(Tools.readString(dataInputStream));
        this.setGateway(Tools.readString(dataInputStream));
        this.setHostname(Tools.readString(dataInputStream));
        this.setMac(Tools.readString(dataInputStream));
        this.setId(dataInputStream.readLong());
        this.setFeatures(dataInputStream.readLong());
        this.setVersion(dataInputStream.readLong());
        if (this.hasFeature(4096L)) {
            this.setCommands(dataInputStream.readLong());
        }
        if (this.hasFeature(524288L)) {
            this.setDNS(Tools.readString(dataInputStream));
        }
        if (this.hasFeature(0x200000L)) {
            this.setVID(Tools.readString(dataInputStream));
        }
        this.setUdp(true);
        this.setOnline(true);
        this.setLastMessageTime(System.currentTimeMillis());
    }

    @Override
    public void setVersion(long version) {
        super.setVersion(version);
        this.pluginVersion = new PluginVersion(version);
    }

    @Override
    public String getVID() {
        return this.vid;
    }

    @Override
    public void setVID(String vid) {
        String old;
        String string = old = this.vid == null ? "" : this.vid;
        if (!old.equals(vid)) {
            this.vid = vid;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "vid", old, vid);
            this.firePropertyChange(event);
        }
    }

    @Override
    protected void update(Device device) {
        if (!(device instanceof BoSeServer)) {
            return;
        }
        this.setVID(((BoSeServer)device).getVID());
    }

    @Override
    public BoSeServer clone() {
        BoSeServer device = new BoSeServer();
        device.ip = this.ip;
        device.port = this.port;
        device.subnetmask = this.subnetmask;
        device.gateway = this.gateway;
        device.hostname = this.hostname;
        device.id = this.id;
        device.mac = this.mac;
        device.version = this.version;
        device.features = this.features;
        device.commands = this.commands;
        device.udp = this.udp;
        device.vid = this.vid;
        device.dns = this.dns;
        device.lastMessageTime = this.lastMessageTime;
        device.online = this.online;
        return device;
    }

    @Override
    public String getVersionString() {
        if (this.pluginVersion == null) {
            return "00.00.00 Build 0000";
        }
        return this.pluginVersion.getVersionString();
    }
}

