/*
 * Decompiled with CFR 0.152.
 */
package z;

import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class ClientMultiThreadedExecution {
    public static void main(String[] args) throws Exception {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(100);
        try (CloseableHttpClient httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();){
            String[] urisToGet = new String[]{"http://hc.apache.org/", "http://hc.apache.org/httpcomponents-core-ga/", "http://hc.apache.org/httpcomponents-client-ga/"};
            GetThread[] threads = new GetThread[urisToGet.length];
            int i = 0;
            while (i < threads.length) {
                HttpGet httpget = new HttpGet(urisToGet[i]);
                threads[i] = new GetThread(httpclient, httpget, i + 1);
                ++i;
            }
            int j = 0;
            while (j < threads.length) {
                threads[j].start();
                ++j;
            }
            j = 0;
            while (j < threads.length) {
                threads[j].join();
                ++j;
            }
        }
    }

    static class GetThread
    extends Thread {
        private final CloseableHttpClient httpClient;
        private final HttpContext context;
        private final HttpGet httpget;
        private final int id;

        public GetThread(CloseableHttpClient httpClient, HttpGet httpget, int id) {
            this.httpClient = httpClient;
            this.context = new BasicHttpContext();
            this.httpget = httpget;
            this.id = id;
        }

        @Override
        public void run() {
            try {
                System.out.println(String.valueOf(this.id) + " - about to get something from " + this.httpget.getURI());
                try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)this.httpget, this.context);){
                    System.out.println(String.valueOf(this.id) + " - get executed");
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity);
                        System.out.println(String.valueOf(this.id) + " - " + bytes.length + " bytes read");
                    }
                }
            }
            catch (Exception e) {
                System.out.println(String.valueOf(this.id) + " - error: " + e);
            }
        }
    }
}

