/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.http.Header;
import storage.SettingStorage;

public class Tools {
    public static <T> List<Class<T>> getClasses(String packageName, Class<T> requiredInterface) {
        return Tools.getClasses(packageName, requiredInterface, true);
    }

    public static <T> List<Class<T>> getClasses(String packageName, Class<T> requiredInterface, boolean subPackages) {
        Class<?>[] classes = Tools.getClasses(packageName, subPackages);
        ArrayList<Class<T>> tmpClasses = new ArrayList<Class<T>>();
        if (classes == null) {
            return tmpClasses;
        }
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            if (requiredInterface.isAssignableFrom(clazz)) {
                tmpClasses.add(clazz);
            }
            ++n2;
        }
        return tmpClasses;
    }

    public static Class<?>[] getClasses(String packageName, boolean subPackages) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        URL resource = classLoader.getResource(path);
        ArrayList<File> dirs = new ArrayList<File>();
        ArrayList<URL> urls = new ArrayList<URL>();
        if (!resource.toString().contains("!")) {
            dirs.add(new File(resource.getFile()));
        } else {
            urls.add(resource);
        }
        ArrayList classes = new ArrayList();
        for (File directory : dirs) {
            try {
                classes.addAll(Tools.findClasses(directory, packageName, subPackages));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        for (URL url : urls) {
            classes.addAll(Tools.findClasses(url, packageName, subPackages));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static List<Class<?>> findClasses(URL url, String packageName, boolean subPackages) {
        packageName = packageName.replace('.', '/');
        JarURLConnection connection = null;
        ArrayList classes = new ArrayList();
        try {
            connection = (JarURLConnection)url.openConnection();
            JarFile jarFile = connection.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                int index;
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(packageName) || !name.contains(".class") || !subPackages && !packageName.equals(name.substring(0, index = name.lastIndexOf("/")))) continue;
                name = name.substring(0, name.indexOf(46));
                name = name.replace('/', '.');
                try {
                    if (name.contains("$")) continue;
                    classes.add(Class.forName(name));
                }
                catch (Throwable e) {
                    System.err.println("Exception: " + e.getClass().getName() + ", Message: " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return null;
        }
        return classes;
    }

    private static List<Class<?>> findClasses(File directory, String packageName, boolean subPackages) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory() && subPackages) {
                assert (!file.getName().contains("."));
                classes.addAll(Tools.findClasses(file, String.valueOf(packageName) + "." + file.getName(), subPackages));
            } else if (file.getName().contains(".class")) {
                String name = String.valueOf(packageName) + '.' + file.getName().substring(0, file.getName().length() - 6);
                if (name.startsWith(".")) {
                    name = name.substring(1);
                }
                try {
                    if (!name.contains("$")) {
                        classes.add(Class.forName(name));
                    }
                }
                catch (Throwable e) {
                    System.err.println("Exception: " + e.getClass().getName() + ", Message: " + e.getMessage());
                }
            }
            ++n2;
        }
        return classes;
    }

    public static String getAbsolutePath(Class<?> klasse) {
        String FILE_SEPARATOR = System.getProperty("file.separator");
        try {
            String jarLocation = new File(SettingStorage.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).toString();
            jarLocation = jarLocation.substring(0, jarLocation.lastIndexOf(FILE_SEPARATOR) + 1);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static void printBoundaryValue(Header[] headerValues) {
        int i = 0;
        while (i < headerValues.length) {
            String tempValue = headerValues[i].toString();
            System.out.println("printHeadValues<" + tempValue + ">");
            ++i;
        }
    }

    public static String getBoundaryValue(Header[] headerValues) {
        String contentType = "Content-Type";
        String boundaryKey = "boundary=";
        String BOUNDARY_MARKER_PREFIX = "--";
        String returnValue = null;
        int i = 0;
        while (i < headerValues.length) {
            String tempValue = headerValues[i].toString();
            if (tempValue.indexOf("Content-Type") != -1) {
                returnValue = "--";
                if (tempValue.indexOf("boundary=") != -1) {
                    tempValue = tempValue.substring(tempValue.indexOf("boundary="));
                    tempValue = tempValue.replace("boundary=", "");
                    returnValue = String.valueOf(returnValue) + tempValue;
                    return returnValue;
                }
            }
            ++i;
        }
        return null;
    }
}

