/*
 * Decompiled with CFR 0.152.
 */
package response.statuscode.surveillancestation.streaming;

import java.util.Arrays;
import java.util.List;

public enum StatusStreaming {
    STATUS_200(200, "ok"),
    ERROR_400(400, "Execution failed."),
    ERROR_401(401, "Parameter invalid."),
    ERROR_402(402, "Camera disabled."),
    ERROR_403(403, "Insufficient license.");

    private String description;
    private int statusCode;

    private StatusStreaming(int statusCode, String description) {
        this.statusCode = statusCode;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    private boolean isStatusCode(int statusFromResponse) {
        return statusFromResponse == this.statusCode;
    }

    public static StatusStreaming getErrorCode(int statusFromResponse) {
        List<StatusStreaming> list = Arrays.asList(StatusStreaming.values());
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).isStatusCode(statusFromResponse)) {
                return list.get(i);
            }
            ++i;
        }
        return STATUS_200;
    }
}

