/*
 * Decompiled with CFR 0.152.
 */
package connect.singlemotion;

import connect.Connection;
import connect.interfaces.IMotionThread;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import request.syno.helper.CAMERA_ID;
import request.syno.surveillancestation.camera.GetSnapshot;
import response.Response;
import response.syno.surveillancestation.camera.GetSnapshotResponse;

public class MotionServiceThread
extends Thread
implements IMotionThread {
    private boolean runner = false;
    private CAMERA_ID cameraID;

    public MotionServiceThread(CAMERA_ID cameraID) {
        this.cameraID = cameraID;
        this.runner = true;
    }

    @Override
    public void run() {
        GetSnapshot gs = new GetSnapshot();
        gs.setCameraId(this.cameraID);
        Response response = Response.getResponesObject(gs.getResponseClass());
        ((GetSnapshotResponse)response).setCameraID(this.cameraID);
        HttpClient httpClient = Connection.getHttpClient();
        HttpClientContext httpClientContext = Connection.getContext();
        while (this.runner) {
            try {
                long startTime = System.currentTimeMillis();
                TimeUnit.MILLISECONDS.sleep(10L);
                HttpResponse httpResponse = httpClient.execute((HttpUriRequest)gs.getRequest(), (HttpContext)httpClientContext);
                response = response.setHttpResponse(httpResponse);
                Connection.fireIObject(response);
                long endTime = System.currentTimeMillis();
                System.out.println("Dauer Bild Abholung in ms " + (endTime - startTime));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.runner = false;
            }
        }
    }

    @Override
    public void stopThread() {
        this.runner = false;
    }

    @Override
    public boolean isRunning() {
        return this.runner;
    }
}

