/*
 * Decompiled with CFR 0.152.
 */
package connect.mjpeg.test.dritterVersuch;

import connect.Connection;
import connect.mjpeg.MJPEGStream;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.ArrayUtils;
import request.syno.helper.CAMERA_ID;
import response.syno.surveillancestation.camera.GetSnapshotResponse;

public class Verarbeitung
extends Thread {
    private BlockingQueue<Byte[]> blockingQueue = new ArrayBlockingQueue<Byte[]>(10240);
    private ByteBuffer verarbeitungsBuffer = null;
    private boolean isRunning = false;
    private String boundary;
    private CAMERA_ID cameraId;
    private final byte[] SOI_MARKER = new byte[]{-1, -40};
    private final byte[] EOI_MARKER = new byte[]{-1, -39};
    private final String CONTENT_LENGTH = "Content-Length".toLowerCase();
    private static final int HEADER_MAX_LENGTH = 100;
    public static final int FRAME_MAX_LENGTH = 100100;
    private DataInputStream dis;

    public Verarbeitung(String boundary, CAMERA_ID cameraID) {
        this.boundary = boundary;
        this.cameraId = cameraID;
        this.isRunning = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        byte[] header = null;
        byte[] frame = null;
        try {
            while (true) {
                if (!this.isRunning) {
                    return;
                }
                try {
                    System.out.println("vor blocking value");
                    Byte[] tempArray = this.blockingQueue.take();
                    if (this.dis == null) {
                        this.dis = new DataInputStream(new ByteArrayInputStream(ArrayUtils.toPrimitive((Byte[])tempArray)));
                    } else {
                        byte[] rest = new byte[this.dis.available()];
                        this.dis.read(rest);
                        ByteArrayOutputStream baot = new ByteArrayOutputStream();
                        baot.write(rest);
                        baot.write(ArrayUtils.toPrimitive((Byte[])tempArray));
                        baot.flush();
                        this.dis = new DataInputStream(new ByteArrayInputStream(baot.toByteArray()));
                    }
                    boolean moreContent = false;
                    do {
                        this.dis.mark(100100);
                        if (this.dis.available() < 2) {
                            moreContent = false;
                            break;
                        }
                        int n = this.getStartOfSequence(this.dis, this.SOI_MARKER);
                        if (n == -1) {
                            moreContent = false;
                            break;
                        }
                        this.dis.reset();
                        header = new byte[n];
                        this.dis.readFully(header);
                        int length = -1;
                        try {
                            length = this.parseContentLength(header);
                            System.out.println("laengeNachParsed Header " + length);
                        }
                        catch (NumberFormatException e) {
                            length = this.getEndOfSeqeunce(this.dis, this.EOI_MARKER);
                            System.out.println("laengeNachEOI " + length);
                        }
                        System.out.println("header toHex " + MJPEGStream.toHexString(header));
                        System.out.println("header clear " + new String(header));
                        System.out.println("header size " + header.length);
                        if (length == 0) {
                            System.out.println("Invalid MJPEG stream, EOI (0xFF,0xD9) not found!");
                            this.dis.reset();
                            moreContent = false;
                            break;
                        }
                        this.dis.reset();
                        frame = new byte[length];
                        if (length > this.dis.available() - n) {
                            moreContent = false;
                            break;
                        }
                        this.dis.skipBytes(n);
                        this.dis.readFully(frame);
                        try {
                            BufferedImage image = ImageIO.read(new ByteArrayInputStream(frame));
                            GetSnapshotResponse snapshot = new GetSnapshotResponse();
                            snapshot.setCameraID(this.cameraId);
                            snapshot.setImage(image);
                            Connection.fireIObject(snapshot);
                            this.dis.skipBytes(length);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        System.out.println("dis.available() " + this.dis.available());
                    } while ((moreContent = this.dis.available() > 30000) && this.isRunning);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getStartOfSequence(DataInputStream in, byte[] sequence) throws IOException {
        int end = this.getEndOfSeqeunce(in, sequence);
        return end < 0 ? -1 : end - sequence.length;
    }

    private int getEndOfSeqeunce(DataInputStream in, byte[] sequence) throws IOException {
        long startTime = System.currentTimeMillis();
        int s = 0;
        int zaehler = 0;
        int laengerAls100ms = 0;
        boolean first = false;
        int endeKrit = in.available();
        int i = 0;
        while (i < endeKrit) {
            long start1 = System.currentTimeMillis();
            byte c = (byte)in.readUnsignedByte();
            long ende2 = System.currentTimeMillis();
            if (ende2 - start1 > 100L) {
                ++laengerAls100ms;
            }
            if (c == sequence[s]) {
                if (++s == sequence.length) {
                    long endTime = System.currentTimeMillis();
                    System.out.println("readUnsigne " + (endTime - startTime));
                    System.out.println("durchlauf wie oft " + zaehler);
                    System.out.println("readUnsigne laenger als 100ms count " + laengerAls100ms);
                    return i + 1;
                }
            } else {
                s = 0;
            }
            ++zaehler;
            ++i;
        }
        System.out.println("gebe minus 1  zur\u00fcck");
        return -1;
    }

    private int getEndOfSeqeunce(ByteBuffer verarbeitungsBuffer, byte[] sequence) {
        int s = 0;
        System.out.println("verarbeitungsBuffer.capacity(); " + verarbeitungsBuffer.capacity());
        int capacity = verarbeitungsBuffer.capacity();
        ByteArrayInputStream din = new ByteArrayInputStream(verarbeitungsBuffer.array());
        verarbeitungsBuffer.rewind();
        int zaehler = 0;
        int i = 0;
        while (i < capacity) {
            byte c = (byte)din.read();
            if (c == sequence[s]) {
                if (++s == sequence.length) {
                    System.out.println("gefunden zweites ELement " + i);
                    long endTime = System.currentTimeMillis();
                    return i + 1;
                }
            } else {
                s = 0;
            }
            ++zaehler;
            ++i;
        }
        return -1;
    }

    private int parseContentLength(byte[] headerBytes) throws IOException, NumberFormatException {
        System.out.println("headerBytes laenge " + headerBytes.length);
        ByteArrayInputStream bais = new ByteArrayInputStream(headerBytes);
        InputStreamReader isr = new InputStreamReader(bais);
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] parts;
            if (!line.toLowerCase().startsWith(this.CONTENT_LENGTH) || (parts = line.split(":")).length != 2) continue;
            int valueToReturn = Integer.parseInt(parts[1].trim());
            return valueToReturn;
        }
        return 0;
    }

    private int getStartOfSequence(ByteBuffer verarbeitungsBuffer, byte[] sequence) {
        int end = this.getEndOfSeqeunce(verarbeitungsBuffer, sequence);
        return end < 0 ? -1 : end - sequence.length;
    }

    public synchronized void append(Byte[] appendAbleArray) {
        this.blockingQueue.add(appendAbleArray);
    }

    public void stopThread() {
        this.isRunning = false;
    }
}

