/*
 * Decompiled with CFR 0.152.
 */
package connect.mjpeg.test;

import connect.interfaces.IMotionThread;
import connect.mjpeg.MJPEGStream;
import connect.mjpeg.test.MJPEGParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import request.syno.helper.CAMERA_ID;
import response.syno.surveillancestation.camera.GetSnapshotResponse;

public class MJPEGThread2
extends Thread
implements IMotionThread {
    private MJPEGStream meg = null;
    private CAMERA_ID cameraID;
    private boolean running = false;
    private InputStream inputStream;
    private static final String BOUNDARY_MARKER_PREFIX = "--";
    private static final int MAX_IMAGE_SIZE = 0x500000;
    private String boundaryItem;
    private byte[] buffer = new byte[0];

    public MJPEGThread2(String boundaryItem, InputStream in, CAMERA_ID cameraID) {
        this.boundaryItem = boundaryItem;
        this.inputStream = in;
        this.cameraID = cameraID;
        this.running = true;
    }

    @Override
    public void run() {
        LinkedBlockingQueue<byte[]> imageQueue = new LinkedBlockingQueue<byte[]>(3);
        ExecutorService service = Executors.newSingleThreadExecutor();
        MJPEGParser.ConnectionStateEnum connectionStateEnum = MJPEGParser.ConnectionStateEnum.OK;
        GetSnapshotResponse snapshot = new GetSnapshotResponse();
        snapshot.setCameraID(this.cameraID);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedInputStream bufIn = new BufferedInputStream(this.inputStream);){
                Future<MJPEGParser.ConnectionStateEnum> future = service.submit(new MJPEGParser(bufIn, this.boundaryItem, imageQueue, 0x500000));
                while (!future.isDone() && this.running) {
                    try {
                        byte[] image = (byte[])imageQueue.poll(1L, TimeUnit.SECONDS);
                        if (image == null) continue;
                        System.out.println("polled image " + new String(image));
                        System.out.println("first:  " + MJPEGStream.toHexString(image[0]) + " " + MJPEGStream.toHexString(image[1]));
                        System.out.println("last:  " + MJPEGStream.toHexString(image[image.length - 2]) + " " + MJPEGStream.toHexString(image[image.length - 1]));
                        this.buffer = image;
                    }
                    catch (InterruptedException image) {
                        // empty catch block
                    }
                }
                if (!this.running) {
                    future.cancel(true);
                }
                try {
                    connectionStateEnum = future.get();
                }
                catch (InterruptedException | CancellationException | ExecutionException e) {
                    connectionStateEnum = MJPEGParser.ConnectionStateEnum.CANCELLED;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        service.shutdown();
        if (connectionStateEnum != MJPEGParser.ConnectionStateEnum.OK) {
            this.buffer = null;
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void stopThread() {
        this.running = false;
    }
}

