/*
 * Decompiled with CFR 0.152.
 */
package connect;

import connect.interfaces.IMotionThread;
import connect.listener.IAPIListener;
import connect.listener.IMotionListener;
import connect.listener.IObjectListener;
import connect.mjpeg.MJPEGThread;
import connect.mjpeg.test.MJPEGThread2;
import connect.mjpeg.test.dritterVersuch.MJPEGThread3;
import connect.motion.MotionServiceAPIConnect;
import connect.singlemotion.MotionServiceThread;
import database.CameraObject;
import exception.NoInitializedConnection;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import motion.IMotionServiceAPIConnect;
import motion.MotionConnector;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import request.syno.api.auth.Login;
import request.syno.api.auth.Logout;
import request.syno.api.info.Query;
import request.syno.helper.CAMERA_ID;
import request.syno.helper.externalRecording.ActionType;
import request.syno.helper.ptz.ControlPTZ;
import request.syno.helper.ptz.DirectionPTZ;
import request.syno.helper.ptz.MoveTypePTZ;
import request.syno.surveillancestation.camera.GetLiveViewPath;
import request.syno.surveillancestation.camera.GetSnapshot;
import request.syno.surveillancestation.camera.List;
import request.syno.surveillancestation.externalRecording.Record;
import request.syno.surveillancestation.info.GetInfo;
import request.syno.surveillancestation.notification.schedule.GetAccessControlControllerSchedule;
import request.syno.surveillancestation.notification.schedule.GetCameraSchedule;
import request.syno.surveillancestation.ptz.Focus;
import request.syno.surveillancestation.ptz.Home;
import request.syno.surveillancestation.ptz.Move;
import request.syno.surveillancestation.ptz.Zoom;
import request.syno.surveillancestation.streaming.LiveStream;
import request.syno.surveillancestation.videostream.Stream;
import response.Response;
import response.syno.api.auth.LoginResponse;
import response.syno.api.auth.answer.SID_Value;
import response.syno.api.info.QueryInfoResponse;
import response.syno.surveillancestation.camera.GetSnapshotResponse;
import response.syno.surveillancestation.camera.ListResponse;
import response.syno.surveillancestation.camera.answer.Camera_List_Object;
import response.syno.surveillancestation.externalRecording.RecordResponse;
import server.ServerSurveillance;
import storage.APIStorage;
import storage.SettingStorage;
import storage.connection.SettingsConnection;
import tools.GenericPairVO;
import tools.Tools;

public class Connection {
    private static Connection connection;
    private String ipOrNameDiskstation = "http://192.168.150.117:5000";
    private java.util.List<IAPIListener> iAPIListener = new ArrayList<IAPIListener>();
    private java.util.List<IObjectListener> iObjectListner = new ArrayList<IObjectListener>();
    private java.util.List<IMotionListener> iMotionListener = new ArrayList<IMotionListener>();
    private HttpClient httpclient;
    private HttpClientContext context;
    private CookieStore cookieStore;
    private HashMap<Integer, GenericPairVO<IMotionThread, Integer>> streamMap = new HashMap();
    private MotionServiceAPIConnect motionServiceAPI;

    private Connection() {
        this.httpclient = HttpClients.createDefault();
        this.motionServiceAPI = new MotionServiceAPIConnect();
        this.motionServiceAPI.readSettings();
    }

    public static void initSynologyConnection() throws ClientProtocolException, IOException {
        SettingsConnection settingsConnection = SettingStorage.getSettingsConnection();
        if (settingsConnection.getIpStation() == null || settingsConnection.getIpStation().equals("0.0.0.0")) {
            return;
        }
        Connection.initConnection("http://" + settingsConnection.getIpStation() + ":5000");
        Connection.doAPIOverview();
        Connection.doConnect(settingsConnection.getUserName(), settingsConnection.getPassword());
        Connection.getCammeraList();
        MotionConnector.createInstance((IMotionServiceAPIConnect)Connection.connection.motionServiceAPI);
        ServerSurveillance.serverStart();
    }

    public static void releaseConnection() {
        APIStorage.clearAll();
        ServerSurveillance.serverStop();
        if (connection != null) {
            connection = null;
        }
    }

    public static void initConnection(String ipOrNameDiskstation) {
        if (connection == null) {
            connection = new Connection();
        }
        connection.setDestination(ipOrNameDiskstation);
    }

    private void setDestination(String ipOrNameDiskstation) {
        this.ipOrNameDiskstation = ipOrNameDiskstation;
    }

    public static String getDestinationIP() {
        return Connection.connection.ipOrNameDiskstation;
    }

    public static void addIAPIListener(IAPIListener toAddListener) throws NoInitializedConnection {
        if (connection == null) {
            throw new NoInitializedConnection();
        }
        Connection.connection.iAPIListener.add(toAddListener);
    }

    public static void removeIAPIListener(IAPIListener toRemoveListener) {
        if (connection == null) {
            return;
        }
        Connection.connection.iAPIListener.remove(toRemoveListener);
    }

    public static void addIObjectListener(IObjectListener toAddListener) throws NoInitializedConnection {
        if (connection == null) {
            throw new NoInitializedConnection();
        }
        Connection.connection.iObjectListner.add(toAddListener);
    }

    public static void addIMotionListener(IMotionListener toAddListener) throws NoInitializedConnection {
        if (connection == null) {
            throw new NoInitializedConnection();
        }
        Connection.connection.iMotionListener.add(toAddListener);
    }

    public static void removeIMotionListener(IMotionListener toRemoveListener) {
        if (connection == null) {
            return;
        }
        Connection.connection.iMotionListener.remove(toRemoveListener);
    }

    public static void fireIMotion(String entryPointValue) {
        for (IMotionListener iMotionListener : Connection.connection.iMotionListener) {
            iMotionListener.setMotionDetect(entryPointValue);
        }
    }

    public static void removeIObjectListener(long kameraid_software, IObjectListener toRemoveListener) {
        Connection.removeIObjectListener(toRemoveListener);
        java.util.List<CameraObject> gespeicherteKameras = SettingStorage.readCameraObjectList();
        int i = 0;
        while (i < gespeicherteKameras.size()) {
            if (gespeicherteKameras.get(i).getKameraid_software() == kameraid_software) {
                int ansprechId = gespeicherteKameras.get(i).getKameraid().getRawCameraId();
                GenericPairVO<IMotionThread, Integer> mapValue = Connection.connection.streamMap.get(ansprechId);
                if (mapValue == null) break;
                mapValue.setRight(mapValue.getRight() - 1);
                if (mapValue.getRight() > 0 || mapValue.getLeft() == null) break;
                mapValue.getLeft().stopThread();
                Connection.connection.streamMap.remove(ansprechId);
                break;
            }
            ++i;
        }
    }

    public static void removeIObjectListener(IObjectListener toRemoveListener) {
        if (connection == null) {
            return;
        }
        Connection.connection.iObjectListner.remove(toRemoveListener);
    }

    public static void fireIAPIMessage(int statusCode, String messageFromBody) {
        for (IAPIListener listener : Connection.connection.iAPIListener) {
            listener.setIAPIAnswerValue(statusCode, messageFromBody);
        }
    }

    public static void fireIObject(Response response) {
        for (IObjectListener listener : Connection.connection.iObjectListner) {
            listener.setIObjectChange(response);
        }
    }

    public static void doAPIOverview() throws ClientProtocolException, IOException {
        if (Connection.connection.httpclient == null) {
            Connection.connection.httpclient = HttpClients.createDefault();
        }
        Query query = new Query();
        Response response = Response.getResponesObject(query.getResponseClass());
        Connection.connection.context = HttpClientContext.create();
        HttpResponse httpResponse = Connection.connection.httpclient.execute((HttpUriRequest)query.getRequest(), (HttpContext)Connection.connection.context);
        response = response.setHttpResponse(httpResponse);
        APIStorage.fillAPIMap((QueryInfoResponse)response);
        java.util.List cookies = Connection.connection.context.getCookieStore().getCookies();
        if (cookies.isEmpty()) {
            System.out.println("None");
        } else {
            int i = 0;
            while (i < cookies.size()) {
                System.out.println("- " + ((Cookie)cookies.get(i)).toString());
                ++i;
            }
        }
        Connection.fireIObject(response);
    }

    public static void doConnectWithSid(String benutzer, String passwort) {
        if (Connection.connection.httpclient == null) {
            Connection.connection.httpclient = HttpClients.createDefault();
        }
        Login login = new Login();
        login.setAccountName(benutzer);
        login.setPassword(passwort);
        login.useSid(true);
        Response response = Response.getResponesObject(login.getResponseClass());
        try {
            Connection.connection.context = HttpClientContext.create();
            HttpResponse httpResponse = Connection.connection.httpclient.execute((HttpUriRequest)login.getRequest(), (HttpContext)Connection.connection.context);
            response = response.setHttpResponse(httpResponse);
            APIStorage.fillSID((LoginResponse)response);
            Connection.fireIObject(response);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void doConnect(String benutzer, String passwort) {
        if (Connection.connection.httpclient == null) {
            Connection.connection.httpclient = HttpClients.createDefault();
        }
        Login login = new Login();
        login.setAccountName(benutzer);
        login.setPassword(passwort);
        try {
            Connection.connection.context = HttpClientContext.create();
            HttpResponse httpResponse = Connection.connection.httpclient.execute((HttpUriRequest)login.getRequest(), (HttpContext)Connection.connection.context);
            HttpEntity entity = httpResponse.getEntity();
            if (entity != null) {
                entity.consumeContent();
            }
            java.util.List cookies = Connection.connection.context.getCookieStore().getCookies();
            Connection.connection.cookieStore = Connection.connection.context.getCookieStore();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void doLogout() {
        if (Connection.connection.httpclient == null) {
            return;
        }
        Logout logOut = new Logout();
        try {
            Connection.connection.context = HttpClientContext.create();
            HttpResponse httpResponse = Connection.connection.httpclient.execute((HttpUriRequest)logOut.getRequest(), (HttpContext)Connection.connection.context);
            System.out.println("logout?  " + httpResponse.getStatusLine());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (Connection.connection.context.getCookieStore() != null) {
            CookieStore cookieStore = Connection.connection.context.getCookieStore();
            java.util.List cookies = cookieStore.getCookies();
            int i = 0;
            while (i < cookies.size()) {
                System.out.println("cookies " + ((Cookie)cookies.get(i)).toString());
                ++i;
            }
        }
    }

    public static void doSurvGetInfo() {
        if (Connection.connection.httpclient == null) {
            Connection.connection.httpclient = HttpClients.createDefault();
        }
        GetInfo getInfo = new GetInfo();
        Response response = Response.getResponesObject(getInfo.getResponseClass());
        try {
            Connection.connection.context = HttpClientContext.create();
            if (connection.getCookieStore() != null) {
                Connection.connection.context.setCookieStore(connection.getCookieStore());
            }
            HttpResponse httpResponse = Connection.connection.httpclient.execute((HttpUriRequest)getInfo.getRequest(), (HttpContext)Connection.connection.context);
            System.out.println("getInfo?  " + httpResponse.getStatusLine());
            response = response.setHttpResponse(httpResponse);
            Connection.fireIObject(response);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public void setCookie(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public static void getCameraGetInfoList() {
        if (Connection.connection.httpclient == null) {
            Connection.connection.httpclient = HttpClients.createDefault();
        }
        request.syno.surveillancestation.camera.GetInfo getInfo = new request.syno.surveillancestation.camera.GetInfo();
        Response response = Response.getResponesObject(getInfo.getResponseClass());
        try {
            Connection.connection.context = HttpClientContext.create();
            if (connection.getCookieStore() != null) {
                Connection.connection.context.setCookieStore(connection.getCookieStore());
            }
            HttpResponse httpResponse = Connection.connection.httpclient.execute((HttpUriRequest)getInfo.getRequest(), (HttpContext)Connection.connection.context);
            System.out.println("getInfo?  " + httpResponse.getStatusLine());
            response = response.setHttpResponse(httpResponse);
            Connection.fireIObject(response);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void getCammeraListSid() {
        if (Connection.connection.httpclient == null) {
            Connection.connection.httpclient = HttpClients.createDefault();
        }
        List listInfo = new List();
        Response response = Response.getResponesObject(listInfo.getResponseClass());
        SID_Value sidValue = APIStorage.getSID_Value();
        try {
            Connection.connection.context = HttpClientContext.create();
            HttpResponse httpResponse = Connection.connection.httpclient.execute((HttpUriRequest)listInfo.getRequestSid(sidValue), (HttpContext)Connection.connection.context);
            response = response.setHttpResponse(httpResponse);
            APIStorage.fillCameraMap((ListResponse)response);
            Connection.fireIObject(response);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void getCammeraList() {
        if (Connection.connection.httpclient == null) {
            Connection.connection.httpclient = HttpClients.createDefault();
        }
        List listInfo = new List();
        Response response = Response.getResponesObject(listInfo.getResponseClass());
        try {
            ListResponse listResponse;
            HttpResponse httpResponse;
            Connection.connection.context = HttpClientContext.create();
            if (connection.getCookieStore() != null) {
                Connection.connection.context.setCookieStore(connection.getCookieStore());
            }
            if ((response = response.setHttpResponse(httpResponse = Connection.connection.httpclient.execute((HttpUriRequest)listInfo.getRequest(), (HttpContext)Connection.connection.context))) != null && response instanceof ListResponse && !(listResponse = (ListResponse)response).isErrorObjectFilled()) {
                APIStorage.fillCameraMap((ListResponse)response);
            }
            Connection.fireIObject(response);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void getCameraSnapshot() {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        GetSnapshot gs = new GetSnapshot();
        Camera_List_Object kamera = APIStorage.getCameraMap().get(1);
        gs.setCameraId(kamera.getCameraId());
        Response response = Response.getResponesObject(gs.getResponseClass());
        try {
            HttpClientContext clientContext = HttpClientContext.create();
            if (connection.getCookieStore() != null) {
                clientContext.setCookieStore(connection.getCookieStore());
            }
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)gs.getRequest(), (HttpContext)clientContext);
            response = response.setHttpResponse(httpResponse);
            Connection.fireIObject(response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getCameraSnapshotSid() {
        if (Connection.connection.httpclient == null) {
            Connection.connection.httpclient = HttpClients.createDefault();
        }
        GetSnapshot gs = new GetSnapshot();
        Camera_List_Object kamera = APIStorage.getCameraMap().get(1);
        gs.setCameraId(kamera.getCameraId());
        Response response = Response.getResponesObject(gs.getResponseClass());
        SID_Value sidValue = APIStorage.getSID_Value();
        try {
            Connection.connection.context = HttpClientContext.create();
            if (connection.getCookieStore() != null) {
                Connection.connection.context.setCookieStore(connection.getCookieStore());
            }
            HttpResponse httpResponse = Connection.connection.httpclient.execute((HttpUriRequest)gs.getRequestSid(sidValue), (HttpContext)Connection.connection.context);
            response = response.setHttpResponse(httpResponse);
            Connection.fireIObject(response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void startSecondLiveStream() {
        if (Connection.connection.httpclient == null) {
            Connection.connection.httpclient = HttpClients.createDefault();
        }
        LiveStream ls = new LiveStream();
        Camera_List_Object kamera = APIStorage.getCameraMap().get(2);
        ls.setCameraID(kamera.getCameraId());
        try {
            Connection.connection.context = HttpClientContext.create();
            if (connection.getCookieStore() != null) {
                Connection.connection.context.setCookieStore(connection.getCookieStore());
            }
            HttpResponse httpResponse = Connection.connection.httpclient.execute((HttpUriRequest)ls.getRequest(), (HttpContext)Connection.connection.context);
            System.out.println("httpResponse " + httpResponse.getStatusLine());
            Header[] temp = httpResponse.getAllHeaders();
            String boundaryItem = Tools.getBoundaryValue(temp);
            if (boundaryItem != null) {
                HttpEntity entity = httpResponse.getEntity();
                InputStream in = entity.getContent();
                MJPEGThread2 thread = new MJPEGThread2(boundaryItem, in, kamera.getCameraId());
                thread.start();
            }
            int i = 0;
            while (i < temp.length) {
                System.out.println("header " + temp[i].toString());
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HttpClient getHttpClient() {
        if (Connection.connection.httpclient == null) {
            Connection.connection.httpclient = HttpClients.createDefault();
        }
        return Connection.connection.httpclient;
    }

    public static HttpClientContext getContext() {
        Connection.connection.context = HttpClientContext.create();
        if (connection.getCookieStore() != null) {
            Connection.connection.context.setCookieStore(connection.getCookieStore());
        }
        return Connection.connection.context;
    }

    public static void startSnaphshotStreamWithCookieOwnId(long kameraid_software) {
        java.util.List<CameraObject> gespeicherteKameras = SettingStorage.readCameraObjectList();
        int i = 0;
        while (i < gespeicherteKameras.size()) {
            System.out.println("ID in Ger\u00fcmpelListe " + gespeicherteKameras.get(i).getKameraid_software());
            if (gespeicherteKameras.get(i).getKameraid_software() == kameraid_software) {
                System.out.println("gestartet wird " + gespeicherteKameras.get(i).getKameraid().getRawCameraId());
                Connection.startSnaphshotStreamWithCookie(gespeicherteKameras.get(i).getKameraid().getRawCameraId());
                break;
            }
            ++i;
        }
    }

    public static void startSnaphshotStreamWithCookie(int kameraRawId) {
        if (Connection.connection.httpclient == null) {
            Connection.connection.httpclient = HttpClients.createDefault();
        }
        try {
            Camera_List_Object cameraListObject = APIStorage.getCameraMap().get(kameraRawId);
            if (cameraListObject == null) {
                throw new Exception();
            }
            GenericPairVO<IMotionThread, Integer> streamContent = Connection.connection.streamMap.get(kameraRawId);
            if (streamContent != null && streamContent.getLeft().isRunning()) {
                streamContent.setRight(streamContent.getRight() + 1);
                return;
            }
            MotionServiceThread motionThread = new MotionServiceThread(cameraListObject.getCameraId());
            motionThread.start();
            Connection.connection.streamMap.put(kameraRawId, new GenericPairVO<MotionServiceThread, Integer>(motionThread, 1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void startMJPEGStreamWithCookieWithOwnId(long kameraid_software) {
        java.util.List<CameraObject> gespeicherteKameras = SettingStorage.readCameraObjectList();
        int i = 0;
        while (i < gespeicherteKameras.size()) {
            if (gespeicherteKameras.get(i).getKameraid_software() == kameraid_software) {
                Connection.startMJPEGStreamWithCookie(gespeicherteKameras.get(i).getKameraid().getRawCameraId(), false);
                break;
            }
            ++i;
        }
    }

    public static void startMJPEGStreamWithCookie(int kameraRawId, boolean isRecursiveCall) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            Camera_List_Object cameraListObject = APIStorage.getCameraMap().get(kameraRawId);
            if (cameraListObject == null) {
                throw new Exception();
            }
            GenericPairVO<IMotionThread, Integer> streamContent = Connection.connection.streamMap.get(kameraRawId);
            if (streamContent != null && streamContent.getLeft().isRunning()) {
                streamContent.setRight(streamContent.getRight() + 1);
                return;
            }
            Stream st = new Stream();
            st.setCameraID(cameraListObject.getCameraId());
            HttpClientContext clientContext = HttpClientContext.create();
            if (connection.getCookieStore() != null) {
                clientContext.setCookieStore(connection.getCookieStore());
            }
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)st.getRequest(), (HttpContext)clientContext);
            HttpEntity entity = httpResponse.getEntity();
            String boundaryItem = Tools.getBoundaryValue(httpResponse.getAllHeaders());
            MJPEGThread thread = null;
            if (boundaryItem != null && boundaryItem.contains("--myboundary")) {
                InputStream in = entity.getContent();
                thread = new MJPEGThread(in, cameraListObject.getCameraId(), boundaryItem);
                thread.start();
                Connection.connection.streamMap.put(kameraRawId, new GenericPairVO<MJPEGThread, Integer>(thread, 1));
            } else if (!isRecursiveCall) {
                SettingsConnection settingsConnection = SettingStorage.getSettingsConnection();
                if (settingsConnection.getIpStation() == null || settingsConnection.getIpStation().equals("0.0.0.0")) {
                    return;
                }
                Connection.doAPIOverview();
                Connection.doConnect(settingsConnection.getUserName(), settingsConnection.getPassword());
                Connection.startMJPEGStreamWithCookie(kameraRawId, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void stopMJPEGStreamWithCookieWithOwnId(long kameraid_software) {
        java.util.List<CameraObject> gespeicherteKameras = SettingStorage.readCameraObjectList();
        int i = 0;
        while (i < gespeicherteKameras.size()) {
            if (gespeicherteKameras.get(i).getKameraid_software() == kameraid_software) {
                Connection.stopMJPEGStreamWithCookie(gespeicherteKameras.get(i).getKameraid().getRawCameraId());
                break;
            }
            ++i;
        }
    }

    public static void stopMJPEGStreamWithCookie(int kameraRawId) {
        boolean remove = false;
        for (Map.Entry<Integer, GenericPairVO<IMotionThread, Integer>> entry : Connection.connection.streamMap.entrySet()) {
            if (entry.getKey() != kameraRawId) continue;
            if (entry.getValue().getRight() <= 1) {
                entry.getValue().getLeft().stopThread();
                remove = true;
                break;
            }
            if (entry.getValue().getRight() <= 1) break;
            entry.getValue().setRight(entry.getValue().getRight() - 1);
            break;
        }
        if (remove) {
            Connection.connection.streamMap.remove(kameraRawId);
        }
    }

    public static void startStreamWithSid() {
        if (Connection.connection.httpclient == null) {
            Connection.connection.httpclient = HttpClients.createDefault();
        }
        Stream st = new Stream();
        Camera_List_Object kamera = APIStorage.getCameraMap().get(2);
        st.setCameraID(kamera.getCameraId());
        SID_Value sidValue = APIStorage.getSID_Value();
        try {
            Connection.connection.context = HttpClientContext.create();
            HttpResponse httpResponse = Connection.connection.httpclient.execute((HttpUriRequest)st.getRequestSid(sidValue), (HttpContext)Connection.connection.context);
            HttpEntity entity = httpResponse.getEntity();
            Header[] temp = httpResponse.getAllHeaders();
            int i = 0;
            while (i < temp.length) {
                System.out.println("header " + temp[i].toString());
                ++i;
            }
            System.out.println("contentLength " + entity.getContentLength());
            System.out.println("ContentType   " + entity.getContentType().toString());
            System.out.println("encoding      " + entity.getContentEncoding());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getLiveViewPath() {
        if (Connection.connection.httpclient == null) {
            Connection.connection.httpclient = HttpClients.createDefault();
        }
        GetLiveViewPath gsp = new GetLiveViewPath();
        java.util.List<CAMERA_ID> cameraList = APIStorage.getCameraList();
        gsp.setCameraList(cameraList);
        Response response = Response.getResponesObject(gsp.getResponseClass());
        try {
            Connection.connection.context = HttpClientContext.create();
            if (connection.getCookieStore() != null) {
                Connection.connection.context.setCookieStore(connection.getCookieStore());
            }
            HttpResponse httpResponse = Connection.connection.httpclient.execute((HttpUriRequest)gsp.getRequest(), (HttpContext)Connection.connection.context);
            response = response.setHttpResponse(httpResponse);
            Connection.fireIObject(response);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void getFormatForVideoStream() {
        if (Connection.connection.httpclient == null) {
            Connection.connection.httpclient = HttpClients.createDefault();
        }
        request.syno.surveillancestation.videostream.Query query = new request.syno.surveillancestation.videostream.Query();
        CAMERA_ID cameraObject = APIStorage.getCameraList().get(0);
        query.setCameraID(cameraObject);
        Response response = Response.getResponesObject(query.getResponseClass());
        try {
            Connection.connection.context = HttpClientContext.create();
            if (connection.getCookieStore() != null) {
                Connection.connection.context.setCookieStore(connection.getCookieStore());
            }
            HttpResponse httpResponse = Connection.connection.httpclient.execute((HttpUriRequest)query.getRequest(), (HttpContext)Connection.connection.context);
            response = response.setHttpResponse(httpResponse);
            Connection.fireIObject(response);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isCoookieStoreFilled() {
        return connection != null && Connection.connection.cookieStore != null;
    }

    public static void getAccessControlSchedule() {
        if (Connection.connection.httpclient == null) {
            Connection.connection.httpclient = HttpClients.createDefault();
        }
        GetAccessControlControllerSchedule getAccess = new GetAccessControlControllerSchedule();
        Response response = Response.getResponesObject(getAccess.getResponseClass());
        try {
            Connection.connection.context = HttpClientContext.create();
            if (connection.getCookieStore() != null) {
                Connection.connection.context.setCookieStore(connection.getCookieStore());
            }
            HttpResponse httpResponse = Connection.connection.httpclient.execute((HttpUriRequest)getAccess.getRequest(), (HttpContext)Connection.connection.context);
            response = response.setHttpResponse(httpResponse);
            Connection.fireIObject(response);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void getCameraSchedule() {
        if (Connection.connection.httpclient == null) {
            Connection.connection.httpclient = HttpClients.createDefault();
        }
        GetCameraSchedule camSched = new GetCameraSchedule();
        Camera_List_Object kamera = APIStorage.getCameraMap().get(2);
        camSched.setCameraId(kamera.getCameraId());
        Response response = Response.getResponesObject(camSched.getResponseClass());
        try {
            Connection.connection.context = HttpClientContext.create();
            if (connection.getCookieStore() != null) {
                Connection.connection.context.setCookieStore(connection.getCookieStore());
            }
            HttpResponse httpResponse = Connection.connection.httpclient.execute((HttpUriRequest)camSched.getRequest(), (HttpContext)Connection.connection.context);
            response = response.setHttpResponse(httpResponse);
            Connection.fireIObject(response);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void start3rdLiveStream(int kameraRawId) {
        if (Connection.connection.httpclient == null) {
            Connection.connection.httpclient = HttpClients.createDefault();
        }
        Stream st = new Stream();
        Camera_List_Object kamera = APIStorage.getCameraMap().get(kameraRawId);
        st.setCameraID(kamera.getCameraId());
        try {
            HttpResponse httpResponse;
            Header[] temp;
            String boundaryItem;
            Connection.connection.context = HttpClientContext.create();
            if (connection.getCookieStore() != null) {
                Connection.connection.context.setCookieStore(connection.getCookieStore());
            }
            if ((boundaryItem = Tools.getBoundaryValue(temp = (httpResponse = Connection.connection.httpclient.execute((HttpUriRequest)st.getRequest(), (HttpContext)Connection.connection.context)).getAllHeaders())) != null) {
                HttpEntity entity = httpResponse.getEntity();
                InputStream in = entity.getContent();
                MJPEGThread3 thread = new MJPEGThread3(in, kamera.getCameraId(), boundaryItem);
                thread.start();
            }
            int i = 0;
            while (i < temp.length) {
                System.out.println("header " + temp[i].toString());
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void moveToWithOwnId(long kameraid_software, DirectionPTZ directPTZ, MoveTypePTZ moveTypePTZ) {
        java.util.List<CameraObject> gespeicherteKameras = SettingStorage.readCameraObjectList();
        int i = 0;
        while (i < gespeicherteKameras.size()) {
            if (gespeicherteKameras.get(i).getKameraid_software() == kameraid_software) {
                Connection.moveTo(gespeicherteKameras.get(i).getKameraid().getRawCameraId(), directPTZ, moveTypePTZ);
                break;
            }
            ++i;
        }
    }

    private static void moveTo(int kameraRawId, DirectionPTZ directPTZ, MoveTypePTZ moveTypePTZ) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            Camera_List_Object cameraListObject = APIStorage.getCameraMap().get(kameraRawId);
            if (cameraListObject == null) {
                throw new Exception();
            }
            Move move = new Move();
            move.setSpeed(1);
            move.setDirectionPTZ(directPTZ);
            move.setMoveTypePTZ(moveTypePTZ);
            move.setCameraID(cameraListObject.getCameraId());
            HttpClientContext clientContext = HttpClientContext.create();
            if (connection.getCookieStore() != null) {
                clientContext.setCookieStore(connection.getCookieStore());
            }
            httpClient.execute((HttpUriRequest)move.getRequest(), (HttpContext)clientContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void homeWithOwnId(long kameraid_software) {
        java.util.List<CameraObject> gespeicherteKameras = SettingStorage.readCameraObjectList();
        int i = 0;
        while (i < gespeicherteKameras.size()) {
            if (gespeicherteKameras.get(i).getKameraid_software() == kameraid_software) {
                Connection.home(gespeicherteKameras.get(i).getKameraid().getRawCameraId());
                break;
            }
            ++i;
        }
    }

    public static void home(int kameraRawId) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            Camera_List_Object cameraListObject = APIStorage.getCameraMap().get(kameraRawId);
            if (cameraListObject == null) {
                throw new Exception();
            }
            Home move = new Home();
            move.setCameraObject(cameraListObject.getCameraId());
            HttpClientContext clientContext = HttpClientContext.create();
            if (connection.getCookieStore() != null) {
                clientContext.setCookieStore(connection.getCookieStore());
            }
            httpClient.execute((HttpUriRequest)move.getRequest(), (HttpContext)clientContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void zoomToWithOwnId(long kameraid_software, ControlPTZ controlPTZ, MoveTypePTZ moveType) {
        java.util.List<CameraObject> gespeicherteKameras = SettingStorage.readCameraObjectList();
        int i = 0;
        while (i < gespeicherteKameras.size()) {
            if (gespeicherteKameras.get(i).getKameraid_software() == kameraid_software) {
                Connection.zoomTo(gespeicherteKameras.get(i).getKameraid().getRawCameraId(), controlPTZ, moveType);
                break;
            }
            ++i;
        }
    }

    private static void zoomTo(int rawCameraId, ControlPTZ controlPTZ, MoveTypePTZ moveType) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            Camera_List_Object cameraListObject = APIStorage.getCameraMap().get(rawCameraId);
            if (cameraListObject == null) {
                throw new Exception();
            }
            Zoom zoom = new Zoom();
            zoom.setCameraObject(cameraListObject.getCameraId());
            zoom.setControl(controlPTZ);
            zoom.setMoveTypePTZ(moveType);
            HttpClientContext clientContext = HttpClientContext.create();
            if (connection.getCookieStore() != null) {
                clientContext.setCookieStore(connection.getCookieStore());
            }
            httpClient.execute((HttpUriRequest)zoom.getRequest(), (HttpContext)clientContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void focusWithOwnId(long kameraid_software, ControlPTZ controlPTZ, MoveTypePTZ moveType) {
        java.util.List<CameraObject> gespeicherteKameras = SettingStorage.readCameraObjectList();
        int i = 0;
        while (i < gespeicherteKameras.size()) {
            if (gespeicherteKameras.get(i).getKameraid_software() == kameraid_software) {
                Connection.focus(gespeicherteKameras.get(i).getKameraid().getRawCameraId(), controlPTZ, moveType);
                break;
            }
            ++i;
        }
    }

    private static void focus(int rawCameraId, ControlPTZ controlPTZ, MoveTypePTZ moveType) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            Camera_List_Object cameraListObject = APIStorage.getCameraMap().get(rawCameraId);
            if (cameraListObject == null) {
                throw new Exception();
            }
            Focus focus = new Focus();
            focus.setCameraObject(cameraListObject.getCameraId());
            focus.setControl(controlPTZ);
            focus.setMoveTypePTZ(moveType);
            HttpClientContext clientContext = HttpClientContext.create();
            if (connection.getCookieStore() != null) {
                clientContext.setCookieStore(connection.getCookieStore());
            }
            httpClient.execute((HttpUriRequest)focus.getRequest(), (HttpContext)clientContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean getCameraSnapShotWithOwnId(long kameraid_software) {
        java.util.List<CameraObject> gespeicherteKameras = SettingStorage.readCameraObjectList();
        int i = 0;
        while (i < gespeicherteKameras.size()) {
            if (gespeicherteKameras.get(i).getKameraid_software() == kameraid_software) {
                return Connection.getCameraSnapShot(gespeicherteKameras.get(i).getKameraid().getRawCameraId());
            }
            ++i;
        }
        return false;
    }

    private static boolean getCameraSnapShot(int rawCameraId) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            GetSnapshot gs = new GetSnapshot();
            Camera_List_Object kamera = APIStorage.getCameraMap().get(rawCameraId);
            gs.setCameraId(kamera.getCameraId());
            GetSnapshotResponse response = (GetSnapshotResponse)Response.getResponesObject(gs.getResponseClass());
            response.setCameraID(kamera.getCameraId());
            HttpClientContext clientContext = HttpClientContext.create();
            if (connection.getCookieStore() != null) {
                clientContext.setCookieStore(connection.getCookieStore());
            }
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)gs.getRequest(), (HttpContext)clientContext);
            response = (GetSnapshotResponse)response.setHttpResponse(httpResponse);
            Connection.fireIObject(response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean externalRecordingWithOwnId(long kameraid_software, ActionType actionType) {
        java.util.List<CameraObject> gespeicherteKameras = SettingStorage.readCameraObjectList();
        int i = 0;
        while (i < gespeicherteKameras.size()) {
            if (gespeicherteKameras.get(i).getKameraid_software() == kameraid_software) {
                return Connection.externalRecording(gespeicherteKameras.get(i).getKameraid().getRawCameraId(), actionType);
            }
            ++i;
        }
        return false;
    }

    private static boolean externalRecording(int rawCameraId, ActionType actionType) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            HttpResponse httpResponse;
            Camera_List_Object cameraListObject = APIStorage.getCameraMap().get(rawCameraId);
            if (cameraListObject == null) {
                throw new Exception();
            }
            Record record = new Record();
            RecordResponse recordResponse = (RecordResponse)Response.getResponesObject(record.getResponseClass());
            record.setCameraObject(cameraListObject.getCameraId());
            record.setActionType(actionType);
            HttpClientContext clientContext = HttpClientContext.create();
            if (connection.getCookieStore() != null) {
                clientContext.setCookieStore(connection.getCookieStore());
            }
            if ((httpResponse = httpClient.execute((HttpUriRequest)record.getRequest(), (HttpContext)clientContext)) != null && (recordResponse = (RecordResponse)recordResponse.setHttpResponse(httpResponse)) != null) {
                return recordResponse.isSuccess();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean startExternalMotionDetectionWithOwnId(long kameraid_software) {
        java.util.List<CameraObject> gespeicherteKameras = SettingStorage.readCameraObjectList();
        int i = 0;
        while (i < gespeicherteKameras.size()) {
            if (gespeicherteKameras.get(i).getKameraid_software() == kameraid_software) {
                return Connection.startExternalMotionDetection(gespeicherteKameras.get(i));
            }
            ++i;
        }
        return false;
    }

    private static boolean startExternalMotionDetection(CameraObject cameraObject) {
        String entryPointValue = cameraObject.getEntryPointMotionDetection();
        if (entryPointValue != null && entryPointValue.length() > 0) {
            if (Connection.connection.motionServiceAPI != null) {
                Connection.connection.motionServiceAPI.registerEndpoint(entryPointValue);
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean stopExternalMotionDetectionWithOwnId(long kameraid_software) {
        java.util.List<CameraObject> gespeicherteKameras = SettingStorage.readCameraObjectList();
        int i = 0;
        while (i < gespeicherteKameras.size()) {
            if (gespeicherteKameras.get(i).getKameraid_software() == kameraid_software) {
                return Connection.stopExternalMotionDetection(gespeicherteKameras.get(i));
            }
            ++i;
        }
        return false;
    }

    private static boolean stopExternalMotionDetection(CameraObject cameraObject) {
        String entryPointValue = cameraObject.getEntryPointMotionDetection();
        if (entryPointValue != null && entryPointValue.length() > 0) {
            if (Connection.connection.motionServiceAPI != null) {
                Connection.connection.motionServiceAPI.deRegisterEndpoint(entryPointValue);
                return true;
            }
            return false;
        }
        return false;
    }
}

