/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.iroom.utils.range;

import de.bscgmbh.iroom.utils.range.IRangeLimitation;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class EnumRange<E extends Enum<E>>
implements IRangeLimitation<E> {
    private static final long serialVersionUID = -7832243284975796433L;
    private final LinkedHashSet<E> allowedValues;
    private final Class<E> clazz;

    public EnumRange(Set<E> allowedValues, Class<E> clazz) {
        Objects.requireNonNull(allowedValues, "allowedValues must not be null");
        this.allowedValues = new LinkedHashSet<E>(allowedValues);
        this.clazz = clazz;
    }

    public EnumRange(Set<E> allowedValues) {
        this(allowedValues, ((Enum)allowedValues.iterator().next()).getClass());
    }

    public LinkedHashSet<E> getAllowedValues() {
        return this.allowedValues;
    }

    @Override
    public boolean isValueInRange(E value) {
        if (value != null) {
            return this.allowedValues.contains(value);
        }
        return false;
    }

    @Override
    public Class<E> getValueClass() {
        return this.clazz;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allowedValues == null ? 0 : this.allowedValues.hashCode());
        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumRange other = (EnumRange)obj;
        if (this.allowedValues == null ? other.allowedValues != null : !this.allowedValues.equals(other.allowedValues)) {
            return false;
        }
        return !(this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz));
    }

    public String toString() {
        return "EnumRange [allowedValues=" + this.allowedValues + ", clazz=" + this.clazz + "]";
    }
}

