/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.iroom.sdk.controller;

import de.bscgmbh.iroom.sdk.controller.IRoomConnection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRoomConnector
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(IRoomConnector.class);
    private IRoomConnection connection;
    private boolean reconnect = false;
    private long delay = 250L;

    public IRoomConnector(IRoomConnection connection) {
        this.setConnection(connection);
    }

    public IRoomConnector(IRoomConnection connection, long delay, boolean reconnect) {
        this.setConnection(connection);
        this.delay = delay;
        this.reconnect = reconnect;
    }

    private void setConnection(IRoomConnection connection) {
        this.connection = Objects.requireNonNull(connection, "connection must not be null!");
    }

    @Override
    public void run() {
        try {
            Thread.sleep(this.delay);
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (this.reconnect) {
            this.connection.reconnect();
        } else {
            this.connection.connect();
        }
    }
}

