/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.iroom.sdk;

import bsc.sdk.kernel.AApplicationKernel;
import de.bscgmbh.iroom.api.data.types.CommandEnum;
import de.bscgmbh.iroom.api.data.types.StateValueEnum;
import de.bscgmbh.iroom.api.factory.CommandFactory;
import de.bscgmbh.iroom.sdk.controller.IRoomConnection;
import de.bscgmbh.iroom.sdk.controller.IRoomConnector;
import de.bscgmbh.iroom.sdk.msg.AIRoomConnectionObject;
import de.bscgmbh.iroom.sdk.msg.commands.IRoomSetRelayState;
import de.bscgmbh.iroom.sdk.msg.commands.IRoomSetVolume;
import de.bscgmbh.iroom.sdk.msg.controller.IRoomRefreshConnectionDeviceData;
import de.bscgmbh.iroom.sdk.msg.controller.IRoomRegisterConnection;
import de.bscgmbh.iroom.sdk.msg.controller.IRoomUnRegisterConnection;
import de.bscgmbh.iroom.sdk.msg.device.IRoomDiscoverDeviceProperties;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.engio.mbassy.bus.publication.SyncAsyncPostCommand;
import net.engio.mbassy.listener.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRoomController
extends AApplicationKernel.KernelModule {
    protected int WATCHDOG_INTERVAL = 5;
    protected IRoomConnectionWatchdog watchdog = null;
    protected Map<String, IRoomConnection> connections = null;

    public IRoomController(AApplicationKernel kernel) {
        super(kernel);
    }

    public void unload() {
        this.unregisterAllConnections();
        this.connections = null;
    }

    public void init() {
        this.connections = new HashMap<String, IRoomConnection>();
        this.watchdog = new IRoomConnectionWatchdog();
        this.backgroundScheduleAtFixedDelay(this.watchdog, 1L, 3L, TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Handler
    protected void registerConnection(IRoomRegisterConnection msg) {
        if (this.connections == null) {
            return;
        }
        String connectionID = IRoomConnection.generateConnectionID(msg.getHost(), msg.getPort());
        if (connectionID != null) {
            Map<String, IRoomConnection> map = this.connections;
            synchronized (map) {
                if (!this.connections.containsKey(connectionID)) {
                    try {
                        IRoomConnection connection = new IRoomConnection(this, msg.getHost(), msg.getPort());
                        this.connections.put(connectionID, connection);
                        this.backgroundExecute(new IRoomConnector(connection));
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    this.logger.debug("New connection registered: " + msg);
                } else {
                    this.logger.debug("Existing connection reused: " + msg);
                }
            }
            msg.setConnectionID(connectionID);
        }
    }

    @Handler
    protected void unregisterConnection(IRoomUnRegisterConnection msg) {
        if (this.connections == null) {
            return;
        }
        if (msg.getConnectionID() != null) {
            msg.setUnregistered(true);
            this.unregisterConnection(msg.getConnectionID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Handler
    protected void discoverDeviceProperties(IRoomDiscoverDeviceProperties msg) {
        if (msg != null && msg.getConnectionID() != null) {
            IRoomConnection connection = null;
            Map<String, IRoomConnection> map = this.connections;
            synchronized (map) {
                connection = this.connections.get(msg.getConnectionID());
            }
            msg.setProperties(connection.discoverProperties(msg.getSecondsToSearch()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Handler
    protected void setConnectionRelayState(IRoomSetRelayState msg) {
        if (msg != null && msg.getConnectionID() != null) {
            IRoomConnection connection = null;
            Map<String, IRoomConnection> map = this.connections;
            synchronized (map) {
                connection = this.connections.get(msg.getConnectionID());
            }
            if (msg.getChannel() == 0) {
                StateValueEnum state = null;
                switch (msg.getState()) {
                    case CLOSED: {
                        state = StateValueEnum.CLOSE;
                        break;
                    }
                    case OPEN: {
                        state = StateValueEnum.OPEN;
                    }
                }
                if (state != null) {
                    connection.sendCommand(CommandFactory.getCommand(CommandEnum.RELAY_0, state));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Handler
    protected void setConnectionVolume(IRoomSetVolume msg) {
        if (msg != null && msg.getConnectionID() != null) {
            IRoomConnection connection = null;
            Map<String, IRoomConnection> map = this.connections;
            synchronized (map) {
                connection = this.connections.get(msg.getConnectionID());
            }
            int volume = msg.getVolume();
            if (volume < 0) {
                volume = 0;
            } else if (volume > 100) {
                volume = 100;
            }
            connection.sendCommand(CommandFactory.getCommand(CommandEnum.VOLUME_CONTROL, Integer.valueOf(volume)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterConnection(String connectionID) {
        if (this.connections == null || connectionID == null) {
            return;
        }
        IRoomConnection connection = null;
        Map<String, IRoomConnection> map = this.connections;
        synchronized (map) {
            connection = this.connections.remove(connectionID);
        }
        if (connection != null) {
            connection.shutdown();
            this.logger.debug("Unregistered connection: " + connectionID);
        } else {
            this.logger.debug("Nothing to unregister: " + connectionID);
        }
    }

    @Handler
    public void refreshConnectionDeviceData(IRoomRefreshConnectionDeviceData msg) {
        IRoomConnection connection;
        if (msg != null && (connection = this.connections.get(msg.getConnectionID())) != null) {
            connection.forceDeviceDataRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void unregisterAllConnections() {
        if (this.connections == null) {
            return;
        }
        HashSet<String> connectionIDs = new HashSet<String>();
        Map<String, IRoomConnection> map = this.connections;
        synchronized (map) {
            connectionIDs.addAll(this.connections.keySet());
        }
        for (String connectionID : connectionIDs) {
            this.unregisterConnection(connectionID);
        }
    }

    public void publishIRoomObject(AIRoomConnectionObject object, boolean asynchron) {
        SyncAsyncPostCommand post = this.postKernelMessage(Objects.requireNonNull(object, "object must not be null!"));
        if (asynchron) {
            post.asynchronously();
        } else {
            post.now();
        }
    }

    public void executeInBackground(Runnable runnable) {
        this.backgroundExecute(runnable);
    }

    protected class IRoomConnectionWatchdog
    implements Runnable {
        protected Logger logger = LoggerFactory.getLogger(this.getClass());
        protected Collection<IRoomConnection> tmpConnections = new HashSet<IRoomConnection>();

        protected IRoomConnectionWatchdog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<String, IRoomConnection> map = IRoomController.this.connections;
            synchronized (map) {
                this.tmpConnections.addAll(IRoomController.this.connections.values());
                this.logger.debug("Perform connection check for " + this.tmpConnections.size() + " iRoom servers");
            }
            for (IRoomConnection iRoomConnection : this.tmpConnections) {
                this.logger.trace(iRoomConnection.getId() + " -> connected=" + iRoomConnection.isConnected());
                if (!iRoomConnection.isReady() || iRoomConnection.isConnected()) continue;
                this.logger.debug(iRoomConnection.getId() + " is not connected, try reconnect...");
                iRoomConnection.reconnect();
            }
            this.tmpConnections.clear();
        }
    }
}

